/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.choreography;

import java.util.ArrayList;
import org.eclipse.bpmn2.Choreography;
import org.eclipse.bpmn2.ChoreographyTask;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.InteractionNode;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.model.ModelHandler;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.choreography.Messages;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.util.ui.PopupMenu;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class AddChoreographyMessageFeature
extends AbstractCustomFeature {
    protected boolean changesDone = false;
    private static ILabelProvider labelProvider = new ILabelProvider(){

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getText(Object element) {
            return ChoreographyUtil.getMessageName((Message)((Message)element));
        }

        public Image getImage(Object element) {
            return null;
        }
    };

    public AddChoreographyMessageFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return Messages.AddChoreographyMessageFeature_Name;
    }

    public String getDescription() {
        return Messages.AddChoreographyMessageFeature_Description;
    }

    public String getImageId() {
        return ImageProvider.IMG_16_ADD_MESSAGE;
    }

    public boolean isAvailable(IContext context) {
        return true;
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            PictogramElement pe = pes[0];
            Object bo = this.getBusinessObjectForPictogramElement(pe);
            if (pe instanceof ContainerShape && bo instanceof Participant) {
                ChoreographyTask choreographyTask;
                Participant participant = (Participant)bo;
                Object parent = this.getBusinessObjectForPictogramElement((PictogramElement)((ContainerShape)pe).getContainer());
                if (parent instanceof ChoreographyTask && (choreographyTask = (ChoreographyTask)parent).getParticipantRefs().size() == 2) {
                    for (MessageFlow mf : choreographyTask.getMessageFlowRef()) {
                        if (mf.getSourceRef() == null || !mf.getSourceRef().equals(participant)) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void execute(ICustomContext context) {
        PictogramElement pe = context.getPictogramElements()[0];
        ContainerShape participantShape = (ContainerShape)pe;
        ContainerShape choreographyTaskShape = (ContainerShape)participantShape.eContainer();
        Participant participant = (Participant)this.getBusinessObjectForPictogramElement((PictogramElement)participantShape);
        ChoreographyTask choreographyTask = (ChoreographyTask)this.getBusinessObjectForPictogramElement((PictogramElement)choreographyTaskShape);
        Definitions definitions = ModelUtil.getDefinitions((Object)choreographyTask);
        ModelHandler mh = ModelHandler.getInstance((EObject)choreographyTask);
        Message message = (Message)Bpmn2ModelerFactory.create(Message.class);
        String oldName = message.getName();
        message.setName(Messages.AddChoreographyMessageFeature_New);
        message.setId(null);
        ArrayList<Message> messageList = new ArrayList<Message>();
        messageList.add(message);
        messageList.addAll(ModelUtil.getAllRootElements((Definitions)definitions, Message.class));
        Message result = message;
        if (messageList.size() > 1) {
            PopupMenu popupMenu = new PopupMenu(messageList, labelProvider);
            this.changesDone = popupMenu.show((Control)Display.getCurrent().getActiveShell());
            if (this.changesDone) {
                result = (Message)popupMenu.getResult();
            } else {
                EcoreUtil.delete((EObject)message);
                message = null;
            }
        } else {
            this.changesDone = true;
        }
        if (this.changesDone) {
            if (result == message) {
                definitions.getRootElements().add(message);
                message.setId(null);
                ModelUtil.setID((EObject)message);
                message.setName(oldName);
            } else {
                message = result;
            }
            Participant otherParticipant = choreographyTask.getParticipantRefs().get(0) == participant ? (Participant)choreographyTask.getParticipantRefs().get(1) : (Participant)choreographyTask.getParticipantRefs().get(0);
            MessageFlow messageFlow = mh.createMessageFlow((InteractionNode)participant, (InteractionNode)otherParticipant);
            messageFlow.setName(ModelUtil.toCanonicalString((String)messageFlow.getId()));
            Choreography choreography = (Choreography)choreographyTask.eContainer();
            choreography.getMessageFlows().add(messageFlow);
            messageFlow.setMessageRef(message);
            choreographyTask.getMessageFlowRef().add(messageFlow);
            BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)participantShape, BPMNShape.class);
            bpmnShape.setIsMessageVisible(true);
            UpdateContext updateContext = new UpdateContext((PictogramElement)choreographyTaskShape);
            this.getFeatureProvider().updateIfPossible((IUpdateContext)updateContext);
        }
    }

    public boolean hasDoneChanges() {
        return this.changesDone;
    }
}

