/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.modeler.core.adapters.AdapterRegistry;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractBpmn2PropertySection;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.DefaultDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.PropertiesCompositeFactory;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.property.Messages;
import org.eclipse.bpmn2.modeler.ui.property.PropertyTreeContentProvider;
import org.eclipse.bpmn2.modeler.ui.util.PropertyUtil;
import org.eclipse.bpmn2.provider.Bpmn2ItemProviderAdapterFactory;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.Section;

public class AdvancedDetailComposite
extends AbstractDetailComposite {
    private TreeViewer treeViewer;
    private AbstractDetailComposite detailsDetailComposite;
    private Section treeSection;
    private Section detailsSection;
    private Composite detailsComposite;
    private Button fullDetails;
    private HashSet<Control> myChildren = new HashSet();

    public AdvancedDetailComposite(AbstractBpmn2PropertySection section) {
        super(section);
    }

    public AdvancedDetailComposite(Composite parent, int style) {
        super(parent, style);
    }

    public void initialize() {
        super.initialize();
        SashForm sashForm = new SashForm((Composite)this, 2048);
        sashForm.setSashWidth(5);
        this.toolkit.adapt((Composite)sashForm);
        this.toolkit.paintBordersFor((Composite)sashForm);
        GridData data = new GridData(4, 4, true, true, 3, 1);
        data.widthHint = 800;
        sashForm.setLayoutData((Object)data);
        this.treeSection = this.toolkit.createSection((Composite)sashForm, 256);
        this.toolkit.paintBordersFor((Composite)this.treeSection);
        Composite composite = this.toolkit.createComposite((Composite)this.treeSection, 0);
        this.toolkit.paintBordersFor(composite);
        this.treeSection.setClient((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.treeViewer = new TreeViewer(composite, 2048);
        Tree tree = this.treeViewer.getTree();
        data = new GridData(4, 4, false, true, 1, 1);
        tree.setLayoutData((Object)data);
        this.toolkit.paintBordersFor((Composite)tree);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AdvancedDetailComposite.this.updateDetailsSection();
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new PropertyTreeContentProvider(this));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)AdapterRegistry.getLabelProvider());
        this.detailsSection = this.toolkit.createSection((Composite)sashForm, 256);
        this.toolkit.paintBordersFor((Composite)this.detailsSection);
        this.detailsSection.setText(Messages.AdvancedDetailComposite_Properties_Title);
        this.detailsComposite = this.toolkit.createComposite((Composite)this.detailsSection);
        this.detailsComposite.setLayout((Layout)new GridLayout(1, false));
        this.detailsSection.setClient((Control)this.detailsComposite);
        this.fullDetails = this.toolkit.createButton(this.detailsComposite, Messages.AdvancedDetailComposite_Advanced_Button, 32);
        data = new GridData(16384, 128, false, false, 1, 1);
        data.exclude = true;
        this.fullDetails.setLayoutData((Object)data);
        this.fullDetails.setVisible(false);
        this.fullDetails.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EObject obj = AdvancedDetailComposite.this.getSelectedBaseElement();
                if (obj != null) {
                    AdvancedDetailComposite.this.updateDetailsSection();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        sashForm.setWeights(new int[]{1, 2});
    }

    private void saveChildren(Control parent) {
        this.myChildren.add(parent);
        if (parent instanceof Composite) {
            Control[] children;
            Control[] controlArray = children = ((Composite)parent).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                this.myChildren.add(c);
                this.saveChildren(c);
                ++n2;
            }
        }
    }

    private void disposeDetailsChildren(Composite parent) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (!this.myChildren.contains(c)) {
                if (!(c instanceof Sash)) {
                    c.dispose();
                }
            } else if (c instanceof Composite) {
                this.disposeDetailsChildren((Composite)c);
            }
            ++n2;
        }
    }

    private void updateDetailsSection() {
        if (this.myChildren.size() == 0) {
            this.saveChildren((Control)this.getParent());
        }
        this.disposeDetailsChildren(this.getParent());
        EObject obj = this.getSelectedBaseElement();
        if (obj == null) {
            this.detailsSection.layout(true);
            this.detailsSection.setVisible(false);
        } else {
            this.detailsDetailComposite = this.fullDetails.getSelection() ? new DefaultDetailComposite(this.detailsComposite, 0) : PropertiesCompositeFactory.INSTANCE.createDetailComposite(obj.getClass(), this.detailsComposite, 0);
            this.detailsDetailComposite.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
            Class cc = PropertiesCompositeFactory.findDetailCompositeClass(obj.getClass());
            if (cc == null || cc == DefaultDetailComposite.class) {
                this.fullDetails.setVisible(false);
            } else {
                this.fullDetails.setVisible(true);
            }
            this.detailsComposite.layout(true);
            this.detailsDetailComposite.setPropertySection(this.propertySection);
            this.toolkit.adapt((Composite)this.detailsDetailComposite);
            this.toolkit.paintBordersFor((Composite)this.detailsDetailComposite);
            this.detailsSection.layout(true);
            this.detailsDetailComposite.setBusinessObject(obj);
            String name = ExtendedPropertiesProvider.getTextValue((EObject)obj);
            this.detailsSection.setText(String.valueOf(name) + Messages.AdvancedDetailComposite_Details_Title);
            this.detailsSection.setVisible(true);
            this.redrawPage();
        }
    }

    public void createBindings(EObject be) {
    }

    protected void cleanBindings() {
    }

    public void setBusinessObject(EObject be) {
        super.setBusinessObject(be);
        EObject input = be;
        while (input.eContainer() != null) {
            if (input instanceof Definitions) break;
            input = input.eContainer();
        }
        if (input != null) {
            this.treeViewer.setInput((Object)input);
            this.treeViewer.expandAll();
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)be), true);
        } else {
            this.treeViewer.setInput((Object)be);
        }
        this.hookPropertySheetPageMenu();
        this.treeSection.setText(ExtendedPropertiesProvider.getTextValue((EObject)be));
        this.detailsSection.setVisible(true);
    }

    private void hookPropertySheetPageMenu() {
        MenuManager manager = new MenuManager("#PropertiesMenu");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                AdvancedDetailComposite.this.buildMenu((MenuManager)manager);
            }
        });
        Tree tree = this.treeViewer.getTree();
        Menu menu = manager.createContextMenu((Control)tree);
        tree.setMenu(menu);
        this.getDiagramEditor().getSite().registerContextMenu("#PropertiesMenu", manager, (ISelectionProvider)this.treeViewer);
    }

    protected void buildMenu(MenuManager manager) {
        EObject selectedElem = this.getSelectedBaseElement();
        this.createElementProperties(manager, selectedElem);
        manager.add((IContributionItem)new Separator("additions"));
        if (selectedElem != null) {
            manager.add((IAction)this.createRemoveAction(selectedElem));
        }
        manager.add((IContributionItem)new Separator("additions"));
        this.createRootProperties(manager);
    }

    private void createRootProperties(MenuManager menuManager) {
        MenuManager manager = new MenuManager("Add Root Property");
        menuManager.add((IContributionItem)manager);
        this.createMenuItems(manager, "", this.businessObject, true);
    }

    private void createElementProperties(MenuManager manager, EObject baseElement) {
        if (baseElement != null) {
            this.createMenuItems(manager, Messages.AdvancedDetailComposite_Add_Action, baseElement, false);
        }
    }

    private void createMenuItems(MenuManager manager, String prefix, EObject baseElement, boolean root) {
        ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)new Bpmn2ItemProviderAdapterFactory().adapt((Notifier)baseElement, ItemProviderAdapter.class);
        if (itemProviderAdapter == null) {
            return;
        }
        Collection desc = itemProviderAdapter.getNewChildDescriptors((Object)baseElement, (EditingDomain)this.getDiagramEditor().getEditingDomain(), null);
        EList eAllContainments = baseElement.eClass().getEAllContainments();
        ArrayList<Action> items = new ArrayList<Action>();
        for (CommandParameter command : desc) {
            Action item;
            String featureName;
            String name;
            Object value;
            EStructuralFeature feature = (EStructuralFeature)command.feature;
            EObject commandValue = null;
            if (command.value instanceof EStructuralFeatureImpl.BasicFeatureMapEntry) {
                EStructuralFeatureImpl.BasicFeatureMapEntry entry = (EStructuralFeatureImpl.BasicFeatureMapEntry)command.value;
                feature = entry.getEStructuralFeature();
                commandValue = (EObject)entry.getValue();
            } else if (command.value instanceof EObject) {
                commandValue = (EObject)command.value;
            }
            if (root) {
                if (!eAllContainments.contains((Object)feature) || !this.isModelObjectEnabled(commandValue.eClass())) continue;
                value = baseElement.eGet(feature);
                name = PropertyUtil.deCamelCase(commandValue.eClass().getName());
                if ((name.equalsIgnoreCase("SingleAssignment") || name.equalsIgnoreCase("Formal SingleAssignment")) && feature.getName() != null && !feature.getName().isEmpty()) {
                    featureName = PropertyUtil.deCamelCase(String.valueOf(' ') + feature.getName());
                    featureName = String.valueOf(featureName.substring(0, 1).toUpperCase()) + featureName.substring(1);
                    name = String.valueOf(featureName) + ' ' + name;
                }
                item = this.createMenuItemFor(String.valueOf(prefix) + name, baseElement, (EReference)feature, command.value);
                item.setEnabled(value == null || value instanceof EList);
                items.add(item);
                continue;
            }
            if (!eAllContainments.contains((Object)feature) || !this.isModelObjectEnabled(baseElement.eClass(), feature) || !this.isModelObjectEnabled(commandValue.eClass())) continue;
            value = baseElement.eGet(feature);
            name = PropertyUtil.deCamelCase(commandValue.eClass().getName());
            if ((name.equalsIgnoreCase("SingleAssignment") || name.equalsIgnoreCase("Formal SingleAssignment")) && feature.getName() != null && !feature.getName().isEmpty()) {
                featureName = PropertyUtil.deCamelCase(String.valueOf(' ') + feature.getName());
                featureName = String.valueOf(featureName.substring(0, 1).toUpperCase()) + featureName.substring(1);
                name = String.valueOf(featureName) + ' ' + name;
            }
            item = this.createMenuItemFor(String.valueOf(prefix) + name, baseElement, (EReference)feature, command.value);
            item.setEnabled(value == null || value instanceof EList);
            items.add(item);
        }
        Collections.sort(items, new Comparator<Action>(){

            @Override
            public int compare(Action a1, Action a2) {
                return a1.getText().compareToIgnoreCase(a2.getText());
            }
        });
        for (Action a : items) {
            manager.add((IAction)a);
        }
    }

    private Action createMenuItemFor(String prefix, final EObject baseElement, final EReference eReference, final Object value) {
        return new Action(prefix){

            public void run() {
                TransactionalEditingDomain domain = AdvancedDetailComposite.this.getDiagramEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        this.createNewProperty(baseElement, eReference);
                    }

                    private void createNewProperty(EObject baseElement2, EReference eReference2) {
                        BaseElement e;
                        Object eGet = baseElement2.eGet((EStructuralFeature)eReference2);
                        if (value instanceof BaseElement && (e = (BaseElement)value).getId() == null) {
                            ModelUtil.setID((EObject)e, (Resource)baseElement2.eResource());
                        }
                        if (eGet instanceof EList) {
                            ((EList)eGet).add(value);
                        } else {
                            baseElement2.eSet((EStructuralFeature)eReference2, value);
                        }
                        AdvancedDetailComposite.this.treeViewer.refresh(true);
                    }
                });
            }
        };
    }

    private EObject getSelectedBaseElement() {
        Object firstElement;
        ISelection selection = this.treeViewer.getSelection();
        EObject baseElement = null;
        if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof EObject) {
            baseElement = (EObject)firstElement;
        }
        return baseElement;
    }

    private Action createRemoveAction(final EObject baseElement) {
        return new Action(Messages.AdvancedDetailComposite_Remove_Action){

            public void run() {
                if (baseElement == null) {
                    AdvancedDetailComposite.this.treeViewer.refresh(true);
                    return;
                }
                final EObject container = baseElement.eContainer();
                final Object eGet = container.eGet(baseElement.eContainingFeature());
                TransactionalEditingDomain domain = AdvancedDetailComposite.this.getDiagramEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        List pictogramElements = GraphitiUi.getLinkService().getPictogramElements(AdvancedDetailComposite.this.getDiagramEditor().getDiagramTypeProvider().getDiagram(), baseElement);
                        if (eGet instanceof EList) {
                            ((EList)eGet).remove((Object)baseElement);
                        } else {
                            container.eUnset(baseElement.eContainingFeature());
                        }
                        for (PictogramElement pictogramElement : pictogramElements) {
                            pictogramElement.getLink().getBusinessObjects().clear();
                        }
                        AdvancedDetailComposite.this.treeViewer.refresh(true);
                    }
                });
            }
        };
    }
}

