/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.modeler.core.adapters.IExtensionValueAdapter;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class StyleChangeAdapter
extends AdapterImpl
implements IExtensionValueAdapter {
    private BaseElement businessObject;
    private PictogramElement pictogramElement;

    public static void adapt(PictogramElement pe) {
        EObject be = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)pe);
        if (be instanceof BaseElement && ShapeStyle.hasStyle((BaseElement)((BaseElement)be))) {
            for (Adapter a : be.eAdapters()) {
                if (!(a instanceof StyleChangeAdapter)) continue;
                return;
            }
            StyleChangeAdapter adapter = new StyleChangeAdapter(pe, (BaseElement)be);
            be.eAdapters().add((Object)adapter);
            adapter.updateStyle(null);
        }
    }

    private StyleChangeAdapter(PictogramElement pe, BaseElement be) {
        this.businessObject = be;
        this.pictogramElement = pe;
        for (ExtensionAttributeValue x : be.getExtensionValues()) {
            for (FeatureMap.Entry v : x.getValue()) {
                if (!v.getEStructuralFeature().getName().equals("style")) continue;
                EObject style = (EObject)v.getValue();
                style.eAdapters().add((Object)this);
            }
        }
    }

    public void notifyChanged(Notification msg) {
        Object newValue = msg.getNewValue();
        if (msg.getEventType() == 3 && newValue instanceof ExtensionAttributeValue) {
            ((EObject)newValue).eAdapters().add((Object)this);
            EObject style = ShapeStyle.getStyleObject((BaseElement)this.businessObject);
            if (style != null) {
                style.eAdapters().add((Object)this);
                this.updateStyle(newValue);
            }
        } else if (msg.getEventType() == 3 && ShapeStyle.isStyleObject((Object)newValue)) {
            ((EObject)newValue).eAdapters().add((Object)this);
        } else if (ShapeStyle.isStyleObject((Object)msg.getNotifier())) {
            this.updateStyle(newValue);
        }
    }

    private void updateStyle(Object newValue) {
        if (this.businessObject.eResource() == null || this.pictogramElement.eResource() == null) {
            return;
        }
        ShapeStyle ss = ShapeStyle.getShapeStyle((BaseElement)this.businessObject);
        GraphicsAlgorithm ga = StyleUtil.getShapeStyleContainer((PictogramElement)this.pictogramElement);
        if (ga != null) {
            Shape labelShape;
            if (!(newValue instanceof EEnumLiteral)) {
                StyleUtil.applyStyle((GraphicsAlgorithm)ga, (BaseElement)this.businessObject, (ShapeStyle)ss);
                DIUtils.getOrCreateDILabelStyle((BaseElement)this.businessObject, (ShapeStyle)ss);
            }
            if ((labelShape = FeatureSupport.getLabelShape((PictogramElement)this.pictogramElement)) != null) {
                ga = labelShape.getGraphicsAlgorithm();
                Graphiti.getPeService().setPropertyValue((PropertyContainer)labelShape, "label.changed", "true");
                StyleUtil.applyStyle((GraphicsAlgorithm)ga, (BaseElement)this.businessObject, (ShapeStyle)ss);
            }
        }
    }

    public boolean shouldSaveElement(EObject o) {
        if (ShapeStyle.isStyleObject((Object)o)) {
            String elementString;
            String defaultString;
            if (this.businessObject == null) {
                return false;
            }
            Bpmn2Preferences preferences = Bpmn2Preferences.getInstance((EObject)this.businessObject);
            ShapeStyle ssDefault = preferences.getShapeStyle((EObject)this.businessObject);
            ShapeStyle ssElement = ShapeStyle.getShapeStyle((BaseElement)this.businessObject);
            if (preferences.getSaveBPMNLabels()) {
                ssElement.setLabelFont(ssDefault.getLabelFont());
            }
            return !(defaultString = ssDefault.toString()).equals(elementString = ssElement.toString());
        }
        return true;
    }

    public boolean shouldSaveFeature(EObject o, EStructuralFeature f) {
        if (ShapeStyle.isStyleObject((Object)o)) {
            String feature = f.getName();
            Bpmn2Preferences preferences = Bpmn2Preferences.getInstance((EObject)this.businessObject);
            ShapeStyle ss = preferences.getShapeStyle((EObject)this.businessObject);
            Object v = ShapeStyle.getStyleValue((EObject)o, (String)feature);
            if (v != null && !v.equals(ss.getStyleValue(this.businessObject, feature))) {
                if ("labelFont".equals(feature)) {
                    Bpmn2Preferences prefs = Bpmn2Preferences.getInstance((EObject)this.businessObject);
                    return !prefs.getSaveBPMNLabels();
                }
                return true;
            }
            return false;
        }
        return true;
    }
}

