/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.editors;

import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Import;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.ItemKind;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.TextAndButtonObjectEditor;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.validation.SyntaxCheckerUtils;
import org.eclipse.bpmn2.modeler.ui.property.editors.Messages;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;

public class ItemDefinitionStructureEditor
extends TextAndButtonObjectEditor {
    Definitions definitions = null;
    ItemDefinition itemDefinition;
    String prefix = null;

    public ItemDefinitionStructureEditor(AbstractDetailComposite parent, ItemDefinition itemDefinition) {
        super(parent, (EObject)itemDefinition, (EStructuralFeature)Bpmn2Package.eINSTANCE.getItemDefinition_StructureRef());
        this.itemDefinition = itemDefinition;
        this.definitions = ModelUtil.getDefinitions((Object)itemDefinition);
    }

    protected void buttonClicked(int buttonId) {
        String text = this.getText();
        int index = text.indexOf(":");
        this.prefix = null;
        if (index > 0) {
            this.prefix = text.substring(0, index);
            if (SyntaxCheckerUtils.isNCName((String)this.prefix)) {
                text = text.substring(index + 1);
            } else {
                this.prefix = null;
            }
        }
        final ItemKind thisItemKind = this.itemDefinition.getItemKind();
        final boolean thisIsCollection = this.itemDefinition.isIsCollection();
        final Import thisImport = this.itemDefinition.getImport();
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || newText.isEmpty()) {
                    return Messages.ItemDefinitionStructureEditor_DataStructureEmpty_Error;
                }
                if (ItemDefinitionStructureEditor.this.prefix != null) {
                    newText = String.valueOf(ItemDefinitionStructureEditor.this.prefix) + ":" + newText;
                }
                if (!SyntaxCheckerUtils.isQName((String)newText)) {
                    return NLS.bind((String)Messages.ItemDefinitionStructureEditor_DataStructureInvalid_Error, (Object)Character.valueOf(SyntaxCheckerUtils.getInvalidChar()));
                }
                for (ItemDefinition that : ModelUtil.getAllRootElements((Definitions)ItemDefinitionStructureEditor.this.definitions, ItemDefinition.class)) {
                    String thatText = ModelUtil.getStringWrapperTextValue((Object)that.getStructureRef());
                    if (!newText.equals(thatText) || that.getItemKind() != thisItemKind || that.isIsCollection() != thisIsCollection || that.getImport() != thisImport) continue;
                    return Messages.ItemDefinitionStructureEditor_DuplicateItemDefinition_Error;
                }
                return null;
            }
        };
        InputDialog dialog = new InputDialog(this.parent.getShell(), Messages.ItemDefinitionStructureEditor_EditDataStructure_Title, Messages.ItemDefinitionStructureEditor_EditDataStructure_Prompt, text, validator);
        if (dialog.open() == 0) {
            text = dialog.getValue();
            if (this.prefix != null) {
                text = String.valueOf(this.prefix) + ":" + text;
            }
            if (!text.equals(this.getText())) {
                this.setValue(text);
            }
        }
    }
}

