/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.util;

import java.lang.reflect.Field;
import org.eclipse.bpmn2.modeler.ui.Activator;
import org.eclipse.bpmn2.modeler.ui.IConstants;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PropertyUtil {
    private static String PROPERTY_SHEET_VIEW_ID = "org.eclipse.ui.views.PropertySheet";

    public static String deCamelCase(String string) {
        return string.replaceAll("([A-Z][a-z])", " $0").substring(1);
    }

    public static void layoutAllParents(Composite child) {
        Composite parent = child;
        while (parent != null && parent.getParent() instanceof Composite) {
            parent = parent.getParent();
            parent.layout();
        }
    }

    public static void check(Control control) {
        String name = control.getClass().getSimpleName();
        if (control.isDisposed()) {
            System.err.println(String.valueOf(name) + " disposed!");
            return;
        }
    }

    public static void dump(Composite parent, String comment) {
        System.out.println(comment);
        System.out.println("parent=" + parent.hashCode());
        PropertyUtil.check((Control)parent);
        Composite p = parent.getParent();
        while (p != null) {
            PropertyUtil.check((Control)p);
            p = p.getParent();
        }
        PropertyUtil.dump(parent, 0);
    }

    public static void dump(Composite parent, int indent) {
        Control[] kids;
        Control[] controlArray = kids = parent.getChildren();
        int n = kids.length;
        int n2 = 0;
        while (n2 < n) {
            Control k = controlArray[n2];
            int i = 0;
            while (i < indent) {
                System.out.print("|");
                ++i;
            }
            System.out.print(" " + k + " layoutData=" + k.getLayoutData());
            if (k instanceof Composite) {
                System.out.print(" layout=" + ((Composite)k).getLayout());
            }
            PropertyUtil.check(k);
            if (k instanceof Label) {
                System.out.print(((Label)k).getText());
            }
            System.out.println("");
            if (k instanceof Composite) {
                PropertyUtil.dump((Composite)k, indent + 1);
            }
            ++n2;
        }
    }

    public static Image getImage(EObject element) {
        return PropertyUtil.getImage(element.eClass().getName());
    }

    public static Image getImage(String name) {
        String field = "ICON_" + name.toUpperCase();
        try {
            Field f = IConstants.class.getField(field);
            if (f != null) {
                return Activator.getDefault().getImage((String)f.get(null));
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static IViewReference getPropertySheetView() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        if (win == null) {
            return null;
        }
        IWorkbenchPage page = win.getActivePage();
        if (page == null) {
            return null;
        }
        IViewReference[] iViewReferenceArray = page.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference vr = iViewReferenceArray[n2];
            if (PROPERTY_SHEET_VIEW_ID.equals(vr.getId())) {
                return vr;
            }
            ++n2;
        }
        return null;
    }

    public static boolean showPropertySheetView() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        if (win == null) {
            return false;
        }
        IWorkbenchPage page = win.getActivePage();
        if (page == null) {
            return false;
        }
        try {
            page.showView(PROPERTY_SHEET_VIEW_ID, null, 3);
            page.showView(PROPERTY_SHEET_VIEW_ID, null, 1);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

