/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinary;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;

public class CPPASTBinaryExpression
extends ASTNode
implements ICPPASTBinaryExpression,
IASTAmbiguityParent {
    private int op;
    private ICPPASTExpression operand1;
    private ICPPASTInitializerClause operand2;
    private ICPPEvaluation evaluation;
    private IASTImplicitName[] implicitNames;

    public CPPASTBinaryExpression() {
    }

    public CPPASTBinaryExpression(int op, IASTExpression operand1, IASTInitializerClause operand2) {
        this.op = op;
        this.setOperand1(operand1);
        this.setInitOperand2(operand2);
    }

    @Override
    public CPPASTBinaryExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTBinaryExpression copy(IASTNode.CopyStyle style) {
        CPPASTBinaryExpression copy = new CPPASTBinaryExpression(this.op, this.operand1 == null ? null : this.operand1.copy(style), this.operand2 == null ? null : this.operand2.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public int getOperator() {
        return this.op;
    }

    @Override
    public IASTExpression getOperand1() {
        return this.operand1;
    }

    @Override
    public IASTInitializerClause getInitOperand2() {
        return this.operand2;
    }

    @Override
    public IASTExpression getOperand2() {
        if (this.operand2 instanceof IASTExpression) {
            return (IASTExpression)((Object)this.operand2);
        }
        return null;
    }

    @Override
    public void setOperator(int op) {
        this.assertNotFrozen();
        this.op = op;
    }

    @Override
    public void setOperand1(IASTExpression expression) {
        this.assertNotFrozen();
        if (expression != null) {
            if (!(expression instanceof ICPPASTExpression)) {
                throw new IllegalArgumentException(expression.getClass().getName());
            }
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND_ONE);
        }
        this.operand1 = (ICPPASTExpression)expression;
    }

    public void setInitOperand2(IASTInitializerClause operand) {
        this.assertNotFrozen();
        if (operand != null) {
            if (!(operand instanceof ICPPASTInitializerClause)) {
                throw new IllegalArgumentException(operand.getClass().getName());
            }
            operand.setParent(this);
            operand.setPropertyInParent(OPERAND_TWO);
        }
        this.operand2 = (ICPPASTInitializerClause)operand;
    }

    @Override
    public void setOperand2(IASTExpression expression) {
        this.setInitOperand2(expression);
    }

    @Override
    public IASTImplicitName[] getImplicitNames() {
        if (this.implicitNames == null) {
            ICPPFunction overload = this.getOverload();
            if (overload == null || overload instanceof CPPImplicitFunction && !(overload instanceof ICPPMethod)) {
                this.implicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
            } else {
                CPPASTImplicitName operatorName = new CPPASTImplicitName(overload.getNameCharArray(), (IASTNode)this);
                operatorName.setBinding(overload);
                operatorName.setOperator(true);
                operatorName.computeOperatorOffsets(this.operand1, true);
                this.implicitNames = new IASTImplicitName[]{operatorName};
            }
        }
        return this.implicitNames;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (this.operand1 instanceof IASTBinaryExpression || this.operand2 instanceof IASTBinaryExpression) {
            return CPPASTBinaryExpression.acceptWithoutRecursion(this, action);
        }
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.operand1 != null && !this.operand1.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitNames) {
            IASTImplicitName[] iASTImplicitNameArray = this.getImplicitNames();
            int n = iASTImplicitNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTImplicitName name = iASTImplicitNameArray[n2];
                if (!name.accept(action)) {
                    return false;
                }
                ++n2;
            }
        }
        if (this.operand2 != null && !this.operand2.accept(action)) {
            return false;
        }
        return !action.shouldVisitExpressions || action.leave(this) != 2;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean acceptWithoutRecursion(IASTBinaryExpression bexpr, ASTVisitor action) {
        stack = new N(bexpr);
        block4: while (stack != null) {
            block13: {
                expr = stack.fExpression;
                if (stack.fState != 0) break block13;
                if (!action.shouldVisitExpressions) ** GOTO lbl-1000
                switch (action.visit(expr)) {
                    case 2: {
                        return false;
                    }
                    case 1: {
                        stack = stack.fNext;
                        continue block4;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        stack.fState = 1;
                        op1 = expr.getOperand1();
                        if (op1 instanceof IASTBinaryExpression) {
                            n = new N((IASTBinaryExpression)op1);
                            n.fNext = stack;
                            stack = n;
                            continue block4;
                        }
                        if (op1 == null || op1.accept(action)) break;
                        return false;
                    }
                }
            }
            if (stack.fState == 1) {
                if (action.shouldVisitImplicitNames) {
                    var7_9 = ((IASTImplicitNameOwner)expr).getImplicitNames();
                    var6_8 = var7_9.length;
                    n = 0;
                    while (n < var6_8) {
                        name = var7_9[n];
                        if (!name.accept(action)) {
                            return false;
                        }
                        ++n;
                    }
                }
                stack.fState = 2;
                op2 = expr.getOperand2();
                if (op2 instanceof IASTBinaryExpression) {
                    n = new N((IASTBinaryExpression)op2);
                    n.fNext = stack;
                    stack = n;
                    continue;
                }
                if (op2 != null && !op2.accept(action)) {
                    return false;
                }
            }
            if (action.shouldVisitExpressions && action.leave(expr) == 2) {
                return false;
            }
            stack = stack.fNext;
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.operand1) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.operand1 = (ICPPASTExpression)other;
        }
        if (child == this.operand2) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.operand2 = (ICPPASTInitializerClause)other;
        }
    }

    @Override
    public ICPPFunction getOverload() {
        ICPPEvaluation eval = this.getEvaluation();
        if (eval instanceof EvalBinary) {
            return ((EvalBinary)eval).getOverload(this);
        }
        return null;
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.evaluation == null) {
            this.evaluation = this.computeEvaluation();
        }
        return this.evaluation;
    }

    private ICPPEvaluation computeEvaluation() {
        if (this.operand1 == null || this.operand2 == null) {
            return EvalFixed.INCOMPLETE;
        }
        return new EvalBinary(this.op, this.operand1.getEvaluation(), this.operand2.getEvaluation(), this);
    }

    @Override
    public IType getExpressionType() {
        return this.getEvaluation().getTypeOrFunctionSet(this);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return this.getEvaluation().getValueCategory(this);
    }

    @Override
    public boolean isLValue() {
        return this.getValueCategory() == IASTExpression.ValueCategory.LVALUE;
    }

    private static class N {
        final IASTBinaryExpression fExpression;
        int fState;
        N fNext;

        N(IASTBinaryExpression expr) {
            this.fExpression = expr;
        }
    }
}

