/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespaceScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPNamespaceScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalNamespaceScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.index.IIndexScope;

public class CPPScopeMapper {
    private final HashMap<IIndexScope, IScope> fMappedScopes = new HashMap();
    private final HashMap<String, NamespaceScopeWrapper> fNamespaceWrappers = new HashMap();
    private final Map<String, List<UsingDirectiveWrapper>> fPerName = new HashMap<String, List<UsingDirectiveWrapper>>();
    private final CPPASTTranslationUnit fTu;
    protected CharArrayMap<IASTName[]> fClasses;

    public CPPScopeMapper(CPPASTTranslationUnit tu) {
        this.fTu = tu;
    }

    public void registerAdditionalDirectives(int offset, List<ICPPUsingDirective> usingDirectives) {
        if (!usingDirectives.isEmpty()) {
            for (ICPPUsingDirective ud : usingDirectives) {
                IScope container = ud.getContainingScope();
                try {
                    String name = this.getReverseQualifiedName(container);
                    List<UsingDirectiveWrapper> list = this.fPerName.get(name);
                    if (list == null) {
                        list = new LinkedList<UsingDirectiveWrapper>();
                        this.fPerName.put(name, list);
                    }
                    list.add(new UsingDirectiveWrapper(offset, ud));
                }
                catch (DOMException dOMException) {}
            }
        }
    }

    public void handleAdditionalDirectives(ICPPNamespaceScope scope) {
        assert (!(scope instanceof IIndexScope));
        if (this.fPerName.isEmpty()) {
            return;
        }
        try {
            String qname = this.getReverseQualifiedName(scope);
            List<UsingDirectiveWrapper> candidates = this.fPerName.remove(qname);
            if (candidates != null) {
                for (UsingDirectiveWrapper ud : candidates) {
                    scope.addUsingDirective(ud);
                }
            }
        }
        catch (DOMException dOMException) {}
    }

    private String getReverseQualifiedName(IScope scope) throws DOMException {
        CPPNamespaceScope tuscope = this.fTu.getScope();
        if (scope == tuscope || scope == null || scope.getKind() == EScopeKind.eGlobal) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        IName scopeName = scope.getScopeName();
        if (scopeName != null) {
            buf.append(scopeName.getSimpleID());
        }
        scope = scope.getParent();
        while (scope.getKind() != EScopeKind.eGlobal && scope != tuscope) {
            buf.append(':');
            scopeName = scope.getScopeName();
            if (scopeName != null) {
                buf.append(scope.getScopeName().getSimpleID());
            }
            scope = scope.getParent();
        }
        return buf.toString();
    }

    public IScope mapToASTScope(IIndexScope scope) {
        if (scope.getKind() == EScopeKind.eGlobal) {
            return this.fTu.getScope();
        }
        if (scope instanceof ICPPNamespaceScope) {
            IScope result = this.fMappedScopes.get(scope);
            if (result == null) {
                result = this.fTu.getScope().findNamespaceScope(scope);
                if (result == null) {
                    result = this.wrapNamespaceScope((ICPPNamespaceScope)((Object)scope));
                }
                this.fMappedScopes.put(scope, result);
            }
            return result;
        }
        return scope;
    }

    private IScope wrapNamespaceScope(ICPPNamespaceScope scope) {
        try {
            String rqname = this.getReverseQualifiedName(scope);
            NamespaceScopeWrapper result = this.fNamespaceWrappers.get(rqname);
            if (result == null) {
                result = new NamespaceScopeWrapper(this.getCompositeNamespaceScope(scope));
                this.fNamespaceWrappers.put(rqname, result);
            }
            return result;
        }
        catch (DOMException dOMException) {
            assert (false);
            return null;
        }
    }

    private ICPPNamespaceScope getCompositeNamespaceScope(ICPPNamespaceScope scope) throws DOMException {
        IIndexBinding binding;
        if (scope instanceof IIndexScope && (binding = this.fTu.getIndex().adaptBinding(((IIndexScope)((Object)scope)).getScopeBinding())) instanceof ICPPNamespace) {
            scope = ((ICPPNamespace)((Object)binding)).getNamespaceScope();
        }
        return scope;
    }

    public ICPPClassType mapToAST(ICPPClassType type, IASTNode point) {
        IASTName[] names;
        if (type instanceof ICPPTemplateInstance) {
            IBinding mapped;
            ICPPTemplateInstance inst = (ICPPTemplateInstance)((Object)type);
            ICPPTemplateDefinition template = inst.getTemplateDefinition();
            if (template instanceof IIndexBinding && template instanceof ICPPClassType && (mapped = this.mapToAST((ICPPClassType)((Object)template), point)) != template && mapped instanceof ICPPClassType && (mapped = CPPTemplates.instantiate((ICPPClassTemplate)mapped, inst.getTemplateArguments(), point)) instanceof ICPPClassType) {
                return mapped;
            }
            return type;
        }
        if (this.fClasses == null) {
            this.fClasses = new CharArrayMap();
            this.fTu.accept(new Visitor());
        }
        if ((names = this.fClasses.get(type.getNameCharArray())) != null) {
            IASTName[] iASTNameArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPClassType mapped;
                IASTName name = iASTNameArray[n2];
                if (name == null) break;
                IBinding b = name.resolveBinding();
                if (b instanceof ICPPClassType && (mapped = (ICPPClassType)b).isSameType(type)) {
                    return mapped;
                }
                ++n2;
            }
        }
        return type;
    }

    public static final class InlineNamespaceDirective
    implements ICPPUsingDirective {
        private final ICPPInternalNamespaceScope fContainer;
        private final ICPPInternalNamespaceScope fNominated;

        public InlineNamespaceDirective(ICPPInternalNamespaceScope container, ICPPInternalNamespaceScope inline) {
            this.fContainer = container;
            this.fNominated = inline;
        }

        @Override
        public IScope getContainingScope() {
            return this.fContainer;
        }

        @Override
        public ICPPNamespaceScope getNominatedScope() throws DOMException {
            return this.fNominated;
        }

        @Override
        public int getPointOfDeclaration() {
            return 0;
        }
    }

    private class NamespaceScopeWrapper
    implements ICPPInternalNamespaceScope {
        private final ICPPNamespaceScope fScope;
        private ArrayList<ICPPUsingDirective> fUsingDirectives;
        private ICPPNamespaceScope[] fEnclosingNamespaceSet;

        public NamespaceScopeWrapper(ICPPNamespaceScope scope) {
            this.fScope = scope;
            assert (this.fScope instanceof IIndexScope);
        }

        @Override
        public EScopeKind getKind() {
            return this.fScope.getKind();
        }

        @Override
        public IBinding[] find(String name) {
            return this.fScope.find(name);
        }

        @Override
        public IBinding getBinding(IASTName name, boolean resolve) {
            return this.fScope.getBinding(name, resolve);
        }

        @Override
        public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet acceptLocalBindings) {
            return this.fScope.getBinding(name, resolve, acceptLocalBindings);
        }

        @Override
        @Deprecated
        public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup) {
            return this.fScope.getBindings(name, resolve, prefixLookup);
        }

        @Override
        @Deprecated
        public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet acceptLocalBindings) {
            return this.getBindings(name, resolve, prefixLookup, acceptLocalBindings);
        }

        @Override
        public IBinding[] getBindings(IScope.ScopeLookupData lookup) {
            return this.fScope.getBindings(lookup);
        }

        @Override
        public IScope getParent() throws DOMException {
            IScope parent = this.fScope.getParent();
            if (parent instanceof IIndexScope) {
                return CPPScopeMapper.this.mapToASTScope((IIndexScope)parent);
            }
            return CPPScopeMapper.this.fTu.getScope();
        }

        @Override
        public IName getScopeName() {
            return this.fScope.getScopeName();
        }

        @Override
        public void addUsingDirective(ICPPUsingDirective usingDirective) {
            this.initUsingDirectives();
            this.fUsingDirectives.add(usingDirective);
        }

        private void initUsingDirectives() {
            if (this.fUsingDirectives == null) {
                this.fUsingDirectives = new ArrayList(1);
                ICPPInternalNamespaceScope[] iCPPInternalNamespaceScopeArray = this.getInlineNamespaces();
                int n = iCPPInternalNamespaceScopeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPInternalNamespaceScope inline = iCPPInternalNamespaceScopeArray[n2];
                    this.fUsingDirectives.add(new InlineNamespaceDirective(this, inline));
                    ++n2;
                }
            }
        }

        @Override
        public ICPPUsingDirective[] getUsingDirectives() {
            this.initUsingDirectives();
            return this.fUsingDirectives.toArray(new ICPPUsingDirective[this.fUsingDirectives.size()]);
        }

        @Override
        public ICPPNamespaceScope[] getEnclosingNamespaceSet() {
            if (this.fEnclosingNamespaceSet == null) {
                this.fEnclosingNamespaceSet = CPPNamespaceScope.computeEnclosingNamespaceSet(this);
                return this.fEnclosingNamespaceSet;
            }
            return this.fEnclosingNamespaceSet;
        }

        @Override
        public boolean isInlineNamepace() {
            IIndexBinding binding = ((IIndexScope)((Object)this.fScope)).getScopeBinding();
            return binding instanceof ICPPNamespace && ((ICPPNamespace)((Object)binding)).isInline();
        }

        @Override
        public ICPPInternalNamespaceScope[] getInlineNamespaces() {
            ICPPNamespaceScope[] pre = this.fScope.getInlineNamespaces();
            if (pre.length == 0) {
                return ICPPInternalNamespaceScope.EMPTY_NAMESPACE_SCOPE_ARRAY;
            }
            ICPPInternalNamespaceScope[] result = new ICPPInternalNamespaceScope[pre.length];
            int i = 0;
            while (i < result.length) {
                result[i] = (ICPPInternalNamespaceScope)CPPScopeMapper.this.mapToASTScope((IIndexScope)((Object)pre[i]));
                ++i;
            }
            return result;
        }

        public String toString() {
            return this.fScope.toString();
        }
    }

    private class UsingDirectiveWrapper
    implements ICPPUsingDirective {
        private final int fOffset;
        private final ICPPUsingDirective fDirective;

        public UsingDirectiveWrapper(int offset, ICPPUsingDirective ud) {
            this.fOffset = offset;
            this.fDirective = ud;
        }

        @Override
        public IScope getContainingScope() {
            IScope scope = this.fDirective.getContainingScope();
            if (scope == null) {
                return CPPScopeMapper.this.fTu.getScope();
            }
            return scope;
        }

        @Override
        public ICPPNamespaceScope getNominatedScope() throws DOMException {
            return this.fDirective.getNominatedScope();
        }

        @Override
        public int getPointOfDeclaration() {
            return this.fOffset;
        }

        public String toString() {
            return this.fDirective.toString();
        }
    }

    private class Visitor
    extends ASTVisitor {
        Visitor() {
            this.shouldVisitDeclarations = true;
        }

        @Override
        public int visit(IASTDeclaration declaration) {
            if (declaration instanceof IASTSimpleDeclaration) {
                IASTDeclSpecifier declspec = ((IASTSimpleDeclaration)declaration).getDeclSpecifier();
                if (declspec instanceof IASTCompositeTypeSpecifier) {
                    IASTCompositeTypeSpecifier cts = (IASTCompositeTypeSpecifier)declspec;
                    IASTName name = cts.getName();
                    char[] nameChars = name.getLookupKey();
                    if (nameChars.length > 0) {
                        IASTName[] names = CPPScopeMapper.this.fClasses.get(nameChars);
                        names = ArrayUtil.append(IASTName.class, names, name);
                        CPPScopeMapper.this.fClasses.put(nameChars, names);
                    }
                    return 3;
                }
                return 1;
            }
            if (declaration instanceof IASTASMDeclaration || declaration instanceof IASTFunctionDefinition) {
                return 1;
            }
            return 3;
        }
    }
}

