/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.osview;

import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.osview.ColumnLayout;
import org.eclipse.cdt.dsf.gdb.internal.ui.osview.ContentLabelProviderWrapper;
import org.eclipse.cdt.dsf.gdb.internal.ui.osview.Messages;
import org.eclipse.cdt.dsf.gdb.internal.ui.osview.OSData;
import org.eclipse.cdt.dsf.gdb.internal.ui.osview.ResourceClassContributionItem;
import org.eclipse.cdt.dsf.gdb.internal.ui.osview.SessionOSData;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextManager;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;

public class OSResourcesView
extends ViewPart
implements DsfSession.SessionEndedListener {
    private static final String FETCH_LINK_TAG = "fetch";
    private SessionOSData fSessionData;
    private Map<String, SessionOSData> fSessionDataCache = new HashMap<String, SessionOSData>();
    private OSData fTableShownData = null;
    private OSData fMenuShownData = null;
    private String fResourceClass = null;
    boolean fMultiple = false;
    boolean fWrongType = false;
    private TableViewer fViewer;
    private Comparator fComparator;
    private Composite fNothingLabelContainer;
    private Link fNothingLabel;
    private ResourceClassContributionItem fResourceClassEditor;
    private Action fRefreshAction;
    private Map<String, ColumnLayout> fColumnLayouts = new HashMap<String, ColumnLayout>();
    private ColumnLayout fColumnLayout = null;
    private IDebugContextListener fDebugContextListener;

    public void createPartControl(Composite xparent) {
        Composite parent = new Composite(xparent, 0);
        GridLayout topLayout = new GridLayout(1, false);
        topLayout.marginWidth = 0;
        topLayout.marginHeight = 0;
        parent.setLayout((Layout)topLayout);
        this.fViewer = new TableViewer(parent, 770);
        GridData viewerData = new GridData(1808);
        viewerData.exclude = true;
        this.fViewer.getControl().setLayoutData((Object)viewerData);
        this.fComparator = new Comparator();
        this.fViewer.setComparator((ViewerComparator)this.fComparator);
        Table table = this.fViewer.getTable();
        table.setHeaderVisible(true);
        table.setVisible(false);
        this.fNothingLabelContainer = new Composite(parent, 0);
        GridData nothingLayout = new GridData(4, 4, true, true);
        this.fNothingLabelContainer.setLayoutData((Object)nothingLayout);
        GridLayout containerLayout = new GridLayout(1, false);
        this.fNothingLabelContainer.setLayout((Layout)containerLayout);
        this.fNothingLabel = new Link(this.fNothingLabelContainer, 2048);
        this.fNothingLabel.setText(Messages.OSView_4);
        this.fNothingLabel.setBackground(this.fNothingLabel.getDisplay().getSystemColor(25));
        this.fNothingLabel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.text.equals(OSResourcesView.FETCH_LINK_TAG) && OSResourcesView.this.fSessionData != null && OSResourcesView.this.fResourceClass != null) {
                    OSResourcesView.this.fSessionData.fetchData(OSResourcesView.this.fResourceClass);
                }
            }
        });
        this.fNothingLabelContainer.setBackground(this.fNothingLabel.getBackground());
        GridData nothingLabelLayout = new GridData(0x1000000, 128, true, false);
        this.fNothingLabel.setLayoutData((Object)nothingLabelLayout);
        this.fResourceClassEditor = new ResourceClassContributionItem();
        this.fResourceClassEditor.setListener(new ResourceClassContributionItem.Listener(){

            @Override
            public void resourceClassChanged(String newClass) {
                OSResourcesView.this.fResourceClass = newClass;
                OSResourcesView.this.fSessionData.fetchData(OSResourcesView.this.fResourceClass);
            }
        });
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().add((IContributionItem)this.fResourceClassEditor);
        this.fRefreshAction = new Action(){

            public void run() {
                if (OSResourcesView.this.fSessionData != null && OSResourcesView.this.fResourceClass != null) {
                    OSResourcesView.this.fSessionData.fetchData(OSResourcesView.this.fResourceClass);
                }
            }
        };
        this.fRefreshAction.setText(Messages.OSView_3);
        this.fRefreshAction.setToolTipText(Messages.OSView_3);
        try {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
            URL url = bundle.getEntry("/");
            url = new URL(url, "icons/full/elcl16/refresh_nav.gif");
            ImageDescriptor candidate = ImageDescriptor.createFromURL((URL)url);
            if (candidate != null && candidate.getImageData() != null) {
                this.fRefreshAction.setImageDescriptor(candidate);
            }
        }
        catch (Exception exception) {}
        bars.getToolBarManager().add((IAction)this.fRefreshAction);
        bars.updateActionBars();
        this.fResourceClass = this.fResourceClassEditor.getResourceClassId();
        this.setupContextListener();
        DsfSession.addSessionEndedListener((DsfSession.SessionEndedListener)this);
    }

    private void setupContextListener() {
        IDebugContextManager contextManager = DebugUITools.getDebugContextManager();
        IDebugContextService contextService = contextManager.getContextService(this.getSite().getWorkbenchWindow());
        this.fDebugContextListener = new IDebugContextListener(){

            public void debugContextChanged(DebugContextEvent event) {
                if ((event.getFlags() & 1) != 0) {
                    ISelection s = event.getContext();
                    OSResourcesView.this.setDebugContext(s);
                }
            }
        };
        contextService.addDebugContextListener(this.fDebugContextListener);
        this.setDebugContext(contextService.getActiveContext());
    }

    public void dispose() {
        super.dispose();
        IDebugContextManager contextManager = DebugUITools.getDebugContextManager();
        IDebugContextService contextService = contextManager.getContextService(this.getSite().getWorkbenchWindow());
        contextService.removeDebugContextListener(this.fDebugContextListener);
        this.setDebugContext((ICommandControlService.ICommandControlDMContext)null);
        DsfSession.removeSessionEndedListener((DsfSession.SessionEndedListener)this);
    }

    private void setDebugContext(ISelection s) {
        IStructuredSelection ss;
        ICommandControlService.ICommandControlDMContext context = null;
        this.fMultiple = false;
        this.fWrongType = false;
        if (s instanceof IStructuredSelection && (ss = (IStructuredSelection)s).size() > 0) {
            Iterator i = ss.iterator();
            context = this.getCommandControlContext(i.next());
            if (context == null) {
                this.fWrongType = true;
            }
            while (i.hasNext()) {
                ICommandControlService.ICommandControlDMContext nextContext = this.getCommandControlContext(i.next());
                if (nextContext == null) {
                    this.fWrongType = true;
                }
                if (!(nextContext == null && context != null || nextContext != null && context == null) && (nextContext == null || context == null || nextContext.equals(context))) continue;
                context = null;
                this.fMultiple = true;
                break;
            }
        }
        this.setDebugContext(context);
    }

    private ICommandControlService.ICommandControlDMContext getCommandControlContext(Object obj) {
        IDMContext context = null;
        if (obj instanceof IDMVMContext) {
            context = ((IDMVMContext)obj).getDMContext();
        } else if (obj instanceof GdbLaunch) {
            GdbLaunch l = (GdbLaunch)obj;
            final DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), l.getSession().getId());
            Query<IDMContext> contextQuery = new Query<IDMContext>(){

                protected void execute(DataRequestMonitor<IDMContext> rm) {
                    ICommandControlService commandControl = (ICommandControlService)tracker.getService(ICommandControlService.class);
                    tracker.dispose();
                    if (commandControl != null) {
                        rm.setData((Object)commandControl.getContext());
                    }
                    rm.done();
                }
            };
            l.getSession().getExecutor().submit((Runnable)contextQuery);
            try {
                context = (IDMContext)contextQuery.get();
            }
            catch (Exception exception) {}
        }
        return (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)context, ICommandControlService.ICommandControlDMContext.class);
    }

    private void setDebugContext(ICommandControlService.ICommandControlDMContext context) {
        DsfSession newSession = null;
        SessionOSData newSessionData = null;
        if (context != null) {
            newSession = DsfSession.getSession((String)context.getSessionId());
        }
        if (newSession != null && (newSessionData = this.fSessionDataCache.get(newSession.getId())) == null) {
            newSessionData = new SessionOSData(newSession, context);
            this.fSessionDataCache.put(newSession.getId(), newSessionData);
            newSessionData.setUIListener(new SessionOSData.Listener(){

                @Override
                public void update() {
                    OSResourcesView.this.updateSessionDataContents();
                }
            }, this.fViewer.getControl());
        }
        this.update(newSessionData);
    }

    public void sessionEnded(DsfSession session) {
        String id = session.getId();
        SessionOSData data = this.fSessionDataCache.remove(id);
        if (data != null) {
            data.dispose();
        }
    }

    private void update(SessionOSData newSessionData) {
        if (this.fViewer == null || this.fViewer.getControl() == null) {
            return;
        }
        if (this.fViewer.getControl().isDisposed()) {
            return;
        }
        if (newSessionData == null) {
            this.fSessionData = null;
            if (this.fMultiple) {
                this.hideTable(Messages.OSView_14);
            } else if (this.fWrongType) {
                this.hideTable(Messages.OSView_4);
            } else {
                this.hideTable(Messages.OSView_15);
            }
            this.fResourceClassEditor.setEnabled(false);
            this.fRefreshAction.setEnabled(false);
            return;
        }
        if (newSessionData != this.fSessionData) {
            this.fSessionData = newSessionData;
            this.updateSessionDataContents();
        }
    }

    private void updateSessionDataContents() {
        if (this.fSessionData == null) {
            return;
        }
        if (this.fViewer == null || this.fViewer.getControl() == null) {
            return;
        }
        if (this.fViewer.getControl().isDisposed()) {
            return;
        }
        boolean enable = this.fSessionData.canFetchData();
        this.fRefreshAction.setEnabled(enable);
        this.fResourceClass = this.fResourceClassEditor.updateClasses(this.fSessionData.getResourceClasses());
        this.fResourceClassEditor.setEnabled(enable);
        if (!this.fSessionData.osResourcesSupported()) {
            this.fRefreshAction.setEnabled(false);
            this.fResourceClassEditor.setEnabled(false);
            this.hideTable(Messages.OSView_10);
            return;
        }
        if (this.fSessionData.waitingForSessionInitialization()) {
            this.fRefreshAction.setEnabled(false);
            this.fResourceClassEditor.setEnabled(false);
            this.hideTable(Messages.OSView_13);
            return;
        }
        if (this.fSessionData.fetchingClasses()) {
            this.fRefreshAction.setEnabled(false);
            this.fResourceClassEditor.setEnabled(false);
            this.hideTable(Messages.OSView_11);
            return;
        }
        if (this.fResourceClass == null) {
            this.fRefreshAction.setEnabled(false);
            this.fResourceClassEditor.setEnabled(true);
            this.hideTable(Messages.OSView_5);
            return;
        }
        final OSData data = this.fSessionData.existingData(this.fResourceClass);
        if (this.fSessionData.fetchingContent()) {
            this.hideTable(Messages.OSView_6);
        } else if (data == null) {
            if (this.fSessionData.canFetchData()) {
                this.hideTable(NLS.bind((String)Messages.OSView_7, (Object)FETCH_LINK_TAG));
            } else {
                this.hideTable(Messages.OSView_12);
            }
        } else {
            SimpleDateFormat format = new SimpleDateFormat(Messages.OSView_8);
            this.fRefreshAction.setToolTipText(format.format(this.fSessionData.timestamp(this.fResourceClass)));
            if (data != this.fTableShownData) {
                UIJob job = new UIJob(Messages.OSView_9){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        OSResourcesView.this.fTableShownData = data;
                        OSResourcesView.this.populateTable(data);
                        OSResourcesView.this.showTable();
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(10);
                job.schedule();
            } else {
                assert (this.fViewer.getTable().getColumnCount() == data.getColumnCount());
                this.showTable();
            }
        }
        this.fRefreshAction.setEnabled(this.fSessionData.canFetchData());
        this.fResourceClassEditor.setEnabled(this.fSessionData.canFetchData());
    }

    private void hideTable(String message) {
        this.setContentDescription("");
        this.fViewer.getControl().setVisible(false);
        ((GridData)this.fViewer.getControl().getLayoutData()).exclude = true;
        this.fNothingLabelContainer.setVisible(true);
        ((GridData)this.fNothingLabelContainer.getLayoutData()).exclude = false;
        this.fNothingLabelContainer.getParent().layout();
        this.fNothingLabel.setText(message);
        this.fNothingLabelContainer.layout();
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getMenuManager().removeAll();
        bars.updateActionBars();
        this.fMenuShownData = null;
    }

    private void showTable() {
        assert (this.fTableShownData != null);
        this.fViewer.getControl().setVisible(true);
        ((GridData)this.fViewer.getControl().getLayoutData()).exclude = false;
        this.fNothingLabelContainer.setVisible(false);
        ((GridData)this.fNothingLabelContainer.getLayoutData()).exclude = true;
        this.fNothingLabelContainer.getParent().layout();
        this.populateViewMenu(this.fTableShownData);
    }

    private void populateTable(final OSData data) {
        ContentLabelProviderWrapper wrapper;
        final Table table = this.fViewer.getTable();
        while (table.getColumnCount() > 0) {
            table.getColumns()[0].dispose();
        }
        this.fColumnLayout = this.fColumnLayouts.get(this.fResourceClass);
        if (this.fColumnLayout == null) {
            this.fColumnLayout = new ColumnLayout(this.fResourceClass);
            this.fColumnLayouts.put(this.fResourceClass, this.fColumnLayout);
        }
        int i = 0;
        while (i < data.getColumnCount()) {
            final String cn = data.getColumnName(i);
            final TableColumn c = new TableColumn(table, 16384);
            c.setText(cn);
            c.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    OSResourcesView.this.fColumnLayout.setWidth(cn, c.getWidth());
                }
            });
            final int final_index = i++;
            c.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int dir = table.getSortDirection();
                    dir = table.getSortColumn() == c ? (dir == 128 ? 1024 : 128) : 1024;
                    table.setSortDirection(dir);
                    table.setSortColumn(c);
                    OSResourcesView.this.fComparator.configure(final_index, data);
                    OSResourcesView.this.fComparator.setDirection(dir == 1024 ? 1 : -1);
                    OSResourcesView.this.fColumnLayout.setSortColumn(final_index);
                    OSResourcesView.this.fColumnLayout.setSortDirection(dir == 1024 ? 1 : -1);
                    OSResourcesView.this.fViewer.refresh();
                }
            });
        }
        this.populateViewMenu(data);
        int sortColumn = this.fColumnLayout.getSortColumn();
        if (sortColumn < data.getColumnCount()) {
            this.fComparator.configure(sortColumn, data);
        }
        this.fComparator.setDirection(this.fColumnLayout.getSortDirection());
        this.fViewer.getTable().setEnabled(true);
        if (this.fViewer.getContentProvider() == null) {
            wrapper = new ContentLabelProviderWrapper(data);
            this.fViewer.setContentProvider((IContentProvider)wrapper);
            this.fViewer.setLabelProvider((IBaseLabelProvider)wrapper);
        } else {
            wrapper = (ContentLabelProviderWrapper)this.fViewer.getContentProvider();
            wrapper.setData(data);
        }
        this.fViewer.setInput((Object)this.getViewSite());
        this.fViewer.getControl().setVisible(true);
        int i2 = 0;
        while (i2 < this.fViewer.getTable().getColumnCount()) {
            TableColumn col = this.fViewer.getTable().getColumns()[i2];
            String cn = col.getText();
            if (i2 == sortColumn) {
                table.setSortDirection(this.fColumnLayout.getSortDirection() == 1 ? 1024 : 128);
                table.setSortColumn(col);
            }
            if (this.fColumnLayout.getVisible(cn)) {
                int w = this.fColumnLayout.getWidth(cn);
                if (w > 0) {
                    col.setWidth(w);
                } else {
                    col.pack();
                }
            } else {
                col.setWidth(0);
                col.setResizable(false);
            }
            ++i2;
        }
    }

    private void populateViewMenu(OSData data) {
        assert (data.getColumnCount() == this.fViewer.getTable().getColumnCount());
        if (data == this.fMenuShownData) {
            return;
        }
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getMenuManager().setVisible(true);
        bars.getMenuManager().removeAll();
        int i = 0;
        while (i < data.getColumnCount()) {
            final String cn = data.getColumnName(i);
            final TableColumn c = this.fViewer.getTable().getColumns()[i];
            Action a = new Action(cn, 2){

                public void run() {
                    if (this.isChecked()) {
                        int w = OSResourcesView.this.fColumnLayout.getWidth(cn);
                        if (w > 0) {
                            c.setWidth(w);
                        } else {
                            c.pack();
                        }
                        c.setResizable(true);
                    } else {
                        int w = c.getWidth();
                        c.setWidth(0);
                        OSResourcesView.this.fColumnLayout.setWidth(cn, w);
                        c.setResizable(false);
                    }
                    OSResourcesView.this.fColumnLayout.setVisible(cn, this.isChecked());
                }
            };
            a.setChecked(this.fColumnLayout.getVisible(cn));
            a.setText(cn);
            bars.getMenuManager().add((IAction)a);
            ++i;
        }
        bars.updateActionBars();
        this.fMenuShownData = data;
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    class Comparator
    extends ViewerComparator {
        private int fColumn = 0;
        private OSData fData;
        private boolean fInteger = false;
        private int fDirection = 1;

        Comparator() {
        }

        public void configure(int column, OSData data) {
            this.fColumn = column;
            this.fData = data;
            this.fInteger = data.getColumnIsInteger(column);
        }

        public void setDirection(int direction) {
            assert (direction == 1 || direction == -1);
            this.fDirection = direction;
        }

        public int compare(Viewer viewer, Object xe1, Object xe2) {
            String v1 = this.fData.getColumnText(xe1, this.fColumn);
            String v2 = this.fData.getColumnText(xe2, this.fColumn);
            if (this.fInteger) {
                Integer i1 = Integer.parseInt(v1);
                Integer i2 = Integer.parseInt(v2);
                return this.fDirection * (i1 - i2);
            }
            return this.fDirection * v1.compareTo(v2);
        }
    }
}

