/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.launching;

import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.core.model.IConnectHandler;
import org.eclipse.cdt.debug.core.model.IDebugNewExecutableHandler;
import org.eclipse.cdt.debug.internal.core.CRequest;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DefaultDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.concurrent.ThreadSafeAndProhibitedFromDsfExecutor;
import org.eclipse.cdt.dsf.debug.internal.provisional.model.IMemoryBlockRetrievalManager;
import org.eclipse.cdt.dsf.debug.model.DsfLaunch;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.memory.GdbMemoryBlockRetrievalManager;
import org.eclipse.cdt.dsf.gdb.launching.ITracedLaunch;
import org.eclipse.cdt.dsf.gdb.launching.ShutdownSequence;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.command.AbstractCLIProcess;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IDisconnectHandler;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.ITerminate;

@ThreadSafe
public class GdbLaunch
extends DsfLaunch
implements ITerminate,
IDisconnect,
ITracedLaunch {
    private DefaultDsfExecutor fExecutor;
    private DsfSession fSession;
    private DsfServicesTracker fTracker;
    private boolean fInitialized = false;
    private boolean fShutDown = false;
    private IMemoryBlockRetrievalManager fMemRetrievalManager;
    private IDsfDebugServicesFactory fServiceFactory;

    public GdbLaunch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator) {
        super(launchConfiguration, mode, locator);
        DefaultDsfExecutor dsfExecutor = new DefaultDsfExecutor("org.eclipse.cdt.dsf.gdb");
        dsfExecutor.prestartCoreThread();
        this.fExecutor = dsfExecutor;
        this.fSession = DsfSession.startSession((DsfExecutor)this.fExecutor, (String)"org.eclipse.cdt.dsf.gdb");
    }

    public DsfExecutor getDsfExecutor() {
        return this.fExecutor;
    }

    public IDsfDebugServicesFactory getServiceFactory() {
        return this.fServiceFactory;
    }

    public void initialize() {
        this.fSession.registerModelAdapter(ILaunch.class, (Object)this);
        DsfRunnable initRunnable = new DsfRunnable(){

            public void run() {
                GdbLaunch.this.fTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), GdbLaunch.this.fSession.getId());
                GdbLaunch.this.fSession.addServiceEventListener((Object)GdbLaunch.this, null);
                GdbLaunch.this.fInitialized = true;
                GdbLaunch.this.fireChanged();
            }
        };
        try {
            this.fExecutor.submit((Runnable)initRunnable).get();
        }
        catch (InterruptedException e) {
            new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Error initializing launch", (Throwable)e);
        }
        catch (ExecutionException e) {
            new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Error initializing launch", (Throwable)e);
        }
    }

    public void initializeControl() throws CoreException {
        try {
            this.fExecutor.submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws CoreException {
                    GdbLaunch.this.fMemRetrievalManager = (IMemoryBlockRetrievalManager)new GdbMemoryBlockRetrievalManager("org.eclipse.cdt.dsf.gdb", GdbLaunch.this.getLaunchConfiguration(), GdbLaunch.this.fSession);
                    GdbLaunch.this.fSession.registerModelAdapter(IMemoryBlockRetrievalManager.class, (Object)GdbLaunch.this.fMemRetrievalManager);
                    GdbLaunch.this.fSession.addServiceEventListener((Object)GdbLaunch.this.fMemRetrievalManager, null);
                    return null;
                }
            }).get();
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 0, "Interrupted while waiting for get process callable.", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw (CoreException)e.getCause();
        }
        catch (RejectedExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 0, "Debugger shut down before launch was completed.", (Throwable)e));
        }
    }

    public DsfSession getSession() {
        return this.fSession;
    }

    @ThreadSafeAndProhibitedFromDsfExecutor(value="getDsfExecutor()")
    public void addCLIProcess(String label) throws CoreException {
        try {
            AbstractCLIProcess cliProc = (AbstractCLIProcess)this.getDsfExecutor().submit((Callable)new Callable<AbstractCLIProcess>(){

                @Override
                public AbstractCLIProcess call() throws CoreException {
                    IGDBControl gdb = (IGDBControl)GdbLaunch.this.fTracker.getService(IGDBControl.class);
                    if (gdb != null) {
                        return gdb.getCLIProcess();
                    }
                    return null;
                }
            }).get();
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("org.eclipse.cdt.dsf.gdb.createProcessType", "org.eclipse.cdt.dsf.gdb.gdbProcess");
            DebugPlugin.newProcess((ILaunch)this, (Process)cliProc, (String)label, attributes);
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 0, "Interrupted while waiting for get process callable.", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw (CoreException)e.getCause();
        }
        catch (RejectedExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 0, "Debugger shut down before launch was completed.", (Throwable)e));
        }
    }

    public void setServiceFactory(IDsfDebugServicesFactory factory) {
        this.fServiceFactory = factory;
    }

    @DsfServiceEventHandler
    public void eventDispatched(ICommandControlService.ICommandControlShutdownDMEvent event) {
        this.shutdownSession((RequestMonitor)new ImmediateRequestMonitor());
    }

    public boolean canTerminate() {
        return this.fInitialized && super.canTerminate();
    }

    public void terminate() throws DebugException {
        ITerminateHandler handler = (ITerminateHandler)this.getAdapter(ITerminateHandler.class);
        if (handler == null) {
            super.terminate();
            return;
        }
        LaunchCommandRequest req = new LaunchCommandRequest(new Object[]{this});
        handler.execute((IDebugCommandRequest)req);
    }

    public boolean canDisconnect() {
        return this.canTerminate();
    }

    public boolean isDisconnected() {
        return this.isTerminated();
    }

    public void disconnect() throws DebugException {
        IDisconnectHandler handler = (IDisconnectHandler)this.getAdapter(IDisconnectHandler.class);
        if (handler == null) {
            super.disconnect();
            return;
        }
        LaunchCommandRequest req = new LaunchCommandRequest(new Object[]{this});
        handler.execute((IDebugCommandRequest)req);
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void shutdownSession(final RequestMonitor rm) {
        if (this.fShutDown) {
            rm.done();
            return;
        }
        this.fShutDown = true;
        final ShutdownSequence shutdownSeq = new ShutdownSequence(this.getDsfExecutor(), this.fSession.getId(), new RequestMonitor((Executor)this.fSession.getExecutor(), rm){

            public void handleCompleted() {
                if (GdbLaunch.this.fMemRetrievalManager != null) {
                    GdbLaunch.this.fSession.removeServiceEventListener((Object)GdbLaunch.this.fMemRetrievalManager);
                    GdbLaunch.this.fMemRetrievalManager.dispose();
                }
                GdbLaunch.this.fSession.removeServiceEventListener((Object)GdbLaunch.this);
                if (!this.isSuccess()) {
                    GdbPlugin.getDefault().getLog().log((IStatus)new MultiStatus("org.eclipse.cdt.dsf.gdb", -1, new IStatus[]{this.getStatus()}, "Session shutdown failed", null));
                }
                GdbLaunch.this.fTracker.dispose();
                GdbLaunch.this.fTracker = null;
                DsfSession.endSession((DsfSession)GdbLaunch.this.fSession);
                if (GdbLaunch.this.isTerminated()) {
                    GdbLaunch.this.fireTerminate();
                }
                rm.setStatus(this.getStatus());
                rm.done();
            }
        });
        final Sequence.Step[] steps = new Sequence.Step[]{new Sequence.Step(){

            public void execute(RequestMonitor rm) {
                IGDBControl control = (IGDBControl)GdbLaunch.this.fTracker.getService(IGDBControl.class);
                if (control == null) {
                    rm.done();
                    return;
                }
                control.terminate(rm);
            }
        }, new Sequence.Step(){

            public void execute(RequestMonitor rm) {
                GdbLaunch.this.fExecutor.execute((Runnable)shutdownSeq);
            }
        }};
        this.fExecutor.execute((Runnable)new Sequence((DsfExecutor)this.fExecutor){

            public Sequence.Step[] getSteps() {
                return steps;
            }
        });
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(ITerminateHandler.class)) {
            return this.getSession().getModelAdapter(adapter);
        }
        if (adapter.equals(IDisconnectHandler.class)) {
            return this.getSession().getModelAdapter(adapter);
        }
        if (adapter.equals(IConnectHandler.class)) {
            return this.getSession().getModelAdapter(adapter);
        }
        if (adapter.equals(IDebugNewExecutableHandler.class)) {
            return this.getSession().getModelAdapter(adapter);
        }
        Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        return super.getAdapter(adapter);
    }

    public void launchRemoved(ILaunch launch) {
        if (this.equals(launch)) {
            this.fExecutor.shutdown();
            this.fExecutor = null;
        }
        super.launchRemoved(launch);
    }

    static class LaunchCommandRequest
    extends CRequest
    implements IDebugCommandRequest {
        Object[] elements;

        public LaunchCommandRequest(Object[] objects) {
            this.elements = objects;
        }

        public Object[] getElements() {
            return this.elements;
        }

        public void done() {
            IStatus status = this.getStatus();
            if (status != null && !status.isOK()) {
                IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler(status);
                if (statusHandler != null) {
                    try {
                        statusHandler.handleStatus(status, null);
                    }
                    catch (CoreException ex) {
                        GdbPlugin.getDefault().getLog().log(ex.getStatus());
                    }
                } else {
                    GdbPlugin.getDefault().getLog().log(status);
                }
            }
        }
    }
}

