/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIList;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIThread;
import org.eclipse.cdt.dsf.mi.service.command.output.MIThreadInfoInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

public class MIListThreadGroupsInfo
extends MIInfo {
    private IThreadGroupInfo[] fGroupList;
    private MIThreadInfoInfo fThreadInfo;

    public MIListThreadGroupsInfo(MIOutput out) {
        super(out);
        this.parse();
    }

    public IThreadGroupInfo[] getGroupList() {
        return this.fGroupList;
    }

    public MIThreadInfoInfo getThreadInfo() {
        return this.fThreadInfo;
    }

    protected void parse() {
        MIOutput out;
        MIResultRecord rr;
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                if (var.equals("groups")) {
                    MIValue val = results[i].getMIValue();
                    if (val instanceof MIList) {
                        this.parseGroups((MIList)val);
                    }
                } else if (var.equals("threads")) {
                    this.fThreadInfo = this.createMIThreadInfoInfo(out);
                }
                ++i;
            }
        }
        if (this.fGroupList == null) {
            this.fGroupList = new IThreadGroupInfo[0];
        }
        if (this.fThreadInfo == null) {
            this.fThreadInfo = this.createMIThreadInfoInfo(null);
        }
    }

    protected MIThreadInfoInfo createMIThreadInfoInfo(MIOutput output) {
        return new MIThreadInfoInfo(output);
    }

    protected void parseGroups(MIList list) {
        MIValue[] values = list.getMIValues();
        this.fGroupList = new IThreadGroupInfo[values.length];
        int i = 0;
        while (i < values.length) {
            MIResult[] results = ((MITuple)values[i]).getMIResults();
            String user = "";
            String exec = "";
            String pid = "";
            String type = "";
            String desc = "";
            String id = "";
            MIThread[] threads = null;
            String[] cores = null;
            MIResult[] mIResultArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                String str;
                MIValue value;
                MIResult result = mIResultArray[n2];
                String var = result.getVariable();
                if (var.equals("id")) {
                    value = result.getMIValue();
                    if (value instanceof MIConst) {
                        str = ((MIConst)value).getCString();
                        id = str.trim();
                    }
                } else if (var.equals("description")) {
                    value = result.getMIValue();
                    if (value instanceof MIConst) {
                        str = ((MIConst)value).getCString();
                        desc = str.trim();
                    }
                } else if (var.equals("type")) {
                    value = result.getMIValue();
                    if (value instanceof MIConst) {
                        str = ((MIConst)value).getCString();
                        type = str.trim();
                    }
                } else if (var.equals("pid")) {
                    value = result.getMIValue();
                    if (value instanceof MIConst) {
                        str = ((MIConst)value).getCString();
                        pid = str.trim();
                    }
                } else if (var.equals("user")) {
                    value = result.getMIValue();
                    if (value instanceof MIConst) {
                        str = ((MIConst)value).getCString();
                        user = str.trim();
                    }
                } else if (var.equals("cores")) {
                    value = result.getMIValue();
                    if (value instanceof MIList) {
                        cores = this.parseCores((MIList)value);
                    }
                } else if (var.equals("executable")) {
                    value = result.getMIValue();
                    if (value instanceof MIConst) {
                        str = ((MIConst)value).getCString();
                        exec = str.trim();
                    }
                } else if (var.equals("threads") && (value = result.getMIValue()) instanceof MIList) {
                    threads = this.parseThreads((MIList)value);
                }
                ++n2;
            }
            if (pid.equals("") && !desc.equals("")) {
                pid = id;
            }
            this.fGroupList[i] = new ThreadGroupInfo(id, desc, type, pid, user, cores, exec, threads);
            ++i;
        }
    }

    protected MIThread[] parseThreads(MIList value) {
        return MIThreadInfoInfo.parseThreads(value);
    }

    protected String[] parseCores(MIList list) {
        ArrayList<String> cores = new ArrayList<String>();
        MIValue[] values = list.getMIValues();
        int i = 0;
        while (i < values.length) {
            if (values[i] instanceof MIConst) {
                cores.add(((MIConst)values[i]).getCString());
            }
            ++i;
        }
        return cores.toArray(new String[cores.size()]);
    }

    public static interface IThreadGroupInfo {
        public String getGroupId();

        public String getPid();

        public String getName();

        public String getDesciption();

        public String getUser();

        public String getType();

        public String[] getCores();

        public String getExecutable();
    }

    public static interface IThreadGroupInfo2
    extends IThreadGroupInfo {
        public MIThread[] getThreads();
    }

    @Immutable
    protected static class ThreadGroupInfo
    implements IThreadGroupInfo2 {
        final String fGroupId;
        final String fDescription;
        final String fName;
        final String fType;
        final String fUser;
        final String fPid;
        final String[] fCores;
        final String fExecutable;
        final MIThread[] fThreadList;

        public ThreadGroupInfo(String id, String description, String type, String pid, String user, String[] cores, String exec, MIThread[] threads) {
            this.fGroupId = id;
            this.fDescription = description;
            this.fType = type;
            this.fUser = user;
            this.fPid = pid;
            this.fCores = cores;
            this.fExecutable = exec;
            this.fName = this.parseName(this.fDescription);
            this.fThreadList = threads;
        }

        protected String parseName(String desc) {
            String name = "";
            Pattern pattern = Pattern.compile("name: (.*?)(, |$)", 8);
            Matcher matcher = pattern.matcher(desc);
            if (matcher.find()) {
                name = matcher.group(1);
            } else if (desc.length() > 0 && desc.charAt(0) == '[') {
                name = desc.substring(1, desc.length() - 1);
                pattern = Pattern.compile("(.+?)(/\\d+)", 8);
                matcher = pattern.matcher(name);
                if (matcher.find()) {
                    name = matcher.group(1);
                }
            } else {
                name = desc.split("\\s", 2)[0];
            }
            return name;
        }

        @Override
        public String getGroupId() {
            return this.fGroupId;
        }

        @Override
        public String getPid() {
            return this.fPid;
        }

        @Override
        public String getName() {
            return this.fName;
        }

        @Override
        public String getDesciption() {
            return this.fDescription;
        }

        @Override
        public String[] getCores() {
            return this.fCores;
        }

        @Override
        public String getUser() {
            return this.fUser;
        }

        @Override
        public String getType() {
            return this.fType;
        }

        @Override
        public String getExecutable() {
            return this.fExecutable;
        }

        @Override
        public MIThread[] getThreads() {
            return this.fThreadList;
        }
    }
}

