/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SimpleMapPersistableFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class SimpleMapPersistable<V>
implements IPersistableElement,
IAdaptable {
    private static final String KEY_TYPE = "type";
    private static final String KEY_NAME = "name";
    private static final String KEY_VALUE = "value";
    private Class<V> fType;
    private Map<String, V> fValues = new TreeMap<String, V>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleMapPersistable(IMemento memento) throws CoreException {
        IMemento type = memento.getChild(KEY_TYPE);
        if (type == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10002, "Missing key for type.", null));
        }
        try {
            this.fType = Class.forName(type.getTextData());
        }
        catch (ClassNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10002, e.getMessage(), (Throwable)e));
        }
        IMemento[] list = memento.getChildren(KEY_NAME);
        TreeMap<String, V> values = new TreeMap<String, V>();
        IMemento[] iMementoArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento elem = iMementoArray[n2];
            values.put(elem.getID(), this.getValue(elem));
            ++n2;
        }
        Map<String, V> map = this.fValues;
        synchronized (map) {
            this.fValues.clear();
            this.fValues.putAll(values);
        }
    }

    public SimpleMapPersistable(Class<V> type) {
        this.fType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(IMemento memento) {
        TreeMap<String, V> values = null;
        Map<String, V> map = this.fValues;
        synchronized (map) {
            values = new TreeMap<String, V>(this.fValues);
        }
        IMemento type = memento.createChild(KEY_TYPE);
        Class<V> clazz = this.fType;
        synchronized (clazz) {
            type.putTextData(this.fType.getName());
        }
        for (Map.Entry entry : values.entrySet()) {
            IMemento value = memento.createChild(KEY_NAME, (String)entry.getKey());
            this.putValue(value, entry.getValue());
        }
    }

    private void putValue(IMemento memento, Object value) {
        if (value instanceof String) {
            memento.putString(KEY_VALUE, (String)value);
        } else if (value instanceof Integer) {
            memento.putInteger(KEY_VALUE, ((Integer)value).intValue());
        } else assert (false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getValue(IMemento memento) {
        Class<V> clazz = this.fType;
        synchronized (clazz) {
            if (String.class.equals(this.fType)) {
                return (V)memento.getString(KEY_VALUE);
            }
            if (Integer.class.equals(this.fType)) {
                return (V)memento.getInteger(KEY_VALUE);
            }
            assert (false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getValue(String key) {
        if (key == null) {
            return null;
        }
        Map<String, V> map = this.fValues;
        synchronized (map) {
            return this.fValues.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String key, V value) {
        Map<String, V> map = this.fValues;
        synchronized (map) {
            if (value == null) {
                this.fValues.remove(key);
            } else {
                this.fValues.put(key, value);
            }
        }
    }

    public String getFactoryId() {
        return SimpleMapPersistableFactory.getFactoryId();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        return null;
    }
}

