/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.viewmodel.variable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.core.model.ICastToArray;
import org.eclipse.cdt.debug.core.model.ICastToType;
import org.eclipse.cdt.debug.core.model.IViewInMemory;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.internal.ui.viewmodel.DsfCastToTypeSupport;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.IExpressions3;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.ErrorLabelForeground;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.ErrorLabelText;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.IDebugVMConstants;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.AbstractExpressionVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.IExpressionUpdate;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.FormattedValueLabelText;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.FormattedValueRetriever;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.FormattedValueVMUtil;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.IFormattedValueVMContext;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.update.ElementFormatEvent;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.MessagesForVariablesVM;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.SyncVariableDataAccess;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.VariableCellModifier;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.VariableLabelFont;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerCountingRequestMonitor;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IElementPropertiesProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelBackground;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelForeground;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelImage;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.VMDelegatingPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.update.StaleDataLabelBackground;
import org.eclipse.cdt.dsf.ui.viewmodel.update.StaleDataLabelForeground;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter2;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;

public class VariableVMNode
extends AbstractExpressionVMNode
implements IElementEditor,
IElementLabelProvider,
IElementPropertiesProvider,
IElementMementoProvider {
    public static final String PROP_VARIABLE_TYPE_NAME = "variable_type_name";
    public static final String PROP_VARIABLE_BASIC_TYPE = "variable_basic_type";
    public static final String PROP_VARIABLE_ADDRESS = "variable_address";
    public static final String PROP_VARIABLE_SHOW_TYPE_NAMES = "variable_show_type_names";
    public static final String PROP_VARIABLE_ADDRESS_CHANGED = "is_changed.variable_address";
    private static final String INDEXED_PARTITION_TYPE = "indexed_partition_type";
    private final SyncVariableDataAccess fSyncVariableDataAccess;
    private final IElementLabelProvider fLabelProvider;
    private final FormattedValueRetriever fFormattedValueRetriever;
    protected final VariableExpressionFactory fVariableExpressionFactory = new VariableExpressionFactory();
    protected DsfCastToTypeSupport fCastToTypeSupport;
    private LabelBackground columnIdValueBackground;
    private LabelBackground columnNoColumnsBackground;
    private IPropertyChangeListener fPreferenceChangeListener;
    public static final LabelImage POINTER_LABEL_IMAGE = new LabelImage(CDebugImages.DESC_OBJS_VARIABLE_POINTER){
        {
            this.setPropertyNames(new String[]{VariableVMNode.PROP_VARIABLE_BASIC_TYPE});
        }

        @Override
        public boolean isEnabled(IStatus status, Map<String, Object> properties) {
            String type = (String)properties.get(VariableVMNode.PROP_VARIABLE_BASIC_TYPE);
            return IExpressions.IExpressionDMData.BasicType.pointer.name().equals(type) || IExpressions.IExpressionDMData.BasicType.function.name().equals(type);
        }
    };
    public static final LabelImage AGGREGATE_LABEL_IMAGE = new LabelImage(CDebugImages.DESC_OBJS_VARIABLE_AGGREGATE){
        {
            this.setPropertyNames(new String[]{VariableVMNode.PROP_VARIABLE_BASIC_TYPE});
        }

        @Override
        public boolean isEnabled(IStatus status, Map<String, Object> properties) {
            String type = (String)properties.get(VariableVMNode.PROP_VARIABLE_BASIC_TYPE);
            return IExpressions.IExpressionDMData.BasicType.array.name().equals(type) || IExpressions.IExpressionDMData.BasicType.composite.name().equals(type);
        }
    };
    public static final LabelImage SIMPLE_LABEL_IMAGE = new LabelImage(CDebugImages.DESC_OBJS_VARIABLE_SIMPLE){
        {
            this.setPropertyNames(new String[]{VariableVMNode.PROP_VARIABLE_BASIC_TYPE});
        }

        @Override
        public boolean isEnabled(IStatus status, Map<String, Object> properties) {
            String type = (String)properties.get(VariableVMNode.PROP_VARIABLE_BASIC_TYPE);
            return type != null;
        }
    };
    public static final LabelImage PARTITION_LABEL_IMAGE = new LabelImage(CDebugImages.DESC_OBJS_ARRAY_PARTITION){
        {
            this.setPropertyNames(new String[]{VariableVMNode.PROP_VARIABLE_BASIC_TYPE});
        }

        @Override
        public boolean isEnabled(IStatus status, Map<String, Object> properties) {
            String type = (String)properties.get(VariableVMNode.PROP_VARIABLE_BASIC_TYPE);
            return VariableVMNode.INDEXED_PARTITION_TYPE.equals(type);
        }
    };
    private final String MEMENTO_NAME = "VARIABLE_MEMENTO_NAME";

    public VariableVMNode(AbstractDMVMProvider provider, DsfSession session, SyncVariableDataAccess syncVariableDataAccess) {
        super(provider, session, IExpressions.IExpressionDMContext.class);
        this.fSyncVariableDataAccess = syncVariableDataAccess;
        this.fLabelProvider = this.createLabelProvider();
        this.fFormattedValueRetriever = new FormattedValueRetriever((IVMNode)this, session, IExpressions.class, IExpressions.IExpressionDMContext.class);
    }

    public void setCastToTypeSupport(DsfCastToTypeSupport castToTypeSupport) {
        this.fCastToTypeSupport = castToTypeSupport;
    }

    @Override
    public void dispose() {
        if (this.fPreferenceChangeListener != null) {
            DebugUITools.getPreferenceStore().removePropertyChangeListener(this.fPreferenceChangeListener);
        }
        super.dispose();
        this.fFormattedValueRetriever.dispose();
    }

    protected IElementLabelProvider createLabelProvider() {
        this.columnIdValueBackground = new LabelBackground(DebugUITools.getPreferenceColor((String)"org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND").getRGB()){
            {
                this.setPropertyNames(new String[]{FormattedValueVMUtil.getPropertyForFormatId("STRING.Format"), "is_changed." + FormattedValueVMUtil.getPropertyForFormatId("STRING.Format"), "formatted_value_active_format_value", "is_changed.formatted_value_active_format_value", "formatted_value_active_format", "is_changed.formatted_value_active_format"});
            }

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean activeFormatChanged = (Boolean)properties.get("is_changed.formatted_value_active_format");
                Boolean activeChanged = (Boolean)properties.get("is_changed.formatted_value_active_format_value");
                Boolean stringChanged = (Boolean)properties.get("is_changed." + FormattedValueVMUtil.getPropertyForFormatId("STRING.Format"));
                return Boolean.TRUE.equals(stringChanged) || Boolean.TRUE.equals(activeChanged) && !Boolean.TRUE.equals(activeFormatChanged);
            }
        };
        this.columnNoColumnsBackground = new LabelBackground(DebugUITools.getPreferenceColor((String)"org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND").getRGB()){
            {
                this.setPropertyNames(new String[]{FormattedValueVMUtil.getPropertyForFormatId("STRING.Format"), IDebugVMConstants.PROP_IS_STRING_FORMAT_VALUE_CHANGED, IDebugVMConstants.PROP_IS_ACTIVE_FORMATTED_VALUE_CHANGED});
            }

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean stringChanged = (Boolean)properties.get(IDebugVMConstants.PROP_IS_STRING_FORMAT_VALUE_CHANGED);
                Boolean activeChanged = (Boolean)properties.get(IDebugVMConstants.PROP_IS_ACTIVE_FORMATTED_VALUE_CHANGED);
                return Boolean.TRUE.equals(stringChanged) || Boolean.TRUE.equals(activeChanged);
            }
        };
        if (this.fPreferenceChangeListener != null) {
            DebugUITools.getPreferenceStore().removePropertyChangeListener(this.fPreferenceChangeListener);
        }
        this.fPreferenceChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND")) {
                    VariableVMNode.this.columnIdValueBackground.setBackground(DebugUITools.getPreferenceColor((String)"org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND").getRGB());
                    VariableVMNode.this.columnNoColumnsBackground.setBackground(DebugUITools.getPreferenceColor((String)"org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND").getRGB());
                }
            }
        };
        DebugUITools.getPreferenceStore().addPropertyChangeListener(this.fPreferenceChangeListener);
        PropertiesBasedLabelProvider provider = new PropertiesBasedLabelProvider();
        provider.setColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__NAME", new LabelColumnInfo(new LabelAttribute[]{new LabelText(MessagesForVariablesVM.VariableVMNode_Name_column__text_format, new String[]{"name"}), POINTER_LABEL_IMAGE, AGGREGATE_LABEL_IMAGE, PARTITION_LABEL_IMAGE, SIMPLE_LABEL_IMAGE, new StaleDataLabelForeground(), new VariableLabelFont()}));
        provider.setColumnInfo("org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_NAME", new LabelColumnInfo(new LabelAttribute[]{new LabelText(MessagesForVariablesVM.VariableVMNode_Expression_column__text_format, new String[]{"element_expression"}), POINTER_LABEL_IMAGE, AGGREGATE_LABEL_IMAGE, PARTITION_LABEL_IMAGE, SIMPLE_LABEL_IMAGE, new StaleDataLabelForeground(), new VariableLabelFont()}));
        provider.setColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__TYPE", new LabelColumnInfo(new LabelAttribute[]{new LabelText(MessagesForVariablesVM.VariableVMNode_Type_column__text_format, new String[]{PROP_VARIABLE_TYPE_NAME}), new LabelText(MessagesForVariablesVM.VariableVMNode_Type_column__Error__text_format, new String[0]), new StaleDataLabelForeground(), new VariableLabelFont()}));
        provider.setColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__VALUE", new LabelColumnInfo(new LabelAttribute[]{new FormattedValueLabelText(MessagesForVariablesVM.VariableVMNode_Value_column__text_format, new String[]{"formatted_value_active_format_value", FormattedValueVMUtil.getPropertyForFormatId("STRING.Format"), "formatted_value_available_formats"}){

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                String[] formatIds = (String[])properties.get("formatted_value_available_formats");
                String activeFormat = (String)properties.get("formatted_value_active_format");
                return !"STRING.Format".equals(activeFormat) && formatIds != null && Arrays.asList(formatIds).contains("STRING.Format") && super.isEnabled(status, properties);
            }
        }, new FormattedValueLabelText(), new ErrorLabelText(), new ErrorLabelForeground(), this.columnIdValueBackground, new StaleDataLabelForeground(), new VariableLabelFont()}));
        provider.setColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__ADDRESS", new LabelColumnInfo(new LabelAttribute[]{new LabelText(MessagesForVariablesVM.VariableVMNode_Location_column__text_format, new String[]{PROP_VARIABLE_ADDRESS}), new LabelText(MessagesForVariablesVM.VariableVMNode_Location_column__Error__text_format, new String[0]), new LabelBackground(DebugUITools.getPreferenceColor((String)"org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND").getRGB()){
            {
                this.setPropertyNames(new String[]{VariableVMNode.PROP_VARIABLE_ADDRESS, VariableVMNode.PROP_VARIABLE_ADDRESS_CHANGED});
            }

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean changed = (Boolean)properties.get(VariableVMNode.PROP_VARIABLE_ADDRESS_CHANGED);
                return Boolean.TRUE.equals(changed);
            }
        }, new StaleDataLabelForeground(), new VariableLabelFont()}));
        provider.setColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__DESCRIPTION", new LabelColumnInfo(new LabelAttribute[]{new LabelText(MessagesForVariablesVM.VariableVMNode_Description_column__text_format, new String[0]), new VariableLabelFont()}));
        provider.setColumnInfo("ID_COLUMN_NO_COLUMNS", new LabelColumnInfo(new LabelAttribute[]{new FormattedValueLabelText(MessagesForVariablesVM.VariableVMNode_NoColumns_column__text_format, new String[]{"name", "formatted_value_active_format_value", FormattedValueVMUtil.getPropertyForFormatId("STRING.Format"), "formatted_value_available_formats", "formatted_value_active_format", "CurrentNumericStyle", PROP_VARIABLE_SHOW_TYPE_NAMES}){

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean showTypeNames = (Boolean)properties.get(VariableVMNode.PROP_VARIABLE_SHOW_TYPE_NAMES);
                String[] formatIds = (String[])properties.get("formatted_value_available_formats");
                String activeFormat = (String)properties.get("formatted_value_active_format");
                return showTypeNames != null && showTypeNames == false && !"STRING.Format".equals(activeFormat) && formatIds != null && Arrays.asList(formatIds).contains("STRING.Format") && super.isEnabled(status, properties);
            }
        }, new FormattedValueLabelText(MessagesForVariablesVM.VariableVMNode_NoColumns_column__No_string__text_format, new String[]{"name", "formatted_value_active_format_value", "formatted_value_available_formats", "formatted_value_active_format", "CurrentNumericStyle", PROP_VARIABLE_SHOW_TYPE_NAMES}){

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean showTypeNames = (Boolean)properties.get(VariableVMNode.PROP_VARIABLE_SHOW_TYPE_NAMES);
                return showTypeNames != null && showTypeNames == false && super.isEnabled(status, properties);
            }
        }, new FormattedValueLabelText(MessagesForVariablesVM.VariableVMNode_NoColumns_column__text_format_with_type, new String[]{"name", "formatted_value_active_format_value", FormattedValueVMUtil.getPropertyForFormatId("STRING.Format"), PROP_VARIABLE_TYPE_NAME, "formatted_value_available_formats", "formatted_value_active_format", "CurrentNumericStyle", PROP_VARIABLE_SHOW_TYPE_NAMES}){

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean showTypeNames = (Boolean)properties.get(VariableVMNode.PROP_VARIABLE_SHOW_TYPE_NAMES);
                String[] formatIds = (String[])properties.get("formatted_value_available_formats");
                String activeFormat = (String)properties.get("formatted_value_active_format");
                return showTypeNames != null && showTypeNames != false && !"STRING.Format".equals(activeFormat) && formatIds != null && Arrays.asList(formatIds).contains("STRING.Format") && super.isEnabled(status, properties);
            }
        }, new FormattedValueLabelText(MessagesForVariablesVM.VariableVMNode_NoColumns_column__No_string__text_format_with_type, new String[]{"name", "formatted_value_active_format_value", PROP_VARIABLE_TYPE_NAME, "formatted_value_available_formats", "formatted_value_active_format", "CurrentNumericStyle", PROP_VARIABLE_SHOW_TYPE_NAMES}){

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean showTypeNames = (Boolean)properties.get(VariableVMNode.PROP_VARIABLE_SHOW_TYPE_NAMES);
                return showTypeNames != null && showTypeNames != false && super.isEnabled(status, properties);
            }
        }, new ErrorLabelText(MessagesForVariablesVM.VariableVMNode_NoColumns_column__Error__text_format, new String[]{"name"}), POINTER_LABEL_IMAGE, AGGREGATE_LABEL_IMAGE, SIMPLE_LABEL_IMAGE, new ErrorLabelForeground(), new LabelForeground(DebugUITools.getPreferenceColor((String)"org.eclipse.debug.ui.changedDebugElement").getRGB()){
            {
                this.setPropertyNames(new String[]{FormattedValueVMUtil.getPropertyForFormatId("STRING.Format"), IDebugVMConstants.PROP_IS_STRING_FORMAT_VALUE_CHANGED, IDebugVMConstants.PROP_IS_ACTIVE_FORMATTED_VALUE_CHANGED});
            }

            @Override
            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Boolean stringChanged = (Boolean)properties.get(IDebugVMConstants.PROP_IS_STRING_FORMAT_VALUE_CHANGED);
                Boolean activeChanged = (Boolean)properties.get(IDebugVMConstants.PROP_IS_ACTIVE_FORMATTED_VALUE_CHANGED);
                return Boolean.TRUE.equals(stringChanged) || Boolean.TRUE.equals(activeChanged);
            }
        }, this.columnNoColumnsBackground, new StaleDataLabelBackground(), new VariableLabelFont()}));
        return provider;
    }

    public String toString() {
        return "VariableVMNode(" + this.getSession().getId() + ")";
    }

    @Override
    protected IDMVMContext createVMContext(IDMContext dmc) {
        return new VariableExpressionVMC(dmc);
    }

    public void update(ILabelUpdate[] updates) {
        this.fLabelProvider.update(updates);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void update(final IPropertiesUpdate[] updates) {
        block4: {
            countingRm = new CountingRequestMonitor(ImmediateExecutor.getInstance(), null){

                protected void handleCompleted() {
                    int i = 0;
                    while (i < updates.length) {
                        updates[i].done();
                        ++i;
                    }
                }
            };
            count = 0;
            this.fFormattedValueRetriever.update(updates, (RequestMonitor)countingRm);
            ++count;
            subUpdates = new IPropertiesUpdate[updates.length];
            i = 0;
            while (i < updates.length) {
                update = updates[i];
                subUpdates[i] = new VMDelegatingPropertiesUpdate(update, (RequestMonitor)countingRm);
                ++count;
                ++i;
            }
            countingRm.setDoneCount(count);
            try {
                this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        VariableVMNode.this.updatePropertiesInSessionThread(subUpdates);
                    }
                });
                break block4;
            }
            catch (RejectedExecutionException e) {
                var9_8 = subUpdates;
                var8_9 = subUpdates.length;
                var7_10 = 0;
                ** while (var7_10 < var8_9)
            }
lbl-1000:
            // 1 sources

            {
                subUpdate = var9_8[var7_10];
                subUpdate.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10004, "Session executor shut down " + this.getSession().getExecutor(), (Throwable)e));
                subUpdate.done();
                ++var7_10;
                continue;
            }
        }
    }

    private Boolean getShowTypeNamesState(IPresentationContext context) {
        Boolean attribute = (Boolean)context.getProperty("org.eclipse.debug.ui.displayVariableTypeNames");
        if (attribute != null) {
            return attribute;
        }
        return Boolean.FALSE;
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void updatePropertiesInSessionThread(final IPropertiesUpdate[] updates) {
        IExpressions service = (IExpressions)this.getServicesTracker().getService(IExpressions.class, null);
        final CountingRequestMonitor countingRm = new CountingRequestMonitor(ImmediateExecutor.getInstance(), null){

            protected void handleCompleted() {
                IPropertiesUpdate[] iPropertiesUpdateArray = updates;
                int n = updates.length;
                int n2 = 0;
                while (n2 < n) {
                    IPropertiesUpdate update = iPropertiesUpdateArray[n2];
                    update.done();
                    ++n2;
                }
            }
        };
        int count = 0;
        IPropertiesUpdate[] iPropertiesUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IExpressions.IExpressionDMContext dmc;
            final IPropertiesUpdate update = iPropertiesUpdateArray[n2];
            final IExpression expression = (IExpression)DebugPlugin.getAdapter((Object)update.getElement(), IExpression.class);
            if (expression != null) {
                update.setProperty("element_expression", expression.getExpressionText());
            }
            if (update.getProperties().contains(PROP_VARIABLE_SHOW_TYPE_NAMES)) {
                update.setProperty(PROP_VARIABLE_SHOW_TYPE_NAMES, this.getShowTypeNamesState(update.getPresentationContext()));
            }
            if ((dmc = this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IExpressions.IExpressionDMContext.class)) == null || service == null) {
                update.setStatus(DsfUIPlugin.newErrorStatus(10001, "Invalid context or service not available.", null));
            } else {
                if (update.getProperties().contains("name") || update.getProperties().contains(PROP_VARIABLE_TYPE_NAME) || update.getProperties().contains(PROP_VARIABLE_BASIC_TYPE)) {
                    service.getExpressionData(dmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IExpressions.IExpressionDMData>(ImmediateExecutor.getInstance(), (IViewerUpdate)update){

                        protected void handleCompleted() {
                            if (this.isSuccess()) {
                                VariableVMNode.this.fillExpressionDataProperties(update, (IExpressions.IExpressionDMData)this.getData());
                            } else {
                                IExpressions.IExpressionDMContext dmc = (IExpressions.IExpressionDMContext)VariableVMNode.this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IExpressions.IExpressionDMContext.class);
                                if (dmc != null && dmc.getExpression() != null) {
                                    String displayName = VariableVMNode.this.getExpressionDisplayName(dmc, dmc.getExpression());
                                    update.setProperty("name", displayName);
                                    if (expression == null) {
                                        update.setProperty("element_expression", displayName);
                                    }
                                    if (dmc instanceof IExpressions.IIndexedPartitionDMContext) {
                                        update.setProperty(VariableVMNode.PROP_VARIABLE_BASIC_TYPE, VariableVMNode.INDEXED_PARTITION_TYPE);
                                    }
                                }
                                update.setStatus(this.getStatus());
                            }
                            countingRm.done();
                        }
                    });
                    ++count;
                }
                if (update.getProperties().contains(PROP_VARIABLE_ADDRESS)) {
                    service.getExpressionAddressData(dmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IExpressions.IExpressionDMAddress>(ImmediateExecutor.getInstance(), (IViewerUpdate)update){

                        protected void handleCompleted() {
                            if (this.isSuccess()) {
                                VariableVMNode.this.fillAddressDataProperties(update, (IExpressions.IExpressionDMAddress)this.getData());
                            } else if (this.getStatus().getCode() != 10003 && this.getStatus().getCode() != 10001) {
                                update.setStatus(this.getStatus());
                            }
                            countingRm.done();
                        }
                    });
                    ++count;
                }
            }
            ++n2;
        }
        countingRm.setDoneCount(count);
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void fillExpressionDataProperties(IPropertiesUpdate update, IExpressions.IExpressionDMData data) {
        IExpression expression;
        IExpressions.IExpressionDMContext dmc = this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IExpressions.IExpressionDMContext.class);
        String displayName = data.getName();
        if (dmc != null) {
            displayName = this.getExpressionDisplayName(dmc, displayName);
        }
        update.setProperty("name", displayName);
        update.setProperty(PROP_VARIABLE_TYPE_NAME, data.getTypeName());
        String typeValue = null;
        if (dmc instanceof IExpressions.IIndexedPartitionDMContext) {
            typeValue = INDEXED_PARTITION_TYPE;
        } else {
            IExpressions.IExpressionDMData.BasicType type = data.getBasicType();
            if (type != null) {
                typeValue = type.name();
            }
        }
        if (typeValue != null) {
            update.setProperty(PROP_VARIABLE_BASIC_TYPE, typeValue);
        }
        if ((expression = (IExpression)DebugPlugin.getAdapter((Object)update.getElement(), IExpression.class)) == null) {
            update.setProperty("element_expression", displayName);
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void fillAddressDataProperties(IPropertiesUpdate update, IExpressions.IExpressionDMAddress address) {
        if (address instanceof IExpressions.IExpressionDMLocation) {
            update.setProperty(PROP_VARIABLE_ADDRESS, ((IExpressions.IExpressionDMLocation)address).getLocation());
        } else {
            update.setProperty(PROP_VARIABLE_ADDRESS, "0x" + address.getAddress().toString(16));
        }
    }

    public CellEditor getCellEditor(IPresentationContext context, String columnId, Object element, Composite parent) {
        if ("org.eclipse.cdt.dsf.ui.COLUMN_ID__VALUE".equals(columnId)) {
            return new TextCellEditor(parent);
        }
        if ("org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_NAME".equals(columnId)) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        return new VariableCellModifier(this.getDMVMProvider(), this.fSyncVariableDataAccess);
    }

    @Override
    public boolean canParseExpression(IExpression expression) {
        return true;
    }

    @Override
    public void update(final IExpressionUpdate update) {
        try {
            this.getSession().getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    IExpressions expressionService = (IExpressions)VariableVMNode.this.getServicesTracker().getService(IExpressions.class);
                    if (expressionService != null) {
                        IExpressions.IExpressionDMContext expressionDMC = VariableVMNode.this.createExpression(expressionService, VariableVMNode.this.createCompositeDMVMContext(update), update.getExpression().getExpressionText());
                        VariableExpressionVMC variableVmc = (VariableExpressionVMC)VariableVMNode.this.createVMContext((IDMContext)expressionDMC);
                        variableVmc.setExpression(update.getExpression());
                        update.setExpressionElement(variableVmc);
                        update.done();
                    } else {
                        VariableVMNode.this.handleFailedUpdate(update);
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.handleFailedUpdate(update);
        }
    }

    @Override
    protected void handleFailedUpdate(IViewerUpdate update) {
        if (update instanceof IExpressionUpdate) {
            update.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10001, "Update failed", null));
            update.done();
        } else {
            super.handleFailedUpdate(update);
        }
    }

    @Override
    protected void associateExpression(Object element, IExpression expression) {
        if (element instanceof VariableExpressionVMC) {
            ((VariableExpressionVMC)element).setExpression(expression);
        }
    }

    @Override
    protected void updateHasElementsInSessionThread(final IHasChildrenUpdate update) {
        IExpressions.IExpressionDMContext expressionDMC = this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IExpressions.IExpressionDMContext.class);
        if (expressionDMC != null) {
            IExpressions expressionService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
            if (expressionService == null) {
                this.handleFailedUpdate((IViewerUpdate)update);
                return;
            }
            if (expressionService instanceof IExpressions3) {
                ((IExpressions3)expressionService).getExpressionDataExtension(expressionDMC, (DataRequestMonitor)new ViewerDataRequestMonitor<IExpressions3.IExpressionDMDataExtension>(this.getExecutor(), (IViewerUpdate)update){

                    protected void handleCompleted() {
                        if (!this.isSuccess()) {
                            VariableVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                            return;
                        }
                        IExpressions3.IExpressionDMDataExtension data = (IExpressions3.IExpressionDMDataExtension)this.getData();
                        update.setHasChilren(data.hasChildren());
                        update.done();
                    }
                });
            } else {
                expressionService.getSubExpressionCount(expressionDMC, (DataRequestMonitor)new ViewerDataRequestMonitor<Integer>(this.getExecutor(), (IViewerUpdate)update){

                    public void handleCompleted() {
                        if (!this.isSuccess()) {
                            VariableVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                            return;
                        }
                        update.setHasChilren((Integer)this.getData() > 0);
                        update.done();
                    }
                });
            }
        } else {
            super.updateHasElementsInSessionThread(update);
        }
    }

    @Override
    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void updateElementCountInSessionThread(final IChildrenCountUpdate update) {
        IExpressions.IExpressionDMContext expressionDMC = this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IExpressions.IExpressionDMContext.class);
        if (expressionDMC != null) {
            IExpressions expressionService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
            if (expressionService == null) {
                this.handleFailedUpdate((IViewerUpdate)update);
                return;
            }
            expressionService.getSubExpressionCount(expressionDMC, (DataRequestMonitor)new ViewerDataRequestMonitor<Integer>(this.getExecutor(), (IViewerUpdate)update){

                public void handleCompleted() {
                    if (!this.isSuccess()) {
                        VariableVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    update.setChildCount(((Integer)this.getData()).intValue());
                    update.done();
                }
            });
        } else {
            super.updateElementCountInSessionThread(update);
        }
    }

    @Override
    protected void updateElementsInSessionThread(IChildrenUpdate update) {
        IExpressions.IExpressionDMContext expressionDMC = this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IExpressions.IExpressionDMContext.class);
        if (expressionDMC != null) {
            this.getSubexpressionsUpdateElementsInSessionThread(update);
        } else {
            this.getLocalsUpdateElementsInSessionThread(update);
        }
    }

    private void getSubexpressionsUpdateElementsInSessionThread(final IChildrenUpdate update) {
        IExpressions.IExpressionDMContext expressionDMC = this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IExpressions.IExpressionDMContext.class);
        if (expressionDMC != null) {
            IExpressions expressionService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
            if (expressionService == null) {
                this.handleFailedUpdate((IViewerUpdate)update);
                return;
            }
            DsfExecutor dsfExecutor = this.getSession().getExecutor();
            ViewerDataRequestMonitor<IExpressions.IExpressionDMContext[]> rm = new ViewerDataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)dsfExecutor, (IViewerUpdate)update){

                public void handleCompleted() {
                    if (!this.isSuccess()) {
                        VariableVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    IExpressions.IExpressionDMContext[] data = (IExpressions.IExpressionDMContext[])this.getData();
                    if (VariableVMNode.this.fCastToTypeSupport != null) {
                        int i = 0;
                        while (i < data.length) {
                            data[i] = VariableVMNode.this.fCastToTypeSupport.replaceWithCastedExpression(data[i]);
                            ++i;
                        }
                    }
                    if (update.getOffset() < 0) {
                        VariableVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])data);
                    } else {
                        VariableVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])data, update.getOffset());
                    }
                    update.done();
                }
            };
            if (update.getOffset() < 0 || update.getLength() < 0) {
                expressionService.getSubExpressions(expressionDMC, (DataRequestMonitor)rm);
            } else {
                expressionService.getSubExpressions(expressionDMC, update.getOffset(), update.getLength(), (DataRequestMonitor)rm);
            }
        } else {
            this.handleFailedUpdate((IViewerUpdate)update);
        }
    }

    private void getLocalsUpdateElementsInSessionThread(final IChildrenUpdate update) {
        final IStack.IFrameDMContext frameDmc = this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IStack.IFrameDMContext.class);
        final IExpressions expressionService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
        final IStack stackFrameService = (IStack)this.getServicesTracker().getService(IStack.class);
        if (frameDmc == null || expressionService == null || stackFrameService == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        final DsfExecutor dsfExecutor = this.getSession().getExecutor();
        ViewerDataRequestMonitor<IStack.IVariableDMContext[]> rm = new ViewerDataRequestMonitor<IStack.IVariableDMContext[]>((Executor)dsfExecutor, (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.isSuccess()) {
                    VariableVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                IStack.IVariableDMContext[] localsDMCs = (IStack.IVariableDMContext[])this.getData();
                if (localsDMCs == null) {
                    VariableVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                if (localsDMCs.length == 0) {
                    update.done();
                    return;
                }
                final ArrayList localsDMData = new ArrayList();
                final ViewerCountingRequestMonitor crm = new ViewerCountingRequestMonitor((Executor)dsfExecutor, (IViewerUpdate)update){

                    public void handleCompleted() {
                        if (!this.isSuccess()) {
                            VariableVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                            return;
                        }
                        IExpressions.IExpressionDMContext[] expressionDMCs = new IExpressions.IExpressionDMContext[localsDMData.size()];
                        int i = 0;
                        for (IStack.IVariableDMData localDMData : localsDMData) {
                            expressionDMCs[i++] = VariableVMNode.this.createExpression(expressionService, (IDMContext)frameDmc, localDMData.getName());
                        }
                        VariableVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])expressionDMCs);
                        update.done();
                    }
                };
                int countRM = 0;
                IStack.IVariableDMContext[] iVariableDMContextArray = localsDMCs;
                int n = localsDMCs.length;
                int n2 = 0;
                while (n2 < n) {
                    IStack.IVariableDMContext localDMC = iVariableDMContextArray[n2];
                    DataRequestMonitor<IStack.IVariableDMData> rm = new DataRequestMonitor<IStack.IVariableDMData>((Executor)dsfExecutor, (RequestMonitor)crm){

                        public void handleSuccess() {
                            localsDMData.add((IStack.IVariableDMData)this.getData());
                            crm.done();
                        }
                    };
                    stackFrameService.getVariableData(localDMC, (DataRequestMonitor)rm);
                    ++countRM;
                    ++n2;
                }
                crm.setDoneCount(countRM);
            }
        };
        stackFrameService.getLocals(frameDmc, (DataRequestMonitor)rm);
    }

    private IExpressions.IExpressionDMContext createExpression(IExpressions expressionService, IDMContext dmc, String expression) {
        IExpressions.IExpressionDMContext exprDMC = expressionService.createExpression(dmc, expression);
        if (this.fCastToTypeSupport != null) {
            exprDMC = this.fCastToTypeSupport.replaceWithCastedExpression(exprDMC);
        }
        return exprDMC;
    }

    @Override
    public int getDeltaFlags(Object e) {
        if (e instanceof IRunControl.ISuspendedDMEvent || e instanceof IMemory.IMemoryChangedEvent || e instanceof IExpressions.IExpressionChangedDMEvent || e instanceof PropertyChangeEvent && (((PropertyChangeEvent)e).getProperty() == "CurrentNumericStyle" || ((PropertyChangeEvent)e).getProperty() == "org.eclipse.debug.ui.displayVariableTypeNames")) {
            return 1024;
        }
        if (e instanceof ElementFormatEvent) {
            int depth = ((ElementFormatEvent)e).getApplyDepth();
            if (depth == 0) {
                return 0;
            }
            if (depth == 1) {
                return 2048;
            }
            return 1024;
        }
        return 0;
    }

    @Override
    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        int depth;
        if (e instanceof IRunControl.ISuspendedDMEvent || e instanceof IMemory.IMemoryChangedEvent || e instanceof IExpressions.IExpressionChangedDMEvent || e instanceof PropertyChangeEvent && (((PropertyChangeEvent)e).getProperty() == "CurrentNumericStyle" || ((PropertyChangeEvent)e).getProperty() == "org.eclipse.debug.ui.displayVariableTypeNames")) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        } else if (e instanceof ElementFormatEvent && (depth = ((ElementFormatEvent)e).getApplyDepth()) != 0) {
            int deltaType = 1024;
            if (depth == 1) {
                deltaType = 2048;
            }
            Set<Object> elements = ((ElementFormatEvent)e).getElements();
            for (Object elem : elements) {
                parentDelta.addNode(elem, deltaType);
            }
        }
        requestMonitor.done();
    }

    @Override
    public int getDeltaFlagsForExpression(IExpression expression, Object event) {
        if (event instanceof IExpressions.IExpressionChangedDMEvent || event instanceof IMemory.IMemoryChangedEvent || event instanceof PropertyChangeEvent && (((PropertyChangeEvent)event).getProperty() == "CurrentNumericStyle" || ((PropertyChangeEvent)event).getProperty() == "org.eclipse.debug.ui.displayVariableTypeNames")) {
            return 1024;
        }
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        if (event instanceof ElementFormatEvent) {
            int depth = ((ElementFormatEvent)event).getApplyDepth();
            if (depth == 0) {
                return 0;
            }
            if (depth == 1) {
                return 2048;
            }
            return 1024;
        }
        return 0;
    }

    @Override
    public void buildDeltaForExpression(IExpression expression, int elementIdx, Object event, VMDelta parentDelta, TreePath path, RequestMonitor rm) {
        int depth;
        if (event instanceof IRunControl.ISuspendedDMEvent || event instanceof IMemory.IMemoryChangedEvent || event instanceof IExpressions.IExpressionChangedDMEvent || event instanceof PropertyChangeEvent && ((PropertyChangeEvent)event).getProperty() == "CurrentNumericStyle") {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        } else if (event instanceof ElementFormatEvent && (depth = ((ElementFormatEvent)event).getApplyDepth()) != 0) {
            int deltaType = 1024;
            if (depth == 1) {
                deltaType = 2048;
            }
            Set<Object> elements = ((ElementFormatEvent)event).getElements();
            for (Object elem : elements) {
                parentDelta.addNode(elem, deltaType);
            }
        }
        rm.done();
    }

    @Override
    public void buildDeltaForExpressionElement(Object element, int elementIdx, Object event, VMDelta parentDelta, RequestMonitor rm) {
        if (event instanceof IExpressions.IExpressionChangedDMEvent || event instanceof IMemory.IMemoryChangedEvent || event instanceof PropertyChangeEvent && ((PropertyChangeEvent)event).getProperty() == "CurrentNumericStyle") {
            parentDelta.addNode(element, 1024);
        }
        rm.done();
    }

    private String produceExpressionElementName(String viewName, IExpressions.IExpressionDMContext expression) {
        return "Variable." + expression.getExpression();
    }

    public void compareElements(IElementCompareRequest[] requests) {
        IElementCompareRequest[] iElementCompareRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext dmc;
            IElementCompareRequest request = iElementCompareRequestArray[n2];
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            String mementoName = memento.getString("VARIABLE_MEMENTO_NAME");
            if (mementoName != null && element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IExpressions.IExpressionDMContext) {
                String elementName = this.produceExpressionElementName(request.getPresentationContext().getId(), (IExpressions.IExpressionDMContext)dmc);
                request.setEqual(elementName.equals(mementoName));
            }
            request.done();
            ++n2;
        }
    }

    public void encodeElements(IElementMementoRequest[] requests) {
        IElementMementoRequest[] iElementMementoRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext dmc;
            IElementMementoRequest request = iElementMementoRequestArray[n2];
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            if (element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IExpressions.IExpressionDMContext) {
                String elementName = this.produceExpressionElementName(request.getPresentationContext().getId(), (IExpressions.IExpressionDMContext)dmc);
                memento.putString("VARIABLE_MEMENTO_NAME", elementName);
            }
            request.done();
            ++n2;
        }
    }

    protected String getExpressionDisplayName(IExpressions.IExpressionDMContext dmc, String name) {
        if (dmc instanceof IExpressions.IIndexedPartitionDMContext) {
            IExpressions.IIndexedPartitionDMContext ipDmc = (IExpressions.IIndexedPartitionDMContext)dmc;
            name = String.format("[%d...%d]", ipDmc.getIndex(), ipDmc.getIndex() + ipDmc.getLength() - 1);
        }
        return name;
    }

    protected class VariableExpressionFactory
    implements IWatchExpressionFactoryAdapter2 {
        protected VariableExpressionFactory() {
        }

        public boolean canCreateWatchExpression(Object element) {
            return element instanceof VariableExpressionVMC;
        }

        public String createWatchExpression(Object element) throws CoreException {
            VariableExpressionVMC exprVmc = (VariableExpressionVMC)element;
            IExpressions.IExpressionDMContext exprDmc = (IExpressions.IExpressionDMContext)DMContexts.getAncestorOfType((IDMContext)exprVmc.getDMContext(), IExpressions.IExpressionDMContext.class);
            if (exprDmc != null) {
                return exprDmc.getExpression();
            }
            return null;
        }
    }

    public class VariableExpressionVMC
    extends AbstractDMVMNode.DMVMContext
    implements IFormattedValueVMContext,
    IViewInMemory {
        private IExpression fExpression;

        public VariableExpressionVMC(IDMContext dmc) {
            super(VariableVMNode.this, dmc);
        }

        public String getExpression() {
            IExpressions.IExpressionDMContext exprDmc = (IExpressions.IExpressionDMContext)DMContexts.getAncestorOfType((IDMContext)this.getDMContext(), IExpressions.IExpressionDMContext.class);
            if (exprDmc != null) {
                return exprDmc.getExpression();
            }
            return "";
        }

        public void setExpression(IExpression expression) {
            this.fExpression = expression;
        }

        @Override
        public Object getAdapter(Class adapter) {
            if (this.fExpression != null && adapter.isAssignableFrom(this.fExpression.getClass())) {
                return this.fExpression;
            }
            if (adapter.isAssignableFrom(IWatchExpressionFactoryAdapter2.class)) {
                return VariableVMNode.this.fVariableExpressionFactory;
            }
            if (VariableVMNode.this.fCastToTypeSupport != null && this.getDMContext() instanceof IExpressions.IExpressionDMContext && (adapter.isAssignableFrom(ICastToType.class) || adapter.isAssignableFrom(ICastToArray.class))) {
                return VariableVMNode.this.fCastToTypeSupport.getCastImpl((IExpressions.IExpressionDMContext)this.getDMContext());
            }
            return super.getAdapter(adapter);
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof VariableExpressionVMC && super.equals(other)) {
                VariableExpressionVMC otherGroup = (VariableExpressionVMC)other;
                return otherGroup.fExpression == null && this.fExpression == null || otherGroup.fExpression != null && otherGroup.fExpression.equals(this.fExpression);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + (this.fExpression != null ? this.fExpression.hashCode() : 0);
        }

        public boolean canViewInMemory() {
            return true;
        }

        public void viewInMemory() {
            assert (false) : "VariableExpressionVMC.viewInMemory() not implemented";
        }
    }
}

