/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.qt.core;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.qt.core.QtPlugin;

public class QtKeywords {
    public static final String CONNECT = "connect";
    public static final String DISCONNECT = "disconnect";
    public static final String Q_CLASSINFO = "Q_CLASSINFO";
    public static final String Q_DECLARE_FLAGS = "Q_DECLARE_FLAGS";
    public static final String Q_ENUMS = "Q_ENUMS";
    public static final String Q_FLAGS = "Q_FLAGS";
    public static final String Q_GADGET = "Q_GADGET";
    public static final String Q_INVOKABLE = "Q_INVOKABLE";
    public static final String Q_OBJECT = "Q_OBJECT";
    public static final String Q_PROPERTY = "Q_PROPERTY";
    public static final String Q_REVISION = "Q_REVISION";
    public static final String Q_SIGNAL = "Q_SIGNAL";
    public static final String Q_SIGNALS = "Q_SIGNALS";
    public static final String Q_SLOT = "Q_SLOT";
    public static final String Q_SLOTS = "Q_SLOTS";
    public static final String QMETAMETHOD = "QMetaMethod";
    public static final String QML_ATTACHED_PROPERTIES = "qmlAttachedProperties";
    public static final String QML_REGISTER_TYPE = "qmlRegisterType";
    public static final String QML_REGISTER_UNCREATABLE_TYPE = "qmlRegisterUncreatableType";
    public static final String QOBJECT = "QObject";
    public static final String SIGNAL = "SIGNAL";
    public static final String SIGNALS = "signals";
    public static final String SLOT = "SLOT";
    public static final String SLOTS = "slots";

    public static boolean isQObject(IType type) {
        if (!(type instanceof ICPPClassType)) {
            return false;
        }
        ICPPClassType clsType = (ICPPClassType)type;
        return QOBJECT.equals(clsType.getName());
    }

    public static boolean isQMetaMethod(IType type) {
        if (!(type instanceof ICPPClassType)) {
            return false;
        }
        ICPPClassType clsType = (ICPPClassType)type;
        return QMETAMETHOD.equals(clsType.getName());
    }

    public static boolean is_QObject_connect(IBinding binding) {
        String[] qualName = QtKeywords.getFunctionQualifiedName(binding);
        return qualName != null && qualName.length == 2 && QOBJECT.equals(qualName[0]) && CONNECT.equals(qualName[1]);
    }

    public static boolean is_QObject_disconnect(IBinding binding) {
        String[] qualName = QtKeywords.getFunctionQualifiedName(binding);
        return qualName != null && qualName.length == 2 && QOBJECT.equals(qualName[0]) && DISCONNECT.equals(qualName[1]);
    }

    public static boolean is_QmlType(IBinding binding) {
        String[] qualName = QtKeywords.getFunctionQualifiedName(binding);
        return qualName != null && qualName.length == 1 && (QML_REGISTER_TYPE.equals(qualName[0]) || QML_REGISTER_UNCREATABLE_TYPE.equals(qualName[0]));
    }

    private static String[] getFunctionQualifiedName(IBinding binding) {
        if (binding instanceof ICPPFunction) {
            try {
                return ((ICPPFunction)binding).getQualifiedName();
            }
            catch (DOMException e) {
                QtPlugin.log(e);
            }
        }
        return null;
    }
}

