/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.codemanipulation;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.cdt.core.CCorePreferenceConstants;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.internal.core.parser.scanner.CPreprocessor;
import org.eclipse.cdt.internal.core.parser.scanner.IncludeSearchPath;
import org.eclipse.cdt.internal.core.parser.scanner.IncludeSearchPathElement;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerUtility;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.internal.corext.codemanipulation.IncludeInfo;
import org.eclipse.cdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.cdt.internal.ui.editor.SourceHeaderPartnerFinder;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeGroupStyle;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludePreferences;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class InclusionContext {
    private static final IPath UNRESOLVED_INCLUDE = Path.EMPTY;
    private final ITranslationUnit fTu;
    private final IProject fProject;
    private final IPath fCurrentDirectory;
    private final IncludeSearchPath fIncludeSearchPath;
    private final Map<IncludeInfo, IPath> fIncludeResolutionCache;
    private final Map<IPath, IncludeInfo> fInverseIncludeResolutionCache;
    private final IncludePreferences fPreferences;
    private String fSourceContents;
    private String fLineDelimiter;
    private Pattern fKeepPragmaPattern;
    private IPath fTuLocation;

    public InclusionContext(ITranslationUnit tu) {
        this.fTu = tu;
        this.fTuLocation = this.fTu.getLocation();
        ICProject cProject = this.fTu.getCProject();
        this.fProject = cProject.getProject();
        this.fCurrentDirectory = this.fTu.getResource().getParent().getLocation();
        IScannerInfo scannerInfo = this.fTu.getScannerInfo(true);
        this.fIncludeSearchPath = CPreprocessor.configureIncludeSearchPath((File)this.fCurrentDirectory.toFile(), (IScannerInfo)scannerInfo);
        this.fIncludeResolutionCache = new HashMap<IncludeInfo, IPath>();
        this.fInverseIncludeResolutionCache = new HashMap<IPath, IncludeInfo>();
        this.fPreferences = new IncludePreferences(cProject);
    }

    public final ITranslationUnit getTranslationUnit() {
        return this.fTu;
    }

    public final IProject getProject() {
        return this.fProject;
    }

    public final IPath getCurrentDirectory() {
        return this.fCurrentDirectory;
    }

    public final IncludePreferences getPreferences() {
        return this.fPreferences;
    }

    public IPath resolveInclude(IncludeInfo include) {
        IPath path = this.fIncludeResolutionCache.get(include);
        if (path == null) {
            String directory = this.fCurrentDirectory.toOSString();
            String filePath = CPreprocessor.getAbsoluteInclusionPath((String)include.getName(), (String)directory);
            if (filePath != null) {
                path = new Path(filePath);
            } else if (!include.isSystem() && !this.fIncludeSearchPath.isInhibitUseOfCurrentFileDirectory() && InclusionContext.fileExists(filePath = ScannerUtility.createReconciledPath((String)directory, (String)include.getName()))) {
                path = new Path(filePath);
            }
            if (path == null) {
                IncludeSearchPathElement[] includeSearchPathElementArray = this.fIncludeSearchPath.getElements();
                int n = includeSearchPathElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IncludeSearchPathElement pathElement = includeSearchPathElementArray[n2];
                    if (!(include.isSystem() && pathElement.isForQuoteIncludesOnly() || !InclusionContext.fileExists(filePath = pathElement.getLocation(include.getName())))) {
                        path = new Path(filePath);
                        break;
                    }
                    ++n2;
                }
            }
            if (path == null) {
                path = UNRESOLVED_INCLUDE;
            }
            this.fIncludeResolutionCache.put(include, path);
            this.fInverseIncludeResolutionCache.put(path, include);
        }
        return path == UNRESOLVED_INCLUDE ? null : path;
    }

    public IncludeInfo getIncludeForHeaderFile(IPath fullPath) {
        IncludeInfo include = this.fInverseIncludeResolutionCache.get(fullPath);
        if (include != null) {
            return include;
        }
        String headerLocation = fullPath.toOSString();
        String shortestInclude = null;
        boolean isSystem = false;
        IncludeSearchPathElement[] includeSearchPathElementArray = this.fIncludeSearchPath.getElements();
        int n = includeSearchPathElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IncludeSearchPathElement pathElement = includeSearchPathElementArray[n2];
            String includeDirective = pathElement.getIncludeDirective(headerLocation);
            if (includeDirective != null && (shortestInclude == null || shortestInclude.length() > includeDirective.length())) {
                shortestInclude = includeDirective;
                isSystem = !pathElement.isForQuoteIncludesOnly();
            }
            ++n2;
        }
        if (shortestInclude == null) {
            if (this.fIncludeSearchPath.isInhibitUseOfCurrentFileDirectory() || !this.fCurrentDirectory.isPrefixOf(fullPath)) {
                return null;
            }
            shortestInclude = fullPath.setDevice(null).removeFirstSegments(this.fCurrentDirectory.segmentCount()).toString();
        }
        include = new IncludeInfo(shortestInclude, isSystem);
        this.fInverseIncludeResolutionCache.put(fullPath, include);
        return include;
    }

    public IncludeInfo getIncludeForHeaderFile(IPath fullPath, boolean isSystem) {
        IncludeInfo include = this.fInverseIncludeResolutionCache.get(fullPath);
        if (include != null) {
            return include;
        }
        String headerLocation = fullPath.toOSString();
        String shortestInclude = null;
        IncludeSearchPathElement[] includeSearchPathElementArray = this.fIncludeSearchPath.getElements();
        int n = includeSearchPathElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            String includeDirective;
            IncludeSearchPathElement pathElement = includeSearchPathElementArray[n2];
            if (!(isSystem && pathElement.isForQuoteIncludesOnly() || (includeDirective = pathElement.getIncludeDirective(headerLocation)) == null || shortestInclude != null && shortestInclude.length() <= includeDirective.length())) {
                shortestInclude = includeDirective;
            }
            ++n2;
        }
        if (shortestInclude == null) {
            if (this.fIncludeSearchPath.isInhibitUseOfCurrentFileDirectory() || !this.fCurrentDirectory.isPrefixOf(fullPath)) {
                return null;
            }
            shortestInclude = fullPath.setDevice(null).removeFirstSegments(this.fCurrentDirectory.segmentCount()).toString();
        }
        include = new IncludeInfo(shortestInclude, isSystem);
        this.fInverseIncludeResolutionCache.put(fullPath, include);
        return include;
    }

    public IncludeGroupStyle getIncludeStyle(IPath headerPath) {
        IncludeGroupStyle.IncludeKind includeKind;
        IncludeInfo includeInfo = this.getIncludeForHeaderFile(headerPath);
        if (includeInfo != null && includeInfo.isSystem()) {
            includeKind = headerPath.getFileExtension() == null ? IncludeGroupStyle.IncludeKind.SYSTEM_WITHOUT_EXTENSION : IncludeGroupStyle.IncludeKind.SYSTEM_WITH_EXTENSION;
        } else if (this.isPartnerFile(headerPath)) {
            includeKind = IncludeGroupStyle.IncludeKind.PARTNER;
        } else {
            IPath dir = this.getCurrentDirectory();
            if (dir.isPrefixOf(headerPath)) {
                includeKind = headerPath.segmentCount() == dir.segmentCount() + 1 ? IncludeGroupStyle.IncludeKind.IN_SAME_FOLDER : IncludeGroupStyle.IncludeKind.IN_SUBFOLDER;
            } else {
                IFile[] files = ResourceLookup.findFilesForLocation((IPath)headerPath);
                if (files.length == 0) {
                    includeKind = IncludeGroupStyle.IncludeKind.EXTERNAL;
                } else {
                    IProject project = this.getProject();
                    includeKind = IncludeGroupStyle.IncludeKind.IN_OTHER_PROJECT;
                    IFile[] iFileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFile file = iFileArray[n2];
                        if (file.getProject().equals((Object)project)) {
                            includeKind = IncludeGroupStyle.IncludeKind.IN_SAME_PROJECT;
                            break;
                        }
                        ++n2;
                    }
                }
            }
        }
        return this.fPreferences.includeStyles.get((Object)includeKind);
    }

    public IncludeGroupStyle getIncludeStyle(IncludeInfo includeInfo) {
        IPath path = Path.fromPortableString((String)includeInfo.getName());
        IncludeGroupStyle.IncludeKind includeKind = includeInfo.isSystem() ? (path.getFileExtension() == null ? IncludeGroupStyle.IncludeKind.SYSTEM_WITHOUT_EXTENSION : IncludeGroupStyle.IncludeKind.SYSTEM_WITH_EXTENSION) : (this.isPartnerFile(path) ? IncludeGroupStyle.IncludeKind.PARTNER : IncludeGroupStyle.IncludeKind.EXTERNAL);
        return this.fPreferences.includeStyles.get((Object)includeKind);
    }

    private static boolean fileExists(String absolutePath) {
        return new File(absolutePath).exists();
    }

    public boolean isPartnerFile(IPath path) {
        return SourceHeaderPartnerFinder.isPartnerFile(this.getTranslationUnitLocation(), path, this.fPreferences.partnerFileSuffixes);
    }

    public IncludeInfo createIncludeInfo(IPath header, IncludeGroupStyle style) {
        IncludeInfo includeInfo;
        String name = null;
        if (style.isRelativePath()) {
            name = this.getRelativePath(header);
        }
        if (name == null && (name = (includeInfo = this.getIncludeForHeaderFile(header)) != null ? includeInfo.getName() : this.getRelativePath(header)) == null) {
            name = header.toPortableString();
        }
        return new IncludeInfo(name, style.isAngleBrackets());
    }

    private String getRelativePath(IPath header) {
        IPath relativePath = PathUtil.makeRelativePath((IPath)header, (IPath)this.getCurrentDirectory());
        if (relativePath == null) {
            return null;
        }
        return relativePath.toString();
    }

    public String getSourceContents() {
        if (this.fSourceContents == null) {
            this.fSourceContents = new String(this.fTu.getContents());
        }
        return this.fSourceContents;
    }

    public String getLineDelimiter() {
        if (this.fLineDelimiter == null) {
            try {
                this.fLineDelimiter = StubUtility.getLineDelimiterUsed((ICElement)this.fTu);
            }
            catch (CModelException cModelException) {
                this.fLineDelimiter = System.getProperty("line.separator", "\n");
            }
        }
        return this.fLineDelimiter;
    }

    public Pattern getKeepPragmaPattern() {
        if (this.fKeepPragmaPattern == null) {
            String keepPattern = CCorePreferenceConstants.getPreference((String)"includes.keepPattern", (IProject)this.fProject, (String)"IWYU\\s+(pragma:?\\s+)?keep");
            try {
                this.fKeepPragmaPattern = Pattern.compile(keepPattern);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.fKeepPragmaPattern = Pattern.compile("IWYU\\s+(pragma:?\\s+)?keep");
            }
        }
        return this.fKeepPragmaPattern;
    }

    public void setTranslationUnitLocation(IPath location) {
        this.fTuLocation = location;
    }

    public IPath getTranslationUnitLocation() {
        return this.fTuLocation;
    }
}

