/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler;

import java.util.List;
import java.util.Stack;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.Literal;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.IElementRequestor;

public class SourceElementRequestVisitor
extends ASTVisitor {
    protected IElementRequestor fRequestor = null;
    protected boolean fInClass = false;
    protected boolean fInMethod = false;
    protected TypeDeclaration fCurrentClass = null;
    protected MethodDeclaration fCurrentMethod = null;
    protected Stack<ASTNode> fNodes = new Stack();

    public SourceElementRequestVisitor(IElementRequestor requesor) {
        this.fRequestor = requesor;
    }

    public MethodDeclaration getCurrentMethod() {
        return this.fCurrentMethod;
    }

    protected TypeDeclaration getCurrentClass() {
        return this.fCurrentClass;
    }

    protected String makeLanguageDependentValue(ASTNode expr) {
        return "";
    }

    protected void onEndVisitMethod(MethodDeclaration method) {
    }

    protected String[] processSuperClasses(TypeDeclaration type) {
        List names = type.getSuperClassNames();
        if (names == null) {
            return null;
        }
        if (names.isEmpty()) {
            return null;
        }
        return names.toArray(new String[names.size()]);
    }

    protected void onEndVisitClass(TypeDeclaration type) {
    }

    protected void modifyMethodInfo(MethodDeclaration methodDeclaration, IElementRequestor.MethodInfo mi) {
    }

    protected void modifyClassInfo(TypeDeclaration typeDeclaration, IElementRequestor.TypeInfo ti) {
    }

    protected String makeValue(ASTNode stmt) {
        String value = "";
        value = stmt instanceof StringLiteral ? "\"" + ((StringLiteral)stmt).getValue() + "\"" : (stmt instanceof Literal ? ((Literal)stmt).getValue() : String.valueOf(value) + this.makeLanguageDependentValue(stmt));
        return value;
    }

    @Override
    public boolean endvisit(MethodDeclaration method) throws Exception {
        this.fRequestor.exitMethod(method.sourceEnd());
        this.fInMethod = false;
        this.fCurrentMethod = null;
        this.onEndVisitMethod(method);
        this.fNodes.pop();
        return true;
    }

    @Override
    public boolean endvisit(TypeDeclaration type) throws Exception {
        this.fRequestor.exitType(type.sourceEnd());
        this.fInClass = false;
        this.fCurrentClass = null;
        this.onEndVisitClass(type);
        this.fNodes.pop();
        return true;
    }

    @Override
    public boolean visit(MethodDeclaration method) throws Exception {
        this.fNodes.push(method);
        List args = method.getArguments();
        String[] parameter = new String[args.size()];
        String[] initializers = new String[args.size()];
        int a = 0;
        while (a < args.size()) {
            Argument arg = (Argument)args.get(a);
            parameter[a] = arg.getName();
            if (arg.getInitialization() != null && arg.getInitialization() instanceof Literal) {
                Literal scalar = (Literal)arg.getInitialization();
                initializers[a] = scalar.getValue();
            }
            ++a;
        }
        IElementRequestor.MethodInfo mi = new IElementRequestor.MethodInfo();
        mi.parameterNames = parameter;
        mi.name = method.getName();
        mi.modifiers = method.getModifiers();
        mi.nameSourceStart = method.getNameStart();
        mi.nameSourceEnd = method.getNameEnd() - 1;
        mi.declarationStart = method.sourceStart();
        mi.parameterInitializers = initializers;
        this.modifyMethodInfo(method, mi);
        this.fRequestor.enterMethod(mi);
        this.fInMethod = true;
        this.fCurrentMethod = method;
        return true;
    }

    @Override
    public boolean visit(TypeDeclaration type) throws Exception {
        this.fNodes.push(type);
        IElementRequestor.TypeInfo info = new IElementRequestor.TypeInfo();
        info.modifiers = type.getModifiers();
        info.name = type.getName();
        info.nameSourceStart = type.getNameStart();
        info.nameSourceEnd = type.getNameEnd() - 1;
        info.declarationStart = type.sourceStart();
        info.superclasses = this.processSuperClasses(type);
        this.modifyClassInfo(type, info);
        this.fRequestor.enterType(info);
        this.fInClass = true;
        this.fCurrentClass = type;
        return true;
    }

    @Override
    public boolean endvisit(ModuleDeclaration declaration) throws Exception {
        this.fRequestor.exitModule(declaration.sourceEnd());
        this.fNodes.pop();
        return true;
    }

    @Override
    public boolean visit(ModuleDeclaration declaration) throws Exception {
        this.fNodes.push(declaration);
        this.fRequestor.enterModule();
        return true;
    }

    @Override
    public boolean endvisit(Expression expression) throws Exception {
        this.fNodes.pop();
        return true;
    }

    @Override
    public boolean endvisit(Statement statement) throws Exception {
        this.fNodes.pop();
        return true;
    }

    @Override
    public boolean visit(Expression expression) throws Exception {
        this.fNodes.push(expression);
        return true;
    }

    @Override
    public boolean visit(Statement statement) throws Exception {
        this.fNodes.push(statement);
        return true;
    }
}

