/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.compare;

import com.google.common.base.Function;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.compare.CDOComparisonScope;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.conflict.IConflictDetector;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.equi.IEquiEngine;
import org.eclipse.emf.compare.match.DefaultComparisonFactory;
import org.eclipse.emf.compare.match.DefaultEqualityHelperFactory;
import org.eclipse.emf.compare.match.DefaultMatchEngine;
import org.eclipse.emf.compare.match.IComparisonFactory;
import org.eclipse.emf.compare.match.IEqualityHelperFactory;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.IdentifierEObjectMatcher;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryRegistryImpl;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.req.IReqEngine;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOCompare {
    public Comparison compare(IComparisonScope scope) {
        CDOIDFunction idFunction = this.createIDFunction();
        IdentifierEObjectMatcher matcher = this.createMatcher(idFunction);
        IEqualityHelperFactory equalityHelperFactory = this.createEqualityHelperFactory();
        IComparisonFactory comparisonFactory = this.createComparisonFactory(equalityHelperFactory);
        EMFCompare comparator = this.createComparator((IEObjectMatcher)matcher, comparisonFactory);
        Comparison comparison = comparator.compare(scope);
        comparison.eAdapters().add((Object)new ComparisonScopeAdapter(scope));
        return comparison;
    }

    protected CDOIDFunction createIDFunction() {
        return new CDOIDFunction();
    }

    protected IdentifierEObjectMatcher createMatcher(Function<EObject, String> idFunction) {
        return new IdentifierEObjectMatcher(idFunction);
    }

    protected IEqualityHelperFactory createEqualityHelperFactory() {
        return new DefaultEqualityHelperFactory();
    }

    protected IComparisonFactory createComparisonFactory(IEqualityHelperFactory equalityHelperFactory) {
        return new DefaultComparisonFactory(equalityHelperFactory);
    }

    protected EMFCompare createComparator(IEObjectMatcher matcher, IComparisonFactory comparisonFactory) {
        IConflictDetector conflictDetector;
        IPostProcessor.Descriptor.Registry<?> registry;
        IEquiEngine equiEngine;
        IReqEngine reqEngine;
        IDiffEngine diffEngine;
        EMFCompare.Builder builder = EMFCompare.builder();
        IMatchEngine.Factory.Registry matchEngineFactoryRegistry = this.createMatchEngineFactoryRegistry(matcher, comparisonFactory);
        if (matchEngineFactoryRegistry != null) {
            builder.setMatchEngineFactoryRegistry(matchEngineFactoryRegistry);
        }
        if ((diffEngine = this.createDiffEngine()) != null) {
            builder.setDiffEngine(diffEngine);
        }
        if ((reqEngine = this.createRequirementEngine()) != null) {
            builder.setRequirementEngine(reqEngine);
        }
        if ((equiEngine = this.createEquivalenceEngine()) != null) {
            builder.setEquivalenceEngine(equiEngine);
        }
        if ((registry = this.createPostProcessorRegistry()) != null) {
            builder.setPostProcessorRegistry(registry);
        }
        if ((conflictDetector = this.createConflictDetector()) != null) {
            builder.setConflictDetector(conflictDetector);
        }
        return builder.build();
    }

    protected IMatchEngine.Factory.Registry createMatchEngineFactoryRegistry(IEObjectMatcher matcher, IComparisonFactory comparisonFactory) {
        MatchEngineFactoryRegistryImpl registry = new MatchEngineFactoryRegistryImpl();
        registry.add((IMatchEngine.Factory)new CDOMatchEngine.Factory(matcher, comparisonFactory));
        return registry;
    }

    protected IDiffEngine createDiffEngine() {
        return null;
    }

    protected IReqEngine createRequirementEngine() {
        return null;
    }

    protected IEquiEngine createEquivalenceEngine() {
        return null;
    }

    protected IPostProcessor.Descriptor.Registry<?> createPostProcessorRegistry() {
        return null;
    }

    protected IConflictDetector createConflictDetector() {
        return null;
    }

    public static IComparisonScope getScope(Comparison comparison) {
        ComparisonScopeAdapter adapter = (ComparisonScopeAdapter)((Object)EMFUtil.getAdapter((Notifier)comparison, ComparisonScopeAdapter.class));
        if (adapter == null) {
            return null;
        }
        return adapter.getScope();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CDOIDFunction
    implements Function<EObject, String> {
        public String apply(EObject o) {
            CDOObject object = CDOUtil.getCDOObject((EObject)o);
            CDOID id = object.cdoID();
            StringBuilder builder = new StringBuilder();
            CDOIDUtil.write((StringBuilder)builder, (CDOID)id);
            return builder.toString();
        }
    }

    public static class CDOMatchEngine
    extends DefaultMatchEngine {
        CDOMatchEngine(IEObjectMatcher matcher, IComparisonFactory comparisonFactory) {
            super(matcher, comparisonFactory);
        }

        protected void match(Comparison comparison, IComparisonScope scope, Notifier left, Notifier right, Notifier origin, Monitor monitor) {
            this.match(comparison, scope, (EObject)left, (EObject)right, (EObject)origin, monitor);
        }

        public static class Factory
        implements IMatchEngine.Factory {
            private final IMatchEngine matchEngine;
            private int ranking;

            public Factory(IEObjectMatcher matcher, IComparisonFactory comparisonFactory) {
                this.matchEngine = this.createMatchEngine(matcher, comparisonFactory);
            }

            protected Factory(IMatchEngine matchEngine) {
                this.matchEngine = matchEngine;
            }

            protected CDOMatchEngine createMatchEngine(IEObjectMatcher matcher, IComparisonFactory comparisonFactory) {
                return new CDOMatchEngine(matcher, comparisonFactory);
            }

            public IMatchEngine getMatchEngine() {
                return this.matchEngine;
            }

            public int getRanking() {
                return this.ranking;
            }

            public void setRanking(int ranking) {
                this.ranking = ranking;
            }

            public boolean isMatchEngineFactoryFor(IComparisonScope scope) {
                return scope instanceof CDOComparisonScope;
            }
        }
    }

    private static final class ComparisonScopeAdapter
    extends AdapterImpl {
        private IComparisonScope scope;

        public ComparisonScopeAdapter(IComparisonScope scope) {
            this.scope = scope;
        }

        public final IComparisonScope getScope() {
            return this.scope;
        }

        public boolean isAdapterForType(Object type) {
            return type == ComparisonScopeAdapter.class;
        }
    }
}

