/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.examples.acore.graphiti.features;

import org.eclipse.emf.cdo.dawn.examples.acore.AClass;
import org.eclipse.emf.cdo.dawn.helper.DawnEditorHelper;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;

public class AcoreRenameAClassFeature
extends AbstractCustomFeature {
    private boolean hasDoneChanges = false;

    public AcoreRenameAClassFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return "Rename AClass";
    }

    public String getDescription() {
        return "Change the name of the AClass";
    }

    public boolean canExecute(ICustomContext context) {
        Object bo;
        boolean ret = false;
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof AClass) {
            ret = true;
        }
        return ret;
    }

    public void execute(ICustomContext context) {
        Object bo;
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof AClass) {
            AClass AClass2 = (AClass)bo;
            String currentName = AClass2.getName();
            String newName = this.askString(this.getName(), this.getDescription(), currentName);
            if (newName != null && !newName.equals(currentName)) {
                this.hasDoneChanges = true;
                AClass2.setName(newName);
                this.updatePictogramElement(pes[0]);
            }
        }
    }

    public boolean hasDoneChanges() {
        return this.hasDoneChanges;
    }

    public String askString(String dialogTitle, String dialogMessage, String initialValue) {
        String ret = null;
        Shell shell = DawnEditorHelper.getActiveShell();
        InputDialog inputDialog = new InputDialog(shell, dialogTitle, dialogMessage, initialValue, null);
        int retDialog = inputDialog.open();
        if (retDialog == 0) {
            ret = inputDialog.getValue();
        }
        return ret;
    }
}

