/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.gmf.editors.impl;

import java.util.Map;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.dawn.appearance.DawnElementStylizer;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditor;
import org.eclipse.emf.cdo.dawn.editors.impl.DawnAbstractEditorSupport;
import org.eclipse.emf.cdo.dawn.gmf.appearance.DawnAppearancer;
import org.eclipse.emf.cdo.dawn.gmf.notifications.impl.DawnGMFHandler;
import org.eclipse.emf.cdo.dawn.gmf.notifications.impl.DawnGMFLockingHandler;
import org.eclipse.emf.cdo.dawn.gmf.synchronize.DawnChangeHelper;
import org.eclipse.emf.cdo.dawn.gmf.util.DawnDiagramUpdater;
import org.eclipse.emf.cdo.dawn.notifications.BasicDawnListener;
import org.eclipse.emf.cdo.dawn.spi.DawnState;
import org.eclipse.emf.cdo.dawn.ui.stylizer.DawnElementStylizerRegistry;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandlerBase;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DawnGMFEditorSupport
extends DawnAbstractEditorSupport {
    private DawnGMFHandler dawnGMFHandler;

    public DawnGMFEditorSupport(IDawnEditor editor) {
        super(editor);
        this.dawnGMFHandler = this.createDawnGMFHandler(editor);
    }

    public void close() {
        CDOView view = this.getView();
        if (view != null && !view.isClosed()) {
            view.close();
        }
    }

    protected BasicDawnListener getBasicHandler() {
        return this.dawnGMFHandler;
    }

    protected DawnGMFHandler createDawnGMFHandler(IDawnEditor editor) {
        return new DawnGMFHandler(editor);
    }

    protected BasicDawnListener getLockingHandler() {
        return new DawnGMFLockingHandler(this.getEditor());
    }

    protected CDOTransactionHandlerBase getTransactionHandler() {
        return this.dawnGMFHandler;
    }

    public void rollback() {
        super.rollback();
        final DiagramDocumentEditor diagramDocumentEditor = DawnGMFEditorSupport.getDiagramEditor(this.getEditor());
        TransactionalEditingDomain editingDomain = diagramDocumentEditor.getEditingDomain();
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

            public void doExecute() {
                DawnAppearancer.setEditPartDefaultAllChildren((EditPart)diagramDocumentEditor.getDiagramEditPart());
                DawnDiagramUpdater.refreshEditPart((EditPart)diagramDocumentEditor.getDiagramEditPart());
            }
        });
    }

    public static DiagramDocumentEditor getDiagramEditor(IDawnEditor editor) {
        if (editor instanceof DiagramDocumentEditor) {
            return (DiagramDocumentEditor)editor;
        }
        return (DiagramDocumentEditor)editor.getAdapter(DiagramDocumentEditor.class);
    }

    public void refresh() {
        final DiagramDocumentEditor diagramDocumentEditor = DawnGMFEditorSupport.getDiagramEditor(this.getEditor());
        TransactionalEditingDomain editingDomain = diagramDocumentEditor.getEditingDomain();
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

            public void doExecute() {
                DawnDiagramUpdater.refreshEditPart((EditPart)diagramDocumentEditor.getDiagramEditPart());
            }
        });
    }

    public void lockObject(Object objectToBeLocked) {
        if (objectToBeLocked instanceof EditPart) {
            DawnElementStylizer stylizer;
            EditPart editPart = (EditPart)objectToBeLocked;
            Object model = editPart.getModel();
            if (model instanceof EObject) {
                CDOUtil.getCDOObject((EObject)((EObject)model)).cdoWriteLock().lock();
                if (model instanceof View) {
                    EObject element = ((View)model).getElement();
                    CDOUtil.getCDOObject((EObject)element).cdoWriteLock().lock();
                }
            }
            if ((stylizer = DawnElementStylizerRegistry.instance.getStylizer((Object)editPart)) != null) {
                stylizer.setLocked((Object)editPart, 3);
            }
        }
        this.refresh();
    }

    public void unlockObject(Object objectToBeUnlocked) {
        if (objectToBeUnlocked instanceof EditPart) {
            DawnElementStylizer stylizer;
            EditPart editPart = (EditPart)objectToBeUnlocked;
            Object model = editPart.getModel();
            if (model instanceof EObject) {
                CDOUtil.getCDOObject((EObject)((EObject)model)).cdoWriteLock().unlock();
                if (model instanceof View) {
                    EObject element = ((View)model).getElement();
                    CDOUtil.getCDOObject((EObject)element).cdoWriteLock().unlock();
                }
            }
            if ((stylizer = DawnElementStylizerRegistry.instance.getStylizer((Object)editPart)) != null) {
                stylizer.setDefault((Object)editPart);
            }
        }
        this.refresh();
    }

    public void handleRemoteLockChanges(Map<Object, DawnState> changedObjects) {
        for (Object o : changedObjects.keySet()) {
            this.handleLock((CDOObject)o, this.getView());
        }
        this.refresh();
    }

    private void handleLock(CDOObject object, CDOView cdoView) {
        EObject element = CDOUtil.getEObject((EObject)object);
        View view = DawnDiagramUpdater.findView(element);
        if (view != null) {
            EditPart editPart = DawnDiagramUpdater.createOrFindEditPartIfViewExists(view, DawnGMFEditorSupport.getDiagramEditor(this.getEditor()));
            if (object.cdoWriteLock().isLocked()) {
                DawnAppearancer.setEditPartLocked(editPart, 3);
            } else if (object.cdoWriteLock().isLockedByOthers()) {
                DawnAppearancer.setEditPartLocked(editPart, 4);
                DawnChangeHelper.deactivateEditPart(editPart);
            } else {
                DawnAppearancer.setEditPartDefault(editPart);
                DawnChangeHelper.activateEditPart(editPart);
            }
        }
    }
}

