/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceLeaf;
import org.eclipse.emf.cdo.internal.ui.CDOEditorInputImpl;
import org.eclipse.emf.cdo.internal.ui.CDOLobEditorInput;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.ui.editor.CDOEditor;
import org.eclipse.emf.cdo.ui.CDOEditorInput;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public final class CDOEditorUtil {
    public static final String EDITOR_ID = "org.eclipse.emf.cdo.ui.CDOEditor";
    private static final IEditorRegistry EDITOR_REGISTRY = PlatformUI.getWorkbench().getEditorRegistry();
    private static final Map<CDOResourceLeaf, String> EDITOR_OVERRIDES = new WeakHashMap<CDOResourceLeaf, String>();
    private static final String TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    private static String editorID = "org.eclipse.emf.cdo.ui.CDOEditor";

    private CDOEditorUtil() {
    }

    public static String getEditorID() {
        return editorID;
    }

    public static void setEditorID(String editorID) {
        CDOEditorUtil.editorID = editorID;
    }

    public static CDOEditorInput createCDOEditorInput(CDOView view, String resourcePath, boolean viewOwned) {
        return new CDOEditorInputImpl(view, resourcePath, viewOwned);
    }

    public static CDOEditorInput createCDOEditorInputWithEditingDomain(CDOEditorInput input, EditingDomain editingDomain) {
        return CDOEditorUtil.createCDOEditorInputWithEditingDomain(input.getView(), input.getResourcePath(), input.isViewOwned(), editingDomain);
    }

    public static CDOEditorInput createCDOEditorInputWithEditingDomain(CDOView view, String resourcePath, boolean viewOwned, EditingDomain editingDomain) {
        class CDOEditorInputWithEditingDomain
        extends CDOEditorInputImpl
        implements IEditingDomainProvider {
            private final EditingDomain editingDomain;

            CDOEditorInputWithEditingDomain(CDOView view, String resourcePath, boolean viewOwned, EditingDomain editingDomain) {
                super(view, resourcePath, viewOwned);
                this.editingDomain = editingDomain;
            }

            public EditingDomain getEditingDomain() {
                return this.editingDomain;
            }

            public Object getAdapter(Class adapter) {
                if (adapter == IEditingDomainProvider.class) {
                    return this;
                }
                return super.getAdapter(adapter);
            }
        }
        return new CDOEditorInputWithEditingDomain(view, resourcePath, viewOwned, editingDomain);
    }

    public static void openEditor(final IWorkbenchPage page, final CDOView view, final String resourcePath) {
        Display display = page.getWorkbenchWindow().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                try {
                    IEditorReference[] references = CDOEditorUtil.findEditor(page, view, resourcePath);
                    if (references.length != 0) {
                        IEditorPart editor = references[0].getEditor(true);
                        page.activate((IWorkbenchPart)editor);
                    } else {
                        CDOEditorInput input = CDOEditorUtil.createCDOEditorInput(view, resourcePath, false);
                        page.openEditor((IEditorInput)input, editorID);
                    }
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        });
    }

    public static IEditorReference[] findEditor(IWorkbenchPage page, CDOView view, String resourcePath) {
        IEditorReference[] editorReferences;
        ArrayList<IEditorReference> result = new ArrayList<IEditorReference>();
        IEditorReference[] iEditorReferenceArray = editorReferences = page.getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            try {
                CDOEditorInput cdoInput;
                IEditorInput editorInput;
                if (ObjectUtil.equals((Object)editorReference.getId(), (Object)editorID) && (editorInput = editorReference.getEditorInput()) instanceof CDOEditorInput && (cdoInput = (CDOEditorInput)editorInput).getView() == view && (resourcePath == null || ObjectUtil.equals((Object)cdoInput.getResourcePath(), (Object)resourcePath))) {
                    result.add(editorReference);
                }
            }
            catch (PartInitException ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++n2;
        }
        return result.toArray(new IEditorReference[result.size()]);
    }

    public static void populateMenu(IMenuManager manager, CDOResourceLeaf resource, IWorkbenchPage page) {
        String effectiveEditorID = CDOEditorUtil.getEffectiveEditorID(resource);
        manager.add((IAction)new OpenEditorAction(page, effectiveEditorID, resource, false));
        String[] editorIDs = CDOEditorUtil.getAllEditorIDs(resource);
        if (editorIDs.length > 1 || editorIDs.length == 1 && !editorIDs[0].equals(effectiveEditorID)) {
            MenuManager subMenu = new MenuManager("Open With");
            manager.add((IContributionItem)subMenu);
            String[] stringArray = editorIDs;
            int n = editorIDs.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                OpenEditorAction action = new OpenEditorAction(page, id, resource, true);
                subMenu.add((IAction)action);
                if (id.equals(effectiveEditorID)) {
                    action.setChecked(true);
                }
                ++n2;
            }
        }
    }

    public static String getEffectiveEditorID(CDOResourceLeaf resource) {
        String editorID = EDITOR_OVERRIDES.get(resource);
        if (editorID != null) {
            return editorID;
        }
        if (resource instanceof CDOResource) {
            return EDITOR_ID;
        }
        String name = resource.getName();
        IEditorDescriptor editorDescriptor = EDITOR_REGISTRY.getDefaultEditor(name);
        if (editorDescriptor != null) {
            return editorDescriptor.getId();
        }
        return TEXT_EDITOR_ID;
    }

    public static String[] getAllEditorIDs(CDOResourceLeaf resource) {
        ArrayList<String> editorIDs = new ArrayList<String>();
        if (resource instanceof CDOResource) {
            editorIDs.add(EDITOR_ID);
        }
        String name = resource.getName();
        IEditorDescriptor[] iEditorDescriptorArray = EDITOR_REGISTRY.getEditors(name);
        int n = iEditorDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorDescriptor editorDescriptor = iEditorDescriptorArray[n2];
            editorIDs.add(editorDescriptor.getId());
            ++n2;
        }
        if (!editorIDs.contains(TEXT_EDITOR_ID) && EDITOR_REGISTRY.findEditor(TEXT_EDITOR_ID) != null) {
            editorIDs.add(TEXT_EDITOR_ID);
        }
        Collections.sort(editorIDs);
        return editorIDs.toArray(new String[editorIDs.size()]);
    }

    public static IEditorInput createEditorInput(String editorID, CDOResourceLeaf resource, boolean viewOwned) {
        if (resource instanceof CDOResource && EDITOR_ID.equals(editorID)) {
            CDOView view = resource.cdoView();
            String path = resource.getPath();
            return CDOEditorUtil.createCDOEditorInput(view, path, viewOwned);
        }
        return new CDOLobEditorInput(resource);
    }

    public static IEditorInput createEditorInput(String editorID, CDOResourceLeaf resource) {
        return CDOEditorUtil.createEditorInput(editorID, resource, false);
    }

    public static void openEditor(IWorkbenchPage page, CDOResourceLeaf resource) {
        String editorID = CDOEditorUtil.getEffectiveEditorID(resource);
        if (editorID != null) {
            CDOEditorUtil.openEditor(page, editorID, resource);
        }
    }

    public static void openEditor(final IWorkbenchPage page, final String editorID, final CDOResourceLeaf resource) {
        Display display = page.getWorkbenchWindow().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                try {
                    IEditorInput editorInput = CDOEditorUtil.createEditorInput(editorID, resource);
                    page.openEditor(editorInput, editorID);
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                }
            }
        });
    }

    public static void refreshEditors(IWorkbenchPage page, CDOView view) {
        IEditorReference[] references;
        IEditorReference[] iEditorReferenceArray = references = CDOEditorUtil.findEditor(page, view, null);
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference reference = iEditorReferenceArray[n2];
            CDOEditor editor = (CDOEditor)reference.getEditor(false);
            if (editor != null) {
                editor.refreshViewer(null);
            }
            ++n2;
        }
    }

    private static class OpenEditorAction
    extends Action {
        private IWorkbenchPage page;
        private String editorID;
        private CDOResourceLeaf resource;
        private boolean overrideOnRun;

        public OpenEditorAction(IWorkbenchPage page, String editorID, CDOResourceLeaf resource, boolean overrideOnRun) {
            this.page = page;
            this.editorID = editorID;
            this.resource = resource;
            this.overrideOnRun = overrideOnRun;
            IEditorDescriptor editorDescriptor = EDITOR_REGISTRY.findEditor(editorID);
            String label = editorDescriptor.getLabel();
            if (overrideOnRun) {
                this.setText(label);
            } else {
                this.setText("Open With " + label);
            }
            this.setImageDescriptor(editorDescriptor.getImageDescriptor());
            this.setToolTipText("Open the " + label + " editor on this resource");
        }

        public void run() {
            if (this.overrideOnRun) {
                EDITOR_OVERRIDES.put(this.resource, this.editorID);
            }
            CDOEditorUtil.openEditor(this.page, this.editorID, this.resource);
        }
    }
}

