/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.workspace.internal.efs;

import java.io.File;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.workspace.CDOWorkspace;
import org.eclipse.emf.cdo.workspace.efs.CDOFS;
import org.eclipse.emf.cdo.workspace.internal.efs.AbstractResourceNodeStore;
import org.eclipse.emf.cdo.workspace.internal.efs.CDOProjectDescriptionStore;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.Closeable;
import org.eclipse.net4j.util.io.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOWorkspaceStore
extends AbstractResourceNodeStore {
    private static final AbstractResourceNodeStore NO_PARENT = null;
    private String name;
    private File location;
    private CDOWorkspace workspace;
    private Map<String, Long> lastModifiedTimes = new HashMap<String, Long>();
    private CDOView view;
    private SaveContext saveContext;

    public CDOWorkspaceStore(String name, File location) {
        this.name = name;
        this.location = location;
    }

    public File getLocation() {
        return this.location;
    }

    public synchronized CDOWorkspace getWorkspace() {
        if (this.workspace == null) {
            this.workspace = this.openWorkspace();
        }
        return this.workspace;
    }

    public synchronized void setWorkspace(CDOWorkspace workspace) {
        this.workspace = workspace;
    }

    private CDOWorkspace openWorkspace() {
        try {
            return CDOFS.open(this.name, this.location);
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    @Override
    public AbstractResourceNodeStore getParent() {
        return NO_PARENT;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public java.net.URI toURI() {
        try {
            return new java.net.URI("cdo.workspace://" + this.name);
        }
        catch (URISyntaxException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    @Override
    public IFileStore getChild(String name) {
        if (".project".equals(name)) {
            return new CDOProjectDescriptionStore(this);
        }
        return super.getChild(name);
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        return this;
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        if (this.view != null) {
            IOUtil.close((Closeable)this.view);
            this.view = null;
        }
    }

    @Override
    public CDOWorkspaceStore getWorkspaceStore() {
        return this;
    }

    public long getLastModified(String path) {
        Long time = this.lastModifiedTimes.get(path);
        return time == null ? 0L : time;
    }

    public void setLastModified(String path, long time) {
        this.lastModifiedTimes.put(path, time);
    }

    public SaveContext getSaveContext() {
        if (this.saveContext == null) {
            this.saveContext = new SaveContext();
        }
        return this.saveContext;
    }

    @Override
    public String getPath() {
        return "";
    }

    @Override
    protected synchronized CDOView getView() {
        if (this.view == null) {
            this.view = this.workspace.openView();
        }
        return this.view;
    }

    @Override
    protected CDOResourceNode getResourceNode(CDOView view) {
        return view.getRootResource();
    }

    @Override
    protected boolean isDirectory(CDOResourceNode node) {
        return true;
    }

    @Override
    protected void collectChildNames(CDOResourceNode node, List<String> childNames) {
        childNames.add(".project");
        CDOResource rootResource = (CDOResource)node;
        for (EObject content : rootResource.getContents()) {
            if (!(content instanceof CDOResourceNode)) continue;
            CDOResourceNode child = (CDOResourceNode)content;
            childNames.add(child.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class SaveContext {
        private CDOTransaction transaction;
        private Map<String, InternalCDOObject> newObjects;
        private Map<String, List<ForwardReference>> forwardReferences;
        private XMIResource xmiResource;

        public SaveContext() {
            this.transaction = CDOWorkspaceStore.this.workspace.openTransaction();
            this.newObjects = new HashMap<String, InternalCDOObject>();
            this.forwardReferences = new HashMap<String, List<ForwardReference>>();
        }

        public void save(XMIResource xmiResource, String cdoPath) {
            this.xmiResource = xmiResource;
            try {
                CDOResource cdoResource = this.transaction.getOrCreateResource(cdoPath);
                this.saveContents((EList<EObject>)xmiResource.getContents(), (EList<EObject>)cdoResource.getContents());
            }
            finally {
                this.xmiResource = null;
                this.done();
            }
        }

        private void saveContents(EList<EObject> xmiContents, EList<EObject> cdoContents) {
            int size = xmiContents.size();
            int i = 0;
            while (i < size) {
                EObject xmiObject = (EObject)xmiContents.get(i);
                InternalCDOObject cdoObject = this.getCDOObjectByXMIID(xmiObject);
                if (cdoObject == null) {
                    cdoObject = this.createNewCDOObject(xmiObject);
                    cdoContents.add(i, (Object)cdoObject);
                } else {
                    int index = cdoContents.indexOf((Object)cdoObject);
                    if (index != -1) {
                        if (index != i) {
                            cdoContents.move(i, index);
                        }
                    } else {
                        cdoContents.add(i, (Object)cdoObject);
                    }
                }
                this.saveObject((InternalEObject)xmiObject, cdoObject);
                ++i;
            }
            this.shortenList(cdoContents, size);
        }

        private void saveObject(InternalEObject xmiObject, InternalCDOObject cdoObject) {
            for (EStructuralFeature feature : xmiObject.eClass().getEAllStructuralFeatures()) {
                Object xmiElement;
                int i;
                int size;
                EList cdoElements;
                EList xmiElements;
                Object xmiValue;
                block14: {
                    InternalCDOObject cdoValue;
                    EReference reference;
                    block15: {
                        xmiValue = xmiObject.eGet(feature);
                        if (!(feature instanceof EReference)) break block14;
                        reference = (EReference)feature;
                        if (reference.isContainment()) {
                            if (reference.isMany()) {
                                EList xmiContents = (EList)xmiValue;
                                EList cdoContents = (EList)cdoObject.eGet((EStructuralFeature)reference);
                                this.saveContents((EList<EObject>)xmiContents, (EList<EObject>)cdoContents);
                                continue;
                            }
                            if (xmiValue != null) {
                                cdoValue = this.getCDOObjectByXMIID((EObject)xmiValue);
                                if (cdoValue == null) {
                                    cdoValue = this.createNewCDOObject((EObject)xmiValue);
                                }
                                cdoObject.eSet((EStructuralFeature)reference, (Object)cdoValue);
                                this.saveObject((InternalEObject)xmiValue, cdoValue);
                                continue;
                            }
                            cdoObject.eSet((EStructuralFeature)reference, null);
                            continue;
                        }
                        if (!reference.isMany()) break block15;
                        xmiElements = (EList)xmiValue;
                        cdoElements = (EList)cdoObject.eGet((EStructuralFeature)reference);
                        size = xmiElements.size();
                        i = 0;
                        while (i < size) {
                            block18: {
                                int index;
                                InternalCDOObject cdoElement;
                                block17: {
                                    block16: {
                                        xmiElement = (InternalEObject)xmiElements.get(i);
                                        URI eProxyURI = xmiElement.eProxyURI();
                                        if (eProxyURI == null) break block16;
                                        String href = eProxyURI.fragment();
                                        cdoElement = this.getCDOObjectByHREF(href);
                                        if (cdoElement != null) break block17;
                                        this.registerForwardReference(cdoObject, reference, i, href);
                                        InternalCDOObject dummy = this.createNewCDOObject((EObject)xmiElement);
                                        cdoElements.add(i, (Object)dummy);
                                        break block18;
                                    }
                                    cdoElement = this.getCDOObjectByXMIID((EObject)xmiElement);
                                }
                                if ((index = cdoElements.indexOf((Object)cdoElement)) != -1) {
                                    cdoElements.move(i, index);
                                } else {
                                    cdoElements.add(i, (Object)cdoElement);
                                }
                            }
                            ++i;
                        }
                        this.shortenList((EList<EObject>)cdoElements, size);
                        continue;
                    }
                    cdoValue = null;
                    if (xmiValue != null) {
                        URI eProxyURI = ((InternalEObject)xmiValue).eProxyURI();
                        if (eProxyURI != null) {
                            String href = eProxyURI.fragment();
                            cdoValue = this.getCDOObjectByHREF(href);
                            if (cdoValue == null) {
                                this.registerForwardReference(cdoObject, reference, -1, href);
                            }
                        } else {
                            cdoValue = this.getCDOObjectByXMIID((EObject)xmiValue);
                        }
                    }
                    cdoObject.eSet((EStructuralFeature)reference, (Object)cdoValue);
                    continue;
                }
                EAttribute attribute = (EAttribute)feature;
                if (attribute.isMany()) {
                    xmiElements = (EList)xmiValue;
                    cdoElements = (EList)cdoObject.eGet((EStructuralFeature)attribute);
                    cdoElements.clear();
                    size = xmiElements.size();
                    i = 0;
                    while (i < size) {
                        xmiElement = xmiElements.get(i);
                        cdoElements.add(xmiElement);
                        ++i;
                    }
                    continue;
                }
                cdoObject.eSet((EStructuralFeature)attribute, xmiValue);
            }
        }

        private InternalCDOObject getCDOObjectByXMIID(EObject xmiObject) {
            String xmiID = this.xmiResource.getID(xmiObject);
            if (xmiID != null) {
                try {
                    CDOID id = CDOIDUtil.read((String)xmiID);
                    if (!CDOIDUtil.isNull((CDOID)id)) {
                        return (InternalCDOObject)this.transaction.getObject(id);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return null;
        }

        private InternalCDOObject createNewCDOObject(EObject xmiObject) {
            EObject newInstance = EcoreUtil.create((EClass)xmiObject.eClass());
            InternalCDOObject cdoObject = (InternalCDOObject)CDOUtil.getCDOObject((EObject)newInstance);
            String fragment = this.xmiResource.getURIFragment(xmiObject);
            this.newObjects.put(fragment, cdoObject);
            return cdoObject;
        }

        private void shortenList(EList<EObject> list, int size) {
            int remove = list.size() - size;
            while (remove-- != 0) {
                list.remove(list.size() - 1);
            }
        }

        private InternalCDOObject getCDOObjectByHREF(String href) {
            InternalCDOObject cdoObject = null;
            try {
                CDOID id = CDOIDUtil.read((String)href);
                cdoObject = (InternalCDOObject)this.transaction.getObject(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cdoObject == null) {
                cdoObject = this.newObjects.get(href);
            }
            return cdoObject;
        }

        private void done() {
            if (this.resolveForwardReferences()) {
                this.commit();
            }
        }

        private void registerForwardReference(InternalCDOObject cdoObject, EReference reference, int index, String href) {
            List<ForwardReference> list = this.forwardReferences.get(href);
            if (list == null) {
                list = new ArrayList<ForwardReference>();
                this.forwardReferences.put(href, list);
            }
            list.add(new ForwardReference(cdoObject, reference, index));
        }

        private boolean resolveForwardReferences() {
            Set<Map.Entry<String, List<ForwardReference>>> entrySet = this.forwardReferences.entrySet();
            Iterator<Map.Entry<String, List<ForwardReference>>> it = entrySet.iterator();
            while (it.hasNext()) {
                Map.Entry<String, List<ForwardReference>> entry = it.next();
                String href = entry.getKey();
                InternalCDOObject target = this.getCDOObjectByHREF(href);
                if (target == null) continue;
                List<ForwardReference> list = entry.getValue();
                for (ForwardReference forwardReference : list) {
                    forwardReference.resolve(target);
                }
                it.remove();
            }
            return this.forwardReferences.isEmpty();
        }

        private void commit() {
            try {
                try {
                    this.transaction.commit();
                }
                catch (CommitException ex) {
                    throw WrappedException.wrap((Exception)((Object)ex));
                }
            }
            finally {
                IOUtil.closeSilent((Closeable)this.transaction);
                this.transaction = null;
                this.forwardReferences = null;
                this.newObjects = null;
                CDOWorkspaceStore.this.saveContext = null;
            }
        }

        private final class ForwardReference {
            private InternalCDOObject source;
            private EReference reference;
            private int index;

            public ForwardReference(InternalCDOObject source, EReference reference, int index) {
                this.source = source;
                this.reference = reference;
                this.index = index;
            }

            public void resolve(InternalCDOObject target) {
                if (this.reference.isMany()) {
                    EList list = (EList)this.source.eGet((EStructuralFeature)this.reference);
                    list.set(this.index, (Object)target);
                } else {
                    this.source.eSet((EStructuralFeature)this.reference, (Object)target);
                }
            }
        }
    }
}

