/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.view;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.cdo.view.CDOStaleObject;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.internal.cdo.messages.Messages;

public interface CDOStaleReferencePolicy {
    public static final CDOStaleReferencePolicy EXCEPTION = new CDOStaleReferencePolicy(){

        public Object processStaleReference(EObject source, EStructuralFeature feature, int index, CDOID target) {
            throw new ObjectNotFoundException(target);
        }

        public String toString() {
            return Messages.getString("CDOStaleReferencePolicy.0");
        }
    };
    public static final CDOStaleReferencePolicy PROXY;
    public static final CDOStaleReferencePolicy DEFAULT;

    static {
        DEFAULT = PROXY = new CDOStaleReferencePolicy(){

            public Object processStaleReference(final EObject source, EStructuralFeature feature, int index, final CDOID target) {
                final EClassifier type = feature.getEType();
                InvocationHandler handler = new InvocationHandler(){

                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        String name = method.getName();
                        if (name.equals("cdoID")) {
                            return target;
                        }
                        if (name.equals("eIsProxy")) {
                            return false;
                        }
                        if (name.equals("eClass")) {
                            return type;
                        }
                        if (name.equals("eAdapters")) {
                            return source.eAdapters();
                        }
                        throw new ObjectNotFoundException(target);
                    }
                };
                Class instanceClass = type.getInstanceClass();
                Class[] interfaces = null;
                interfaces = instanceClass.isInterface() ? new Class[]{instanceClass, InternalEObject.class, CDOStaleObject.class} : new Class[]{InternalEObject.class, CDOStaleObject.class};
                return Proxy.newProxyInstance(instanceClass.getClassLoader(), interfaces, handler);
            }

            public String toString() {
                return Messages.getString("CDOStaleReferencePolicy.1");
            }
        };
    }

    public Object processStaleReference(EObject var1, EStructuralFeature var2, int var3, CDOID var4);
}

