/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.transaction;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.util.CommitConflictException;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.ContainmentCycleException;
import org.eclipse.emf.cdo.util.OptimisticLockingException;
import org.eclipse.emf.cdo.util.ReferentialIntegrityException;
import org.eclipse.emf.cdo.util.ValidationException;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.CDOTransactionStrategy;
import org.eclipse.emf.spi.cdo.InternalCDOSavepoint;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOUserSavepoint;
import org.eclipse.net4j.util.om.monitor.EclipseMonitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class CDOSingleTransactionStrategyImpl
implements CDOTransactionStrategy {
    public static final CDOSingleTransactionStrategyImpl INSTANCE = new CDOSingleTransactionStrategyImpl();

    public CDOCommitInfo commit(InternalCDOTransaction transaction, IProgressMonitor progressMonitor) throws Exception {
        InternalCDOTransaction.InternalCDOCommitContext commitContext = transaction.createCommitContext();
        CDOCommitData commitData = commitContext.getCommitData();
        commitContext.preCommit();
        CDOSession session = transaction.getSession();
        CDOSessionProtocol sessionProtocol = session.getSessionProtocol();
        EclipseMonitor monitor = new EclipseMonitor(progressMonitor);
        CDOSessionProtocol.CommitTransactionResult result = sessionProtocol.commitTransaction(commitContext, (OMMonitor)monitor);
        commitContext.postCommit(result);
        String rollbackMessage = result.getRollbackMessage();
        if (rollbackMessage != null) {
            byte rollbackReason = result.getRollbackReason();
            switch (rollbackReason) {
                case 1: {
                    throw new OptimisticLockingException(rollbackMessage);
                }
                case 2: {
                    throw new CommitConflictException(rollbackMessage);
                }
                case 3: {
                    throw new ContainmentCycleException(rollbackMessage);
                }
                case 4: {
                    throw new ReferentialIntegrityException(rollbackMessage, result.getXRefs());
                }
                case 5: {
                    throw new ValidationException(rollbackMessage);
                }
                case 0: {
                    throw new CommitException(rollbackMessage);
                }
            }
            throw new IllegalStateException("Invalid rollbackreason: " + rollbackReason);
        }
        String comment = transaction.getCommitComment();
        transaction.setCommitComment(null);
        long previousTimeStamp = result.getPreviousTimeStamp();
        CDOBranch branch = transaction.getBranch();
        long timeStamp = result.getTimeStamp();
        String userID = session.getUserID();
        InternalCDOCommitInfoManager commitInfoManager = session.getCommitInfoManager();
        return commitInfoManager.createCommitInfo(branch, timeStamp, previousTimeStamp, userID, comment, commitData);
    }

    public void rollback(InternalCDOTransaction transaction, InternalCDOUserSavepoint savepoint) {
        transaction.handleRollback((InternalCDOSavepoint)savepoint);
    }

    public InternalCDOUserSavepoint setSavepoint(InternalCDOTransaction transaction) {
        return transaction.handleSetSavepoint();
    }

    public void setTarget(InternalCDOTransaction transaction) {
    }

    public void unsetTarget(InternalCDOTransaction transaction) {
    }
}

