/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.generator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenClassGeneratorAdapter;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenEnumGeneratorAdapter;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenModelGeneratorAdapter;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenModelGeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenPackageGeneratorAdapter;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccessExtension2;
import org.eclipse.xtext.generator.IFileSystemAccessExtension3;

public class XcoreGenModelGeneratorAdapterFactory
extends GenModelGeneratorAdapterFactory {
    private static final URI ROOT = URI.createURI((String)"/");
    private IFileSystemAccess fsa;
    private URI modelDirectory;
    private Boolean isDefaultOutput;

    public void setFileSystemAccess(IFileSystemAccess fsa) {
        this.fsa = fsa;
    }

    public void setModelDirectory(URI modelDirectory) {
        this.modelDirectory = !modelDirectory.hasTrailingPathSeparator() ? modelDirectory.appendSegment("") : modelDirectory;
    }

    private boolean isDefaultOutput() {
        if (this.isDefaultOutput == null) {
            URI uri;
            if (this.fsa instanceof IFileSystemAccessExtension2 && (uri = ((IFileSystemAccessExtension2)this.fsa).getURI(".")).isPlatformResource()) {
                String path = String.valueOf(uri.toPlatformString(true)) + "/";
                if (path.equals(this.modelDirectory.toString())) {
                    this.isDefaultOutput = Boolean.TRUE;
                    return this.isDefaultOutput;
                }
                this.isDefaultOutput = Boolean.FALSE;
                return this.isDefaultOutput;
            }
            this.isDefaultOutput = Boolean.TRUE;
            return this.isDefaultOutput;
        }
        return this.isDefaultOutput;
    }

    private boolean shouldMerge(URI workspacePath) {
        if (this.isDefaultOutput()) {
            int segmentCount = this.modelDirectory.segmentCount() - 1;
            if (workspacePath.segmentCount() > segmentCount) {
                int i = 0;
                while (i < segmentCount) {
                    if (!workspacePath.segment(i).equals(this.modelDirectory.segment(i))) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        }
        return true;
    }

    protected OutputStream createOutputStream(URI workspacePath) {
        if (!this.isDefaultOutput()) {
            return null;
        }
        final URI targetFile = workspacePath.replacePrefix(this.modelDirectory, ROOT);
        if (targetFile == null) {
            return null;
        }
        this.getGenerator().generatedOutput(workspacePath);
        return new ByteArrayOutputStream(){

            public void close() throws IOException {
                if (XcoreGenModelGeneratorAdapterFactory.this.fsa instanceof IFileSystemAccessExtension3) {
                    ((IFileSystemAccessExtension3)XcoreGenModelGeneratorAdapterFactory.this.fsa).generateFile(targetFile.toString(), (InputStream)new ByteArrayInputStream(this.buf, 0, this.count));
                } else {
                    XcoreGenModelGeneratorAdapterFactory.this.fsa.generateFile(targetFile.toString(), (CharSequence)new String(this.toByteArray()));
                }
                super.close();
            }
        };
    }

    protected void inputStreamRequest(URI workspacePath) {
        URI targetFile;
        if (this.isDefaultOutput() && this.fsa instanceof FileSystemReadAccess && (targetFile = workspacePath.replacePrefix(this.modelDirectory, ROOT)) != null) {
            ((FileSystemReadAccess)this.fsa).readFile(workspacePath.toString());
        }
    }

    public Adapter createGenModelAdapter() {
        if (this.genModelGeneratorAdapter == null) {
            this.genModelGeneratorAdapter = new GenModelGeneratorAdapter((GeneratorAdapterFactory)this){

                protected OutputStream createOutputStream(URI workspacePath) throws Exception {
                    OutputStream result = XcoreGenModelGeneratorAdapterFactory.this.createOutputStream(workspacePath);
                    return result == null ? super.createOutputStream(workspacePath) : result;
                }

                protected InputStream createInputStream(URI workspacePath) throws Exception {
                    XcoreGenModelGeneratorAdapterFactory.this.inputStreamRequest(workspacePath);
                    return super.createInputStream(workspacePath);
                }

                protected boolean shouldMerge(URI workspacePath) {
                    return XcoreGenModelGeneratorAdapterFactory.this.shouldMerge(workspacePath);
                }
            };
        }
        return this.genModelGeneratorAdapter;
    }

    public Adapter createGenPackageAdapter() {
        if (this.genPackageGeneratorAdapter == null) {
            this.genPackageGeneratorAdapter = new GenPackageGeneratorAdapter((GeneratorAdapterFactory)this){

                protected OutputStream createOutputStream(URI workspacePath) throws Exception {
                    OutputStream result = XcoreGenModelGeneratorAdapterFactory.this.createOutputStream(workspacePath);
                    return result == null ? super.createOutputStream(workspacePath) : result;
                }

                protected InputStream createInputStream(URI workspacePath) throws Exception {
                    XcoreGenModelGeneratorAdapterFactory.this.inputStreamRequest(workspacePath);
                    return super.createInputStream(workspacePath);
                }

                protected boolean shouldMerge(URI workspacePath) {
                    return XcoreGenModelGeneratorAdapterFactory.this.shouldMerge(workspacePath);
                }
            };
        }
        return this.genPackageGeneratorAdapter;
    }

    public Adapter createGenClassAdapter() {
        if (this.genClassGeneratorAdapter == null) {
            this.genClassGeneratorAdapter = new GenClassGeneratorAdapter((GeneratorAdapterFactory)this){

                protected OutputStream createOutputStream(URI workspacePath) throws Exception {
                    OutputStream result = XcoreGenModelGeneratorAdapterFactory.this.createOutputStream(workspacePath);
                    return result == null ? super.createOutputStream(workspacePath) : result;
                }

                protected InputStream createInputStream(URI workspacePath) throws Exception {
                    XcoreGenModelGeneratorAdapterFactory.this.inputStreamRequest(workspacePath);
                    return super.createInputStream(workspacePath);
                }

                protected boolean shouldMerge(URI workspacePath) {
                    return XcoreGenModelGeneratorAdapterFactory.this.shouldMerge(workspacePath);
                }
            };
        }
        return this.genClassGeneratorAdapter;
    }

    public Adapter createGenEnumAdapter() {
        if (this.genEnumGeneratorAdapter == null) {
            this.genEnumGeneratorAdapter = new GenEnumGeneratorAdapter((GeneratorAdapterFactory)this){

                protected OutputStream createOutputStream(URI workspacePath) throws Exception {
                    OutputStream result = XcoreGenModelGeneratorAdapterFactory.this.createOutputStream(workspacePath);
                    return result == null ? super.createOutputStream(workspacePath) : result;
                }

                protected InputStream createInputStream(URI workspacePath) throws Exception {
                    XcoreGenModelGeneratorAdapterFactory.this.inputStreamRequest(workspacePath);
                    return super.createInputStream(workspacePath);
                }

                protected boolean shouldMerge(URI workspacePath) {
                    return XcoreGenModelGeneratorAdapterFactory.this.shouldMerge(workspacePath);
                }
            };
        }
        return this.genEnumGeneratorAdapter;
    }

    public static interface FileSystemReadAccess {
        public void readFile(String var1);
    }
}

