/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.impl;

import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.xcore.XAnnotation;
import org.eclipse.emf.ecore.xcore.XAnnotationDirective;
import org.eclipse.emf.ecore.xcore.XAttribute;
import org.eclipse.emf.ecore.xcore.XClass;
import org.eclipse.emf.ecore.xcore.XDataType;
import org.eclipse.emf.ecore.xcore.XEnum;
import org.eclipse.emf.ecore.xcore.XEnumLiteral;
import org.eclipse.emf.ecore.xcore.XGenericType;
import org.eclipse.emf.ecore.xcore.XImportDirective;
import org.eclipse.emf.ecore.xcore.XOperation;
import org.eclipse.emf.ecore.xcore.XPackage;
import org.eclipse.emf.ecore.xcore.XParameter;
import org.eclipse.emf.ecore.xcore.XReference;
import org.eclipse.emf.ecore.xcore.XTypeParameter;
import org.eclipse.emf.ecore.xcore.XcoreFactory;
import org.eclipse.emf.ecore.xcore.XcorePackage;
import org.eclipse.emf.ecore.xcore.impl.XAnnotationDirectiveImpl;
import org.eclipse.emf.ecore.xcore.impl.XAnnotationImpl;
import org.eclipse.emf.ecore.xcore.impl.XAttributeImpl;
import org.eclipse.emf.ecore.xcore.impl.XClassImpl;
import org.eclipse.emf.ecore.xcore.impl.XDataTypeImpl;
import org.eclipse.emf.ecore.xcore.impl.XEnumImpl;
import org.eclipse.emf.ecore.xcore.impl.XEnumLiteralImpl;
import org.eclipse.emf.ecore.xcore.impl.XGenericTypeImpl;
import org.eclipse.emf.ecore.xcore.impl.XImportDirectiveImpl;
import org.eclipse.emf.ecore.xcore.impl.XOperationImpl;
import org.eclipse.emf.ecore.xcore.impl.XPackageImpl;
import org.eclipse.emf.ecore.xcore.impl.XParameterImpl;
import org.eclipse.emf.ecore.xcore.impl.XReferenceImpl;
import org.eclipse.emf.ecore.xcore.impl.XStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.xcore.impl.XTypeParameterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XcoreFactoryImpl
extends EFactoryImpl
implements XcoreFactory {
    public static XcoreFactory init() {
        try {
            XcoreFactory theXcoreFactory = (XcoreFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/emf/2011/Xcore");
            if (theXcoreFactory != null) {
                return theXcoreFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new XcoreFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createXAnnotation();
            }
            case 1: {
                return this.createXAnnotationDirective();
            }
            case 2: {
                return this.createXAttribute();
            }
            case 3: {
                return this.createXClass();
            }
            case 5: {
                return this.createXDataType();
            }
            case 6: {
                return this.createXEnum();
            }
            case 7: {
                return this.createXEnumLiteral();
            }
            case 8: {
                return this.createXGenericType();
            }
            case 9: {
                return this.createXImportDirective();
            }
            case 13: {
                return this.createXOperation();
            }
            case 14: {
                return this.createXPackage();
            }
            case 15: {
                return this.createXParameter();
            }
            case 16: {
                return this.createXReference();
            }
            case 17: {
                return (EObject)this.createXStringToStringMapEntry();
            }
            case 20: {
                return this.createXTypeParameter();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 21: {
                return this.createXMultiplicityFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 21: {
                return this.convertXMultiplicityToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public XAnnotation createXAnnotation() {
        XAnnotationImpl xAnnotation = new XAnnotationImpl();
        return xAnnotation;
    }

    @Override
    public XAnnotationDirective createXAnnotationDirective() {
        XAnnotationDirectiveImpl xAnnotationDirective = new XAnnotationDirectiveImpl();
        return xAnnotationDirective;
    }

    @Override
    public XAttribute createXAttribute() {
        XAttributeImpl xAttribute = new XAttributeImpl();
        return xAttribute;
    }

    @Override
    public XClass createXClass() {
        XClassImpl xClass = new XClassImpl();
        return xClass;
    }

    @Override
    public XDataType createXDataType() {
        XDataTypeImpl xDataType = new XDataTypeImpl();
        return xDataType;
    }

    @Override
    public XEnum createXEnum() {
        XEnumImpl xEnum = new XEnumImpl();
        return xEnum;
    }

    @Override
    public XEnumLiteral createXEnumLiteral() {
        XEnumLiteralImpl xEnumLiteral = new XEnumLiteralImpl();
        return xEnumLiteral;
    }

    @Override
    public XGenericType createXGenericType() {
        XGenericTypeImpl xGenericType = new XGenericTypeImpl();
        return xGenericType;
    }

    @Override
    public XImportDirective createXImportDirective() {
        XImportDirectiveImpl xImportDirective = new XImportDirectiveImpl();
        return xImportDirective;
    }

    @Override
    public XOperation createXOperation() {
        XOperationImpl xOperation = new XOperationImpl();
        return xOperation;
    }

    @Override
    public XPackage createXPackage() {
        XPackageImpl xPackage = new XPackageImpl();
        return xPackage;
    }

    @Override
    public XParameter createXParameter() {
        XParameterImpl xParameter = new XParameterImpl();
        return xParameter;
    }

    @Override
    public XReference createXReference() {
        XReferenceImpl xReference = new XReferenceImpl();
        return xReference;
    }

    public Map.Entry<String, String> createXStringToStringMapEntry() {
        XStringToStringMapEntryImpl xStringToStringMapEntry = new XStringToStringMapEntryImpl();
        return xStringToStringMapEntry;
    }

    @Override
    public XTypeParameter createXTypeParameter() {
        XTypeParameterImpl xTypeParameter = new XTypeParameterImpl();
        return xTypeParameter;
    }

    public int[] createXMultiplicityFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null) {
            return null;
        }
        int startingIndex = initialValue.indexOf(91);
        if (startingIndex != -1) {
            int endingIndex = initialValue.indexOf(93);
            if (endingIndex != -1) {
                String bounds = initialValue.substring(startingIndex + 1, endingIndex).trim();
                int rangeIndex = bounds.indexOf("..");
                if (rangeIndex == -1) {
                    if ("".equals(bounds)) {
                        return new int[0];
                    }
                    int[] result = new int[]{"?".equals(bounds) ? -3 : ("+".equals(bounds) ? -2 : ("*".equals(bounds) ? -1 : Integer.valueOf(bounds)))};
                    return result;
                }
                String lowerBound = bounds.substring(0, rangeIndex).trim();
                String upperBound = bounds.substring(rangeIndex + 2).trim();
                int[] result = new int[]{Integer.valueOf(lowerBound), "?".equals(upperBound) ? -2 : ("*".equals(upperBound) ? -1 : Integer.valueOf(upperBound))};
                return result;
            }
            throw new RuntimeException("Expecting a final ']'");
        }
        throw new RuntimeException("Expecting an initial '['");
    }

    public String convertXMultiplicityToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        int[] multiplicity = (int[])instanceValue;
        if (multiplicity.length == 0) {
            return "[]";
        }
        if (multiplicity.length == 1) {
            if (multiplicity[0] == -3) {
                return "[?]";
            }
            if (multiplicity[0] == -2) {
                return "[+]";
            }
            if (multiplicity[0] == -1) {
                return "[*]";
            }
            return "[" + multiplicity[0] + "]";
        }
        if (multiplicity[1] == -1) {
            return "[" + multiplicity[0] + "..*]";
        }
        if (multiplicity[1] == -2) {
            return "[" + multiplicity[0] + "..?]";
        }
        return "[" + multiplicity[0] + ".." + multiplicity[1] + "]";
    }

    @Override
    public XcorePackage getXcorePackage() {
        return (XcorePackage)this.getEPackage();
    }

    @Deprecated
    public static XcorePackage getPackage() {
        return XcorePackage.eINSTANCE;
    }
}

