/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.scoping;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xcore.XImportDirective;
import org.eclipse.emf.ecore.xcore.XPackage;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.imports.DefaultImportsConfiguration;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;
import org.eclipse.xtext.xtype.XtypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XcoreImportsConfiguration
extends DefaultImportsConfiguration {
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private IResourceScopeCache cache;

    public XImportSection getImportSection(final XtextResource resource) {
        return (XImportSection)this.cache.get((Object)"synthetic.import.section", (Resource)resource, (Provider)new Provider<XImportSection>(){

            public XImportSection get() {
                XImportSection importSection = XtypeFactory.eINSTANCE.createXImportSection();
                EList importDeclarations = importSection.getImportDeclarations();
                XPackage xPackage = (XPackage)resource.getContents().get(0);
                EList<XImportDirective> importDirectives = xPackage.getImportDirectives();
                for (XImportDirective importDirective : importDirectives) {
                    JvmDeclaredType importedType = null;
                    String importedNamespace = importDirective.getImportedNamespace();
                    boolean isWildcard = importedNamespace.endsWith(".*");
                    if (!isWildcard) {
                        EObject primaryJvmElement;
                        EObject importedObject = importDirective.getImportedObject();
                        if (importedObject instanceof JvmDeclaredType) {
                            importedType = (JvmDeclaredType)importedObject;
                        } else if (importedObject != null && (primaryJvmElement = XcoreImportsConfiguration.this.associations.getPrimaryJvmElement(importedObject)) instanceof JvmDeclaredType) {
                            importedType = (JvmDeclaredType)primaryJvmElement;
                        }
                    }
                    if (!isWildcard && importedType == null) continue;
                    XImportDeclaration importDeclaration = XtypeFactory.eINSTANCE.createXImportDeclaration();
                    importDeclaration.setImportedType(importedType);
                    importDeclaration.setImportedNamespace(importedNamespace);
                    importDeclaration.setExtension(false);
                    importDeclaration.setStatic(false);
                    importDeclarations.add((Object)importDeclaration);
                }
                return importSection;
            }
        });
    }

    public Iterable<JvmDeclaredType> getLocallyDefinedTypes(XtextResource resource) {
        EList contents = resource.getContents();
        String packageName = this.getPackageName(resource);
        ArrayList knownTypes = Lists.newArrayListWithExpectedSize((int)(contents.size() / 2));
        for (JvmDeclaredType content : Iterables.filter((Iterable)contents, JvmDeclaredType.class)) {
            if (!Strings.equal((String)packageName, (String)content.getPackageName())) continue;
            knownTypes.add(content);
        }
        return knownTypes;
    }

    public String getPackageName(XtextResource resource) {
        XPackage xPackage = (XPackage)resource.getContents().get(0);
        return xPackage.getName();
    }

    public int getImportSectionOffset(XtextResource resource) {
        return 0;
    }
}

