/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.scoping.types;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.xcore.scoping.types.AbstractXcoreScope;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingTypeScope
extends AbstractXcoreScope {
    private final AbstractXcoreScope parent;
    private final Map<QualifiedName, IEObjectDescription> cache;

    public CachingTypeScope(AbstractXcoreScope parent) {
        this.parent = parent;
        this.cache = Maps.newHashMapWithExpectedSize((int)50);
    }

    @Override
    public IEObjectDescription getSingleElement(QualifiedName name) {
        IEObjectDescription cached = this.cache.get(name);
        if (cached == null) {
            if (this.cache.containsKey(name)) {
                return null;
            }
            cached = this.parent.getSingleElement(name);
            this.cache.put(name, cached);
        }
        return cached;
    }

    @Override
    public Iterable<IEObjectDescription> getElements(QualifiedName name) {
        IEObjectDescription element = this.getSingleElement(name);
        return element == null ? Collections.emptyList() : Collections.singletonList(element);
    }

    @Override
    protected void doGetElements(JvmType type, List<IEObjectDescription> result) {
        this.parent.doGetElements(type, result);
    }
}

