/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenModelAutoReload
implements ModelChangeTrigger {
    private TransactionalEditingDomain domain;
    public static final NotificationFilter IS_TOUCH = new NotificationFilter.Custom(){

        public boolean matches(Notification input) {
            return input.isTouch();
        }
    };
    public static final NotificationFilter IS_ECORE = new NotificationFilter.Custom(){

        public boolean matches(Notification input) {
            return input.getNotifier() instanceof EObject && ((EObject)input.getNotifier()).eClass().getEPackage() == EcorePackage.eINSTANCE;
        }
    };
    public static final NotificationFilter IS_ATTACHMENT = new NotificationFilter.Custom(){

        public boolean matches(Notification input) {
            return input.getFeature() instanceof EReference && ((EReference)input.getFeature()).isContainment();
        }
    };
    public static final NotificationFilter IS_EREFENCE_CONTAINMENT = new NotificationFilter.Custom(){

        public boolean matches(Notification input) {
            return input.getFeature() == EcorePackage.eINSTANCE.getEReference_Containment();
        }
    };
    public static final NotificationFilter SHOULD_RELOAD = IS_TOUCH.negated().and(IS_ECORE.and(IS_ATTACHMENT));
    public static final int PRIORITY = 0;

    public GenModelAutoReload(TransactionalEditingDomain set) {
        this.domain = set;
    }

    public Option<Command> localChangesAboutToCommit(Collection<Notification> notifications) {
        final ArrayList genModels = Lists.newArrayList();
        for (Resource res : this.domain.getResourceSet().getResources()) {
            for (EObject root : res.getContents()) {
                if (!(root instanceof GenModel)) continue;
                genModels.add((GenModel)root);
            }
        }
        if (genModels.size() > 0) {
            RecordingCommand result = new RecordingCommand(this.domain){

                protected void doExecute() {
                    for (GenModel genmodel : genModels) {
                        genmodel.reconcile();
                    }
                }
            };
            return Options.newSome((Object)result);
        }
        return Options.newNone();
    }

    public int priority() {
        return 0;
    }
}

