/*******************************************************************************
 * Copyright (c) 2012 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - Bug 374758 - [Table] repair the table
 *    Gregoire Dupe (Mia-Software) - Bug 372626 - Aggregates
 *    Thomas Cicognani (Soft-Maint) - Bug 420192 - UnsupportedOperationException in a usefull method 
 *******************************************************************************/
package org.eclipse.emf.facet.custom.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;

/** Represents a list of {@link Customization}s that exists as a subset of a delegate list of {@link FacetSet}s. */
public class CustomizationsDelegatingList implements List<Customization> {
	private final List<FacetSet> delegate;

	public CustomizationsDelegatingList(final List<FacetSet> delegate) {
		this.delegate = delegate;
	}

	private List<Customization> createSubList() {
		final List<Customization> customizations = new ArrayList<Customization>(this.delegate.size());
		for (FacetSet facetSet : this.delegate) {
			if (facetSet instanceof Customization) {
				final Customization customization = (Customization) facetSet;
				customizations.add(customization);
			}
		}
		return customizations;
	}

	public int size() {
		return this.createSubList().size();
	}

	public boolean isEmpty() {
		return this.createSubList().isEmpty();
	}

	public boolean contains(final Object element) {
		return element instanceof Customization && this.delegate.contains(element);
	}

	public Iterator<Customization> iterator() {
		final List<Customization> customizations = createSubList();
		return customizations.iterator();
	}


	public Object[] toArray() {
		return createSubList().toArray();
	}

	public <T> T[] toArray(final T[] a) {
		return createSubList().toArray(a);
	}

	public boolean add(final Customization customization) {
		return this.delegate.add(customization);
	}

	public boolean remove(final Object element) {
		return this.delegate.remove(element);
	}

	public boolean containsAll(final Collection<?> collection) {
		return createSubList().containsAll(collection);
	}

	public boolean addAll(final Collection<? extends Customization> collection) {
		return this.delegate.addAll(collection);
	}

	public boolean addAll(final int index, final Collection<? extends Customization> collection) {
		return this.delegate.addAll(collection);
	}

	public boolean removeAll(final Collection<?> collection) {
		return this.delegate.removeAll(collection);
	}

	public boolean retainAll(final Collection<?> collection) {
		return createSubList().retainAll(collection);
	}

	public void clear() {
		final ListIterator<FacetSet> listIterator = this.delegate.listIterator();
		while (listIterator.hasNext()) {
			final FacetSet facetSet = listIterator.next();
			if (facetSet instanceof Customization) {
				listIterator.remove();
			}
		}
	}

	public Customization get(final int index) {
		// FIXME implement
		throw new UnsupportedOperationException("not implemented"); //$NON-NLS-1$
	}

	public Customization set(final int index, final Customization element) {
		// FIXME implement
		throw new UnsupportedOperationException("not implemented"); //$NON-NLS-1$
	}

	public void add(final int index, final Customization element) {
		if (index == 0) {
			this.delegate.add(0, element);
		} else {
			// FIXME implement
			throw new UnsupportedOperationException("not implemented"); //$NON-NLS-1$
		}
	}

	public Customization remove(final int index) {
		// FIXME implement
		throw new UnsupportedOperationException("not implemented"); //$NON-NLS-1$
	}

	public int indexOf(final Object element) {
		// FIXME implement
		throw new UnsupportedOperationException("not implemented"); //$NON-NLS-1$
	}

	public int lastIndexOf(final Object element) {
		// FIXME implement
		throw new UnsupportedOperationException("not implemented"); //$NON-NLS-1$
	}

	public ListIterator<Customization> listIterator() {
		return this.createSubList().listIterator();
	}

	public ListIterator<Customization> listIterator(final int index) {
		// FIXME implement
		throw new UnsupportedOperationException("not implemented"); //$NON-NLS-1$
	}

	public List<Customization> subList(final int fromIndex, final int toIndex) {
		// FIXME implement
		throw new UnsupportedOperationException("not implemented"); //$NON-NLS-1$
	}
}
