/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.common.ui.internal.util;

import java.net.URL;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.infra.common.ui.internal.EmfFacetCommonUIPlugin;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class ImageProvider {
    private static final String MODISCO_LOGO = "icons/logoMoDiscoMini.gif";
    protected static final String CATALOG_ICON_URL = "/icons/catalog.png";
    private static ImageProvider instance = new ImageProvider();
    private Image emffacetLogo;
    private Image catalog = null;

    public static ImageProvider getInstance() {
        return instance;
    }

    private ImageDescriptor createImageDescriptor(String resourcePath) {
        URL url = EmfFacetCommonUIPlugin.getDefault().getBundle().getResource(resourcePath);
        if (url == null) {
            Logger.logError((String)("resource not found: " + resourcePath), (Plugin)EmfFacetCommonUIPlugin.getDefault());
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return ImageDescriptor.createFromURL((URL)url);
    }

    public Image getEmfFacetLogo() {
        if (this.emffacetLogo == null) {
            this.emffacetLogo = this.createImageDescriptor(MODISCO_LOGO).createImage();
        }
        return this.emffacetLogo;
    }

    public ImageDescriptor getEmfFacetLogoDescriptor() {
        return this.createImageDescriptor(MODISCO_LOGO);
    }

    public Image getCatalogIcon() {
        if (this.catalog == null) {
            this.catalog = this.createImageDescriptor(CATALOG_ICON_URL).createImage();
        }
        return this.catalog;
    }
}

