/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.facet.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetPackage;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.core.FacetSetCatalog;
import org.eclipse.emf.facet.infra.facet.ui.Activator;
import org.eclipse.emf.facet.infra.facet.ui.dialogs.LoadFacetsDialog;
import org.eclipse.emf.facet.infra.facet.ui.views.FacetSetContentProvider;
import org.eclipse.emf.facet.util.emf.ui.internal.utils.ImageUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class AbstractLoadFacetsAction
extends Action {
    private static final String ICON_FACET = "icons/Facet.gif";
    private final LabelProvider labelProvider = new LabelProvider(){

        public String getText(Object element) {
            String label;
            if (element instanceof FacetSet) {
                FacetSet facetSet = (FacetSet)element;
                label = facetSet.getName();
            } else if (element instanceof Facet) {
                Facet facet = (Facet)element;
                label = facet.getName();
            } else {
                label = element == null ? "null" : element.getClass().getName();
            }
            return label;
        }

        public Image getImage(Object element) {
            return ImageUtils.getImage((Object)element);
        }
    };

    public AbstractLoadFacetsAction() {
        super("Load Facets", 1);
        this.setToolTipText("Load Facets");
        this.setImageDescriptor(Activator.createImageDescriptor(ICON_FACET));
    }

    public void run() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                FacetSetCatalog.getSingleton().waitUntilBuilt();
            }
        });
        this.openDialog();
    }

    protected void openDialog() {
        FacetSetContentProvider treeContentProvider = new FacetSetContentProvider(FacetPackage.eINSTANCE.getFacet());
        LoadFacetsDialog dialog = new LoadFacetsDialog(null, (ILabelProvider)this.labelProvider, treeContentProvider, this.getReferencedEPackages());
        dialog.setContainerMode(true);
        dialog.setHelpAvailable(false);
        dialog.setTitle("Load Facets");
        dialog.setMessage("Choose Facets to Load");
        Collection facetSets = FacetSetCatalog.getSingleton().getAllFacetSets();
        dialog.setInput(facetSets.toArray());
        dialog.setInitialElementSelections(new ArrayList<Facet>(this.getLoadedFacets()));
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            this.clearFacets();
            final HashSet<Facet> facetsToLoad = new HashSet<Facet>();
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object resultElement = objectArray[n2];
                if (resultElement instanceof Facet) {
                    Facet facet = (Facet)resultElement;
                    facetsToLoad.add(facet);
                } else if (!(resultElement instanceof FacetSet)) {
                    throw new RuntimeException("Unexpected element type");
                }
                ++n2;
            }
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                public void run() {
                    for (Facet facetToLoad : facetsToLoad) {
                        AbstractLoadFacetsAction.this.loadFacet(facetToLoad);
                    }
                    AbstractLoadFacetsAction.this.facetsLoaded(facetsToLoad);
                }
            });
        }
    }

    protected void facetsLoaded(Collection<Facet> facets) {
    }

    protected abstract void loadFacet(Facet var1);

    protected abstract void clearFacets();

    protected abstract Collection<? extends Facet> getLoadedFacets();

    protected abstract Collection<EPackage> getReferencedEPackages();
}

