/**
 * Copyright (c) 2010 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Nicolas Guyomar (Mia-Software) - Bug 332924 - To be able to save the table - initial API and implementation
 *    Nicolas Guyomar (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 333015 - To be able to hide columns
 *    Gregoire Dupe (Mia-Software) - Bug 333029 - To be able to save the size of the lines and the columns
 */
package org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.AttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ContextColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.DefaultLabelColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.EContainerColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.MetaClassColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryTableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstanceFactory;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Factory</b>. <!--
 * end-user-doc -->
 * 
 * @generated
 * @deprecated https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public class TableinstanceFactoryImpl extends EFactoryImpl implements TableinstanceFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TableinstanceFactory init() {
		try {
			TableinstanceFactory theTableinstanceFactory = (TableinstanceFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/EMF_Facet/ModelCellEditor/0.1.0/tableinstance"); //$NON-NLS-1$ 
			if (theTableinstanceFactory != null) {
				return theTableinstanceFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new TableinstanceFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TableinstanceFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(final EClass eClass) {
		switch (eClass.getClassifierID()) {
			case TableinstancePackage.TABLE_INSTANCE: return createTableInstance();
			case TableinstancePackage.QUERY_TABLE_INSTANCE: return createQueryTableInstance();
			case TableinstancePackage.QUERY_COLUMN: return createQueryColumn();
			case TableinstancePackage.REFERENCE_COLUMN: return createReferenceColumn();
			case TableinstancePackage.CONTEXT_COLUMN: return createContextColumn();
			case TableinstancePackage.META_CLASS_COLUMN: return createMetaClassColumn();
			case TableinstancePackage.ATTRIBUTE_COLUMN: return createAttributeColumn();
			case TableinstancePackage.ECONTAINER_COLUMN: return createEContainerColumn();
			case TableinstancePackage.DEFAULT_LABEL_COLUMN: return createDefaultLabelColumn();
			case TableinstancePackage.ROW: return createRow();
			case TableinstancePackage.FACET_ATTRIBUTE_COLUMN: return createFacetAttributeColumn();
			case TableinstancePackage.FACET_REFERENCE_COLUMN: return createFacetReferenceColumn();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier"); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TableInstance createTableInstance() {
		TableInstanceImpl tableInstance = new TableInstanceImpl();
		return tableInstance;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public QueryTableInstance createQueryTableInstance() {
		QueryTableInstanceImpl queryTableInstance = new QueryTableInstanceImpl();
		return queryTableInstance;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public QueryColumn createQueryColumn() {
		QueryColumnImpl queryColumn = new QueryColumnImpl();
		return queryColumn;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ReferenceColumn createReferenceColumn() {
		ReferenceColumnImpl referenceColumn = new ReferenceColumnImpl();
		return referenceColumn;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ContextColumn createContextColumn() {
		ContextColumnImpl contextColumn = new ContextColumnImpl();
		return contextColumn;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MetaClassColumn createMetaClassColumn() {
		MetaClassColumnImpl metaClassColumn = new MetaClassColumnImpl();
		return metaClassColumn;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AttributeColumn createAttributeColumn() {
		AttributeColumnImpl attributeColumn = new AttributeColumnImpl();
		return attributeColumn;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EContainerColumn createEContainerColumn() {
		EContainerColumnImpl eContainerColumn = new EContainerColumnImpl();
		return eContainerColumn;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DefaultLabelColumn createDefaultLabelColumn() {
		DefaultLabelColumnImpl defaultLabelColumn = new DefaultLabelColumnImpl();
		return defaultLabelColumn;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Row createRow() {
		RowImpl row = new RowImpl();
		return row;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FacetAttributeColumn createFacetAttributeColumn() {
		FacetAttributeColumnImpl facetAttributeColumn = new FacetAttributeColumnImpl();
		return facetAttributeColumn;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public FacetReferenceColumn createFacetReferenceColumn() {
		FacetReferenceColumnImpl facetReferenceColumn = new FacetReferenceColumnImpl();
		return facetReferenceColumn;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TableinstancePackage getTableinstancePackage() {
		return (TableinstancePackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static TableinstancePackage getPackage() {
		return TableinstancePackage.eINSTANCE;
	}

} //TableinstanceFactoryImpl
