/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.context;

import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gyrex.admin.ui.context.internal.ContextUiActivator;
import org.eclipse.gyrex.context.definitions.ContextDefinition;
import org.eclipse.gyrex.context.definitions.IRuntimeContextDefinitionManager;
import org.eclipse.jface.viewers.TreeNode;

public class RuntimeContextTree {
    private static TreeNode findParent(TreeNode parent, TreeNode next) {
        if (!RuntimeContextTree.getPath(parent).isPrefixOf(RuntimeContextTree.getPath(next))) {
            return null;
        }
        TreeNode[] children = parent.getChildren();
        if (children == null) {
            parent.setChildren(new TreeNode[]{next});
            return parent;
        }
        TreeNode[] treeNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            TreeNode child = treeNodeArray[n2];
            TreeNode result = RuntimeContextTree.findParent(child, next);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        TreeNode[] newChildren = new TreeNode[children.length + 1];
        System.arraycopy(children, 0, newChildren, 0, children.length);
        newChildren[children.length] = next;
        parent.setChildren(newChildren);
        return parent;
    }

    private static IPath getPath(TreeNode node) {
        return ((ContextDefinition)node.getValue()).getPath();
    }

    public static TreeNode[] getTree() {
        IRuntimeContextDefinitionManager registry = (IRuntimeContextDefinitionManager)ContextUiActivator.getInstance().getService(IRuntimeContextDefinitionManager.class);
        TreeMap<IPath, TreeNode> nodes = new TreeMap<IPath, TreeNode>(new Comparator<IPath>(){

            @Override
            public int compare(IPath o1, IPath o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        for (ContextDefinition contextDefinition : registry.getDefinedContexts()) {
            nodes.put(contextDefinition.getPath(), new TreeNode((Object)contextDefinition));
        }
        if (!((IPath)nodes.firstKey()).isRoot()) {
            throw new IllegalStateException("sort error");
        }
        TreeNode root = (TreeNode)nodes.remove(nodes.firstKey());
        Iterator stream = nodes.values().iterator();
        while (stream.hasNext()) {
            TreeNode next = (TreeNode)stream.next();
            stream.remove();
            TreeNode parent = RuntimeContextTree.findParent(root, next);
            if (parent != null) continue;
            throw new IllegalStateException("build tree error");
        }
        return new TreeNode[]{root};
    }
}

