/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.http.internal;

import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.admin.ui.http.internal.ApplicationGroup;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationProviderRegistration;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationRegistration;

public class ApplicationItem {
    private final Set<String> mounts;
    private final ApplicationRegistration applicationRegistration;
    private final ApplicationProviderRegistration applicationProviderRegistration;
    private ApplicationGroup parent;
    private boolean active;

    public ApplicationItem(ApplicationRegistration applicationRegistration, ApplicationProviderRegistration applicationProviderRegistration, boolean active, Set<String> mounts) {
        this.applicationRegistration = applicationRegistration;
        this.applicationProviderRegistration = applicationProviderRegistration;
        this.active = active;
        this.mounts = mounts;
    }

    public String getApplicationId() {
        return this.applicationRegistration.getApplicationId();
    }

    public ApplicationProviderRegistration getApplicationProviderRegistration() {
        return this.applicationProviderRegistration;
    }

    public ApplicationRegistration getApplicationRegistration() {
        return this.applicationRegistration;
    }

    public String getContextPath() {
        return this.applicationRegistration.getContext().getContextPath().toString();
    }

    public Set<String> getMounts() {
        return this.mounts;
    }

    public ApplicationGroup getParent() {
        return this.parent;
    }

    public String getProviderId() {
        return this.applicationRegistration.getProviderId();
    }

    public String getProviderLabel() {
        String providerInfo = this.applicationProviderRegistration.getProviderInfo();
        if (StringUtils.isNotBlank((String)providerInfo)) {
            return providerInfo;
        }
        return this.applicationRegistration.getProviderId();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setParent(ApplicationGroup parent) {
        this.parent = parent;
    }
}

