/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.http.internal;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingStatusDialog;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.Separator;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class MountApplicationDialog
extends NonBlockingStatusDialog {
    private static final long serialVersionUID = 1L;
    private final StringDialogField urlField = new StringDialogField();
    private URL url;

    public MountApplicationDialog(Shell parent) {
        super(parent);
        this.setTitle("New Mount");
        this.setShellStyle(67696);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)composite.getLayoutData();
        gd.minimumHeight = this.convertVerticalDLUsToPixels(60);
        gd.minimumWidth = this.convertHorizontalDLUsToPixels(400);
        this.urlField.setLabelText("URL");
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                MountApplicationDialog.this.validate();
            }
        };
        this.urlField.setDialogFieldListener(validateListener);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{new Separator(), this.urlField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.urlField.getTextControl(null));
        this.urlField.setFocus();
        return composite;
    }

    public URL getUrl() {
        return this.url;
    }

    protected void okPressed() {
        this.validate();
        if (!this.getStatus().isOK()) {
            return;
        }
        super.okPressed();
    }

    void setError(String message) {
        this.updateStatus((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.http", message));
        this.getShell().pack(true);
    }

    void setInfo(String message) {
        this.updateStatus((IStatus)new Status(1, "org.eclipse.gyrex.admin.ui.http", message));
    }

    void setWarning(String message) {
        this.updateStatus((IStatus)new Status(2, "org.eclipse.gyrex.admin.ui.http", message));
    }

    void validate() {
        this.url = null;
        String urlStr = this.urlField.getText();
        if (StringUtils.isBlank((String)urlStr)) {
            this.setInfo("Please enter an url.");
            return;
        }
        try {
            this.url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            this.setError(String.format("The entered url is invalid. %s", e.getMessage()));
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }
}

