/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.gyrex.cloud.services.queue.IMessage;
import org.eclipse.gyrex.cloud.services.queue.IQueue;
import org.eclipse.gyrex.jobs.internal.worker.JobInfo;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class JobQueueContentProvider
implements ITreeContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private static final long serialVersionUID = 1L;

    public void dispose() {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IQueue) {
            IQueue queue = (IQueue)parentElement;
            HashMap<String, Long> properties = new HashMap<String, Long>(2);
            properties.put("queue.message.receive.timeout", new Long(0L));
            List message = queue.receiveMessages(500, properties);
            if (message.isEmpty()) {
                return NO_CHILDREN;
            }
            ArrayList<Object> result = new ArrayList<Object>(message.size());
            for (IMessage m : message) {
                try {
                    result.add(JobInfo.parse((IMessage)m));
                }
                catch (AssertionError | Exception | LinkageError e) {
                    result.add(String.format("Unparsable message (%s). %s", m, ExceptionUtils.getRootCauseMessage((Throwable)e)));
                }
            }
            return result.toArray();
        }
        if (parentElement instanceof Collection) {
            return ((Collection)parentElement).toArray();
        }
        if (parentElement instanceof Object[]) {
            return (Object[])parentElement;
        }
        return NO_CHILDREN;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IQueue) {
            IQueue queue = (IQueue)element;
            HashMap<String, Long> properties = new HashMap<String, Long>(2);
            properties.put("queue.message.receive.timeout", new Long(0L));
            List message = queue.receiveMessages(1, properties);
            return !message.isEmpty();
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

