/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal.externalprocess;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingStatusDialog;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AddEditArgumentDialog
extends NonBlockingStatusDialog {
    private static final long serialVersionUID = 1L;
    private final StringDialogField valueField = new StringDialogField();

    public AddEditArgumentDialog(Shell parent) {
        this(parent, null);
    }

    public AddEditArgumentDialog(Shell parent, String value) {
        super(parent);
        this.setTitle(value != null ? "Edit Argument" : "New Argument");
        this.setShellStyle(67696);
        this.valueField.setText(StringUtils.trimToEmpty((String)value));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)composite.getLayoutData();
        gd.minimumHeight = this.convertVerticalDLUsToPixels(40);
        gd.minimumWidth = this.convertHorizontalDLUsToPixels(300);
        this.valueField.setLabelText("Argument:");
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddEditArgumentDialog.this.validate();
            }
        };
        this.valueField.setDialogFieldListener(validateListener);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.valueField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.valueField.getTextControl(null));
        LayoutUtil.setMargin((Composite)composite, (int)5);
        return composite;
    }

    public String getValue() {
        return this.valueField.getText();
    }

    protected void okPressed() {
        this.validate();
        if (!this.getStatus().isOK()) {
            return;
        }
        super.okPressed();
    }

    public void openNonBlocking(DialogCallback callback) {
        super.openNonBlocking(callback);
        this.valueField.getTextControl(null).setSelection(0);
        this.valueField.setFocus();
    }

    void setError(String message) {
        this.updateStatus((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.jobs", message));
        this.getShell().pack(true);
    }

    void setInfo(String message) {
        this.updateStatus((IStatus)new Status(1, "org.eclipse.gyrex.admin.ui.jobs", message));
    }

    void setWarning(String message) {
        this.updateStatus((IStatus)new Status(2, "org.eclipse.gyrex.admin.ui.jobs", message));
    }

    void validate() {
        if (StringUtils.isBlank((String)this.getValue())) {
            this.setInfo("Please enter an argument.");
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }
}

