/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal.externalprocess;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingStatusDialog;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AddEditEnvironmentVariableDialog
extends NonBlockingStatusDialog {
    private static final long serialVersionUID = 1L;
    private final StringDialogField nameField = new StringDialogField();
    private final StringDialogField valueField = new StringDialogField();
    private final boolean isEdit;

    public AddEditEnvironmentVariableDialog(Shell parent) {
        this(parent, null, null);
    }

    public AddEditEnvironmentVariableDialog(Shell parent, String name, String value) {
        super(parent);
        this.isEdit = name != null;
        this.setTitle(this.isEdit ? "Edit Variable" : "New Variable");
        this.setShellStyle(67696);
        this.nameField.setText(StringUtils.trimToEmpty((String)name));
        this.valueField.setText(StringUtils.trimToEmpty((String)value));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)composite.getLayoutData();
        gd.minimumHeight = this.convertVerticalDLUsToPixels(40);
        gd.minimumWidth = this.convertHorizontalDLUsToPixels(200);
        this.nameField.setLabelText("Name:");
        this.valueField.setLabelText("Value:");
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddEditEnvironmentVariableDialog.this.validate();
            }
        };
        this.nameField.setDialogFieldListener(validateListener);
        this.valueField.setDialogFieldListener(validateListener);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.nameField, this.valueField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.nameField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.valueField.getTextControl(null));
        LayoutUtil.setMargin((Composite)composite, (int)5);
        return composite;
    }

    public String getName() {
        return this.nameField.getText();
    }

    public String getValue() {
        return this.valueField.getText();
    }

    protected void okPressed() {
        this.validate();
        if (!this.getStatus().isOK()) {
            return;
        }
        super.okPressed();
    }

    public void openNonBlocking(DialogCallback callback) {
        super.openNonBlocking(callback);
        if (this.isEdit) {
            this.valueField.getTextControl(null).setSelection(0);
            this.valueField.setFocus();
        } else {
            this.nameField.setFocus();
        }
    }

    void setError(String message) {
        this.updateStatus((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.jobs", message));
        this.getShell().pack(true);
    }

    void setInfo(String message) {
        this.updateStatus((IStatus)new Status(1, "org.eclipse.gyrex.admin.ui.jobs", message));
    }

    void setWarning(String message) {
        this.updateStatus((IStatus)new Status(2, "org.eclipse.gyrex.admin.ui.jobs", message));
    }

    void validate() {
        if (StringUtils.isBlank((String)this.getName())) {
            this.setInfo("Please enter a name.");
            return;
        }
        if (StringUtils.isBlank((String)this.getValue())) {
            this.setInfo("Please enter a value.");
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }
}

