/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal.generic;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingStatusDialog;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.admin.ui.jobs.internal.generic.Parameter;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class AddEditParameterDialog
extends NonBlockingStatusDialog {
    private static final long serialVersionUID = 1L;
    private final StringDialogField nameField = new StringDialogField();
    private final StringDialogField valueField = new StringDialogField();
    private final List<Object> parameters;
    private final Parameter parameterToEdit;

    public AddEditParameterDialog(Shell parent) {
        this(parent, null, null);
    }

    public AddEditParameterDialog(Shell parent, Parameter parameter, List<Object> parameters) {
        super(parent);
        this.parameterToEdit = parameter;
        this.parameters = parameters;
        this.setShellStyle(67696);
        if (this.parameterToEdit != null) {
            this.setTitle("Edit Parameter");
            this.nameField.setText(StringUtils.trimToEmpty((String)parameter.getName()));
            this.valueField.setText(StringUtils.trimToEmpty((String)parameter.getValue()));
        } else {
            this.setTitle("New Parameter");
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)composite.getLayoutData();
        gd.minimumHeight = this.convertVerticalDLUsToPixels(40);
        gd.minimumWidth = this.convertHorizontalDLUsToPixels(200);
        this.nameField.setLabelText("Name:");
        this.valueField.setLabelText("Value:");
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddEditParameterDialog.this.validate();
            }
        };
        this.nameField.setDialogFieldListener(validateListener);
        this.valueField.setDialogFieldListener(validateListener);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.nameField, this.valueField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.nameField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.valueField.getTextControl(null));
        LayoutUtil.setMargin((Composite)composite, (int)5);
        return composite;
    }

    public String getName() {
        return this.nameField.getText();
    }

    public String getValue() {
        return this.valueField.getText();
    }

    protected void okPressed() {
        this.validate();
        if (!this.getStatus().isOK()) {
            return;
        }
        super.okPressed();
    }

    public void openNonBlocking(DialogCallback callback) {
        super.openNonBlocking(callback);
        if (this.parameterToEdit != null) {
            this.valueField.getTextControl(null).setSelection(0);
            this.valueField.setFocus();
        } else {
            this.nameField.setFocus();
        }
    }

    void setError(String message) {
        this.updateStatus((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.jobs", message));
        this.getShell().pack(true);
    }

    void setInfo(String message) {
        this.updateStatus((IStatus)new Status(1, "org.eclipse.gyrex.admin.ui.jobs", message));
    }

    void setWarning(String message) {
        this.updateStatus((IStatus)new Status(2, "org.eclipse.gyrex.admin.ui.jobs", message));
    }

    void validate() {
        if (StringUtils.isBlank((String)this.getName())) {
            this.setInfo("Please enter a name.");
            return;
        }
        if (StringUtils.isBlank((String)this.getValue())) {
            this.setInfo("Please enter a value.");
            return;
        }
        if (this.parameters != null) {
            for (Object parameter : this.parameters) {
                if (parameter == this.parameterToEdit || !StringUtils.equals((String)((Parameter)parameter).getName(), (String)this.getName())) continue;
                this.setError("A parameter with the specified name already exists. Please use a different name.");
                return;
            }
        }
        this.updateStatus(Status.OK_STATUS);
    }
}

