/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.helper;

import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiUtil {
    private static final Logger LOG = LoggerFactory.getLogger(UiUtil.class);
    private static final char[] VALUE_HELP_ACTIVATIONCHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123457890*@ <>".toCharArray();

    public static void addBulbDecorator(Control control, String tooltip) {
        ControlDecoration dec = new ControlDecoration(control, 16512);
        dec.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        dec.setShowOnlyOnFocus(true);
        dec.setShowHover(true);
        dec.setDescriptionText(tooltip);
    }

    public static ContentProposalAdapter addContentProposalBehavior(Text textField, IContentProposalProvider processor) {
        String tooltip;
        KeyStroke stroke;
        try {
            stroke = KeyStroke.getInstance((String)"M1+SPACE");
            tooltip = String.format("Press %s or begin typing to see a filtered list of previously used values", stroke.format());
        }
        catch (ParseException e1) {
            LOG.error("Error constructing key binding.", (Throwable)e1);
            stroke = null;
            tooltip = "Start typing to see a filtered list of previously used values";
        }
        return UiUtil.addContentProposalBehavior(textField, processor, stroke, tooltip);
    }

    public static ContentProposalAdapter addContentProposalBehavior(Text textField, IContentProposalProvider processor, KeyStroke stroke, String tooltip) {
        if (tooltip != null) {
            UiUtil.addBulbDecorator((Control)textField, tooltip);
        }
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)textField, (IControlContentAdapter)new TextContentAdapter(), processor, stroke, VALUE_HELP_ACTIVATIONCHARS);
        adapter.setProposalAcceptanceStyle(2);
        return adapter;
    }
}

