/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.widgets;

import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gyrex.admin.ui.internal.widgets.SelectionDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class SelectionStatusDialog
extends SelectionDialog {
    private static final long serialVersionUID = 1L;
    private MessageLine fStatusLine;
    private IStatus fLastStatus;
    private Image fImage;
    private boolean fStatusLineAboveButtons = false;

    public SelectionStatusDialog(Shell parent) {
        super(parent);
    }

    protected abstract void computeResult();

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fImage != null) {
            shell.setImage(this.fImage);
        }
    }

    public void create() {
        super.create();
        if (this.fLastStatus != null) {
            this.updateStatus(this.fLastStatus);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        if (!this.fStatusLineAboveButtons) {
            layout.numColumns = 2;
        }
        layout.marginHeight = 0;
        layout.marginLeft = this.convertHorizontalDLUsToPixels(7);
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        if (!this.fStatusLineAboveButtons && this.isHelpAvailable()) {
            this.createHelpControl(composite);
        }
        this.fStatusLine = new MessageLine(composite);
        this.fStatusLine.setAlignment(16384);
        GridData statusData = new GridData(768);
        this.fStatusLine.setErrorStatus(null);
        this.fStatusLine.setFont(font);
        if (this.fStatusLineAboveButtons && this.isHelpAvailable()) {
            statusData.horizontalSpan = 2;
            this.createHelpControl(composite);
        }
        this.fStatusLine.setLayoutData(statusData);
        boolean helpAvailable = this.isHelpAvailable();
        this.setHelpAvailable(false);
        super.createButtonBar(composite);
        this.setHelpAvailable(helpAvailable);
        return composite;
    }

    public Object getFirstResult() {
        Object[] result = this.getResult();
        if (result == null || result.length == 0) {
            return null;
        }
        return result[0];
    }

    protected void okPressed() {
        this.computeResult();
        super.okPressed();
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    protected void setResult(int position, Object element) {
        Object[] result = this.getResult();
        result[position] = element;
        this.setResult(Arrays.asList(result));
    }

    public void setStatusLineAboveButtons(boolean aboveButtons) {
        this.fStatusLineAboveButtons = aboveButtons;
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button okButton = this.getOkButton();
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(!status.matches(4));
        }
    }

    protected void updateStatus(IStatus status) {
        this.fLastStatus = status;
        if (this.fStatusLine != null && !this.fStatusLine.isDisposed()) {
            this.updateButtonsEnableState(status);
            this.fStatusLine.setErrorStatus(status);
        }
    }

    private class MessageLine
    extends CLabel {
        private static final long serialVersionUID = 1L;
        private final Color fNormalMsgAreaBackground;

        public MessageLine(Composite parent) {
            this(parent, 16384);
        }

        public MessageLine(Composite parent, int style) {
            super(parent, style);
            this.fNormalMsgAreaBackground = this.getBackground();
        }

        private Image findImage(IStatus status) {
            if (status.isOK()) {
                return null;
            }
            if (status.matches(4)) {
                return JFaceResources.getImage((String)"dialog_message_error_image");
            }
            if (status.matches(2)) {
                return JFaceResources.getImage((String)"dialog_messasge_warning_image");
            }
            if (status.matches(1)) {
                return JFaceResources.getImage((String)"dialog_messasge_info_image");
            }
            return null;
        }

        public void setErrorStatus(IStatus status) {
            String message;
            if (status != null && !status.isOK() && (message = status.getMessage()) != null && message.length() > 0) {
                this.setText(message);
                this.setImage(this.findImage(status));
                this.setBackground(JFaceColors.getErrorBackground((Display)this.getDisplay()));
                return;
            }
            this.setText("");
            this.setImage(null);
            this.setBackground(this.fNormalMsgAreaBackground);
        }
    }
}

