/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.registry.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.gyrex.http.registry.ApplicationCustomizer;
import org.eclipse.gyrex.http.registry.internal.ApplicationRegistryManager;
import org.eclipse.gyrex.http.registry.internal.ExtensionPointTracker;
import org.eclipse.gyrex.http.registry.internal.HttpRegistryDebug;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationManager
implements ExtensionPointTracker.Listener {
    private static final String APPLICATIONS_EXTENSION_POINT = "org.eclipse.gyrex.http.applications";
    private static final String APPLICATION = "application";
    private static final String ID = "id";
    private static final String CONTEXT_PATH = "contextPath";
    private static final String CUSTOMIZER_CLASS = "customizerClass";
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationManager.class);
    private final List<IConfigurationElement> registered = new ArrayList<IConfigurationElement>();
    private final ApplicationRegistryManager applicationRegistryManager;
    private final ExtensionPointTracker tracker;

    public static ApplicationCustomizer createCustomizer(IConfigurationElement configurationElement) {
        block3: {
            try {
                if (!StringUtils.isBlank((String)configurationElement.getAttribute(CUSTOMIZER_CLASS))) break block3;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return (ApplicationCustomizer)configurationElement.createExecutableExtension(CUSTOMIZER_CLASS);
    }

    public ApplicationManager(ApplicationRegistryManager applicationRegistryManager, IExtensionRegistry registry) {
        this.applicationRegistryManager = applicationRegistryManager;
        this.tracker = new ExtensionPointTracker(registry, APPLICATIONS_EXTENSION_POINT, this);
    }

    @Override
    public void added(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement applicationElement = elements[i];
            if (APPLICATION.equals(applicationElement.getName())) {
                String applicationId = applicationElement.getAttribute(ID);
                if (applicationId == null) {
                    LOG.warn("Ignoring application extension element contributed by {}. Does not contain an application id.", (Object)applicationElement.getContributor());
                } else {
                    String contextPath;
                    if (applicationId.indexOf(46) == -1) {
                        applicationId = String.valueOf(applicationElement.getNamespaceIdentifier()) + "." + applicationId;
                    }
                    if ((contextPath = applicationElement.getAttribute(CONTEXT_PATH)) == null) {
                        contextPath = "/";
                    }
                    if (HttpRegistryDebug.extensionRegistration) {
                        LOG.debug("Trying to add application {} (contributed by {}).", (Object)applicationId, (Object)applicationElement.getContributor());
                    }
                    if (this.applicationRegistryManager.addApplicationContribution(applicationId, contextPath, applicationElement)) {
                        if (HttpRegistryDebug.extensionRegistration) {
                            LOG.debug("Successfully added application {} (contributed by {}).", (Object)applicationId, (Object)applicationElement.getContributor());
                        }
                        this.registered.add(applicationElement);
                    } else if (HttpRegistryDebug.extensionRegistration) {
                        LOG.debug("Did not add application {} (contributed by {}). ", (Object)applicationId, (Object)applicationElement.getContributor());
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public void removed(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement applicationElement = elements[i];
            if (APPLICATION.equals(applicationElement.getName())) {
                String applicationId = applicationElement.getAttribute(ID);
                if (applicationId == null) {
                    LOG.warn("Ignoring application extension element contributed by {}. Does not contain an application id.", (Object)applicationElement.getContributor());
                } else {
                    if (applicationId.indexOf(46) == -1) {
                        applicationId = String.valueOf(applicationElement.getNamespaceIdentifier()) + "." + applicationId;
                    }
                    if (HttpRegistryDebug.extensionRegistration) {
                        LOG.debug("Trying to remove application {} (contributed by {}).", (Object)applicationId, (Object)applicationElement.getContributor());
                    }
                    if (this.registered.remove(applicationElement)) {
                        if (HttpRegistryDebug.extensionRegistration) {
                            LOG.debug("Successfully removed application {} (contributed by {}).", (Object)applicationId, (Object)applicationElement.getContributor());
                        }
                        this.applicationRegistryManager.removeApplicationContribution(applicationId);
                    } else if (HttpRegistryDebug.extensionRegistration) {
                        LOG.debug("Did not remove application {} (contributed by {}). ", (Object)applicationId, (Object)applicationElement.getContributor());
                    }
                }
            }
            ++i;
        }
    }

    public void start() {
        this.tracker.open();
    }

    public void stop() {
        this.tracker.close();
    }
}

