/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.registry.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.gyrex.http.registry.internal.ApplicationRegistryManager;
import org.eclipse.gyrex.http.registry.internal.ExtensionPointTracker;
import org.eclipse.gyrex.http.registry.internal.HttpRegistryDebug;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MountManager
implements ExtensionPointTracker.Listener {
    private static final String MOUNTS_EXTENSION_POINT = "org.eclipse.gyrex.http.applications";
    private static final String URL = "url";
    private static final String MOUNT = "mount";
    private static final String APPLICATION_ID = "applicationId";
    private static final Logger LOG = LoggerFactory.getLogger(MountManager.class);
    private final ExtensionPointTracker tracker;
    private final List<IConfigurationElement> registered = new ArrayList<IConfigurationElement>();
    private final ApplicationRegistryManager applicationRegistryManager;

    public MountManager(ApplicationRegistryManager httpRegistryManager, ServiceReference reference, IExtensionRegistry registry) {
        this.applicationRegistryManager = httpRegistryManager;
        this.tracker = new ExtensionPointTracker(registry, MOUNTS_EXTENSION_POINT, this);
    }

    @Override
    public void added(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement mountElement = elements[i];
            if (MOUNT.equals(mountElement.getName())) {
                String url = mountElement.getAttribute(URL);
                if (url == null) {
                    LOG.warn("Ignoring mount extension element contributed by {}. Does not contain an alias.", (Object)mountElement.getContributor());
                } else {
                    String applicationId = mountElement.getAttribute(APPLICATION_ID);
                    if (applicationId == null) {
                        LOG.warn("Ignoring mount extension element contributed by {}. Does not contain an application id.", (Object)mountElement.getContributor());
                    } else {
                        if (applicationId.indexOf(46) == -1) {
                            applicationId = String.valueOf(mountElement.getNamespaceIdentifier()) + "." + applicationId;
                        }
                        if (HttpRegistryDebug.extensionRegistration) {
                            LOG.debug("Trying to add mount {} for application {} (contributed by {}).", new Object[]{url, applicationId, mountElement.getContributor()});
                        }
                        if (this.applicationRegistryManager.addMountContribution(url, applicationId, extension.getContributor())) {
                            if (HttpRegistryDebug.extensionRegistration) {
                                LOG.debug("Successfully added mount {} for application {} (contributed by {}).", new Object[]{url, applicationId, mountElement.getContributor()});
                            }
                            this.registered.add(mountElement);
                        } else if (HttpRegistryDebug.extensionRegistration) {
                            LOG.debug("Did not add mount {} for application {} (contributed by {}).", new Object[]{url, applicationId, mountElement.getContributor()});
                        }
                    }
                }
            }
            ++i;
        }
    }

    @Override
    public void removed(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement mountElement = elements[i];
            if (MOUNT.equals(mountElement.getName())) {
                String url = mountElement.getAttribute(URL);
                if (url == null) {
                    LOG.warn("Ignoring mount extension element contributed by {}. Does not contain an alias.", (Object)mountElement.getContributor());
                } else {
                    String applicationId = mountElement.getAttribute(APPLICATION_ID);
                    if (applicationId == null) {
                        LOG.warn("Ignoring mount extension element contributed by {}. Does not contain an application id.", (Object)mountElement.getContributor());
                    } else {
                        if (HttpRegistryDebug.extensionRegistration) {
                            LOG.debug("Trying to remove mount {} for application {} (contributed by {}).", new Object[]{url, applicationId, mountElement.getContributor()});
                        }
                        if (this.registered.remove(mountElement)) {
                            if (HttpRegistryDebug.extensionRegistration) {
                                LOG.debug("Successfully removed mount {} for application {} (contributed by {}).", new Object[]{url, applicationId, mountElement.getContributor()});
                            }
                            this.applicationRegistryManager.removeMountContribution(url, applicationId);
                        } else if (HttpRegistryDebug.extensionRegistration) {
                            LOG.debug("Did not remove mount {} for application {} (contributed by {}).", new Object[]{url, applicationId, mountElement.getContributor()});
                        }
                    }
                }
            }
            ++i;
        }
    }

    public void start() {
        this.tracker.open();
    }

    public void stop() {
        this.tracker.close();
    }
}

