/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.solr.internal;

import java.io.File;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.gyrex.boot.internal.app.ServerApplication;
import org.eclipse.gyrex.persistence.solr.internal.SolrActivator;
import org.eclipse.gyrex.persistence.solr.internal.SolrDebug;
import org.eclipse.gyrex.server.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedSolrServerApplication
implements IApplication {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedSolrServerApplication.class);
    private static final Integer EXIT_ERROR = 1;
    static final AtomicReference<CoreContainer> coreContainerRef = new AtomicReference();
    static volatile File solrBase;
    private IApplicationContext runningContext;

    public Object start(IApplicationContext context) throws Exception {
        if (SolrDebug.embeddedSolrServer) {
            LOG.debug("Starting embedded Solr server.");
        }
        try {
            this.startEmbeddedSolrServer();
            context.applicationRunning();
            this.runningContext = context;
            return IApplicationContext.EXIT_ASYNC_RESULT;
        }
        catch (Exception e) {
            if (Platform.inDevelopmentMode()) {
                ServerApplication.shutdown((Throwable)new Exception("Could not start the embedded Solr server. " + ExceptionUtils.getRootCauseMessage((Throwable)e), e));
            } else {
                LOG.error("Unable to start embedded Solr. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e), (Object)e);
            }
            return EXIT_ERROR;
        }
    }

    private void startEmbeddedSolrServer() throws Exception {
        CoreContainer coreContainer;
        File configFile;
        File configTemplate = new File(FileLocator.toFileURL((URL)SolrActivator.getInstance().getBundle().getEntry("conf-embeddedsolr")).getFile());
        IPath instanceLocation = Platform.getInstanceLocation();
        solrBase = instanceLocation.append("solr").toFile();
        if (!solrBase.isDirectory()) {
            solrBase.mkdirs();
        }
        if (!(configFile = new File(solrBase, "solr.xml")).isFile()) {
            FileUtils.copyDirectory((File)configTemplate, (File)solrBase);
            if (!configFile.isFile()) {
                throw new IllegalStateException("config file '" + configFile.getPath() + "' is missing");
            }
        }
        if (!coreContainerRef.compareAndSet(null, coreContainer = new CoreContainer())) {
            return;
        }
        coreContainer.load(solrBase.getAbsolutePath(), configFile);
        if (!coreContainer.getCoreNames().contains("admin")) {
            coreContainer.create(new CoreDescriptor(coreContainer, "admin", "admin"));
        }
    }

    public void stop() {
        IApplicationContext context;
        if (SolrDebug.embeddedSolrServer) {
            LOG.debug("Stopping embedded Solr server.");
        }
        if ((context = this.runningContext) == null) {
            throw new IllegalStateException("not started");
        }
        CoreContainer coreContainer = coreContainerRef.getAndSet(null);
        if (coreContainer == null) {
            return;
        }
        coreContainer.persist();
        coreContainer.shutdown();
    }
}

