/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.solr.internal;

import org.apache.solr.client.solrj.SolrServer;
import org.eclipse.gyrex.persistence.solr.SolrServerRepository;
import org.eclipse.gyrex.persistence.solr.internal.SolrRepositoryMetrics;
import org.eclipse.gyrex.persistence.solr.internal.SolrRepositoryProvider;
import org.eclipse.gyrex.persistence.solr.internal.SolrServerWithMetrics;
import org.eclipse.gyrex.persistence.storage.provider.RepositoryProvider;
import org.eclipse.osgi.util.NLS;

public class SolrRepository
extends SolrServerRepository {
    static final int IDX_WRITE_SERVER = 0;
    static final int IDX_READ_SERVER = 1;
    private final SolrServer[] solrServers;

    public SolrRepository(String repositoryId, SolrRepositoryProvider repositoryType, SolrServer[] solrServers) throws IllegalArgumentException {
        super(repositoryId, repositoryType, new SolrRepositoryMetrics(SolrRepository.createMetricsId((RepositoryProvider)repositoryType, (String)repositoryId), repositoryId, "open", "repository created"));
        SolrRepositoryMetrics metrics = this.getSolrRepositoryMetrics();
        SolrServerWithMetrics writeServer = new SolrServerWithMetrics(solrServers[0], metrics);
        SolrServerWithMetrics readServer = solrServers[1] != null ? new SolrServerWithMetrics(solrServers[1], metrics) : writeServer;
        this.solrServers = new SolrServer[]{writeServer, readServer};
    }

    protected void doClose() {
        this.getSolrRepositoryMetrics().setClosed("doClose called");
    }

    private SolrServer[] getServers() {
        if (this.solrServers == null) {
            throw new IllegalArgumentException(NLS.bind((String)"Repository {1} isn't configured properly. No solr server found", (Object)this.getRepositoryId()));
        }
        return this.solrServers;
    }

    public SolrRepositoryMetrics getSolrRepositoryMetrics() {
        return (SolrRepositoryMetrics)this.getMetrics();
    }

    @Override
    public SolrServer getSolrServer() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("repository '" + this.getRepositoryId() + "' closed");
        }
        return this.getServers()[0];
    }

    @Override
    public SolrServer getSolrServerOptimizedForQuery() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("repository '" + this.getRepositoryId() + "' closed");
        }
        return this.getServers()[1];
    }
}

