/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.storage.provider;

import java.text.MessageFormat;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.persistence.storage.Repository;
import org.eclipse.gyrex.persistence.storage.settings.IRepositoryPreferences;

public abstract class RepositoryProvider
extends PlatformObject {
    public static final String SERVICE_NAME = RepositoryProvider.class.getName();
    private final String providerId;
    private final Class<? extends Repository> repositoryType;

    protected RepositoryProvider(String id, Class<? extends Repository> repositoryType) {
        if (id == null) {
            throw new IllegalArgumentException("repository provider id must not be null");
        }
        if (!IdHelper.isValidId((String)id)) {
            throw new IllegalArgumentException(MessageFormat.format("repository provider id \"{0}\" is invalid; valid chars are US-ASCII a-z / A-Z / 0-9 / '.' / '-' / '_'", id));
        }
        this.providerId = id;
        if (repositoryType == null) {
            throw new IllegalArgumentException("repository type must not be null");
        }
        if (!IdHelper.isValidId((String)repositoryType.getName())) {
            throw new IllegalArgumentException(MessageFormat.format("repository type name \"{0}\" is invalid; valid chars are US-ASCII a-z / A-Z / 0-9 / '.' / '-' / '_'", repositoryType.getName()));
        }
        this.repositoryType = repositoryType;
    }

    public abstract Repository createRepositoryInstance(String var1, IRepositoryPreferences var2);

    public final String getProviderId() {
        return this.providerId;
    }

    public final Class<? extends Repository> getRepositoryType() {
        return this.repositoryType;
    }

    public final String getRepositoryTypeName() {
        return this.getRepositoryType().getName();
    }

    public final String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " {" + this.getProviderId() + "}";
    }
}

