/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.services.common.provider;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.monitoring.metrics.MetricSet;
import org.eclipse.gyrex.services.common.IService;
import org.eclipse.gyrex.services.common.status.IStatusMonitor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public abstract class BaseService
extends PlatformObject
implements IService {
    private final IRuntimeContext context;
    private final IStatusMonitor statusMonitor;
    private final MetricSet metrics;
    private volatile boolean closed;
    private volatile ServiceRegistration metricsRegistration;

    protected static String createMetricsDescription(String serviceImplementationName, IRuntimeContext context) {
        return String.format("Metrics for %s in context %s.", serviceImplementationName, context.getContextPath());
    }

    protected static String createMetricsId(String serviceImplementationId, IRuntimeContext context) {
        String contextPath = StringUtils.replaceChars((String)context.getContextPath().removeTrailingSeparator().makeRelative().toString(), (char)'/', (char)'.');
        return String.valueOf(serviceImplementationId) + "." + contextPath + ".metrics";
    }

    protected BaseService(IRuntimeContext context, IStatusMonitor statusMonitor, MetricSet metrics) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (statusMonitor == null) {
            throw new IllegalArgumentException("statusMonitor must not be null");
        }
        if (metrics == null) {
            throw new IllegalArgumentException("metrics must not be null");
        }
        this.context = context;
        this.statusMonitor = statusMonitor;
        this.metrics = metrics;
        this.registerMetrics();
    }

    public final void close() {
        this.closed = true;
        try {
            this.doClose();
        }
        finally {
            ServiceRegistration metricsRegistration = this.metricsRegistration;
            if (metricsRegistration != null) {
                metricsRegistration.unregister();
                this.metricsRegistration = null;
            }
        }
    }

    protected void doClose() {
    }

    public Object getAdapter(Class adapter) {
        Object contextAdapter = this.getContext().getAdapter(adapter);
        if (contextAdapter != null) {
            return contextAdapter;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public final IRuntimeContext getContext() {
        return this.context;
    }

    protected final MetricSet getMetrics() {
        return this.metrics;
    }

    protected final IStatusMonitor getStatusMonitor() {
        return this.statusMonitor;
    }

    public final boolean isClosed() {
        return this.closed;
    }

    private void registerMetrics() throws IllegalArgumentException, IllegalStateException {
        BundleContext bundleContext;
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        BundleContext bundleContext2 = bundleContext = bundle != null ? bundle.getBundleContext() : null;
        if (bundleContext == null) {
            throw new IllegalStateException("Unable to determin bundle context for class '" + this.getClass().getName() + "'. Please ensure that this class was loaded by a bundle which is either STARTING, ACTIVE or STOPPING.");
        }
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        ((Dictionary)properties).put("service.vendor", this.getClass().getName());
        ((Dictionary)properties).put("service.description", "Metrics for service implementation '" + this.getClass().getName() + "'.");
        ((Dictionary)properties).put("gyrex.context.path", this.getContext().getContextPath().toString());
        this.metricsRegistration = bundleContext.registerService(MetricSet.class.getName(), (Object)this.metrics, properties);
    }
}

