/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport.http.apache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.transport.http.apache.TemporaryBufferEntity;
import org.eclipse.jgit.transport.http.apache.internal.HttpApacheText;
import org.eclipse.jgit.util.TemporaryBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientConnection
implements HttpConnection {
    HttpClient client;
    String urlStr;
    HttpUriRequest req;
    HttpResponse resp = null;
    String method = "GET";
    private TemporaryBufferEntity entity;
    private boolean isUsingProxy = false;
    private Proxy proxy;
    private Integer timeout = null;
    private Integer readTimeout;
    private Boolean followRedirects;
    private X509HostnameVerifier hostnameverifier;
    SSLContext ctx;

    private HttpClient getClient() {
        if (this.client == null) {
            this.client = new DefaultHttpClient();
        }
        HttpParams params = this.client.getParams();
        if (this.proxy != null && !Proxy.NO_PROXY.equals(this.proxy)) {
            this.isUsingProxy = true;
            InetSocketAddress adr = (InetSocketAddress)this.proxy.address();
            params.setParameter("http.route.default-proxy", (Object)new HttpHost(adr.getHostName(), adr.getPort()));
        }
        if (this.timeout != null) {
            params.setIntParameter("http.connection.timeout", this.timeout.intValue());
        }
        if (this.readTimeout != null) {
            params.setIntParameter("http.socket.timeout", this.readTimeout.intValue());
        }
        if (this.followRedirects != null) {
            params.setBooleanParameter("http.protocol.handle-redirects", this.followRedirects.booleanValue());
        }
        if (this.hostnameverifier != null) {
            SSLSocketFactory sf = new SSLSocketFactory(this.getSSLContext(), this.hostnameverifier);
            Scheme https = new Scheme("https", 443, (SchemeSocketFactory)sf);
            this.client.getConnectionManager().getSchemeRegistry().register(https);
        }
        return this.client;
    }

    private SSLContext getSSLContext() {
        if (this.ctx == null) {
            try {
                this.ctx = SSLContext.getInstance("TLS");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(HttpApacheText.get().unexpectedSSLContextException, e);
            }
        }
        return this.ctx;
    }

    public void setBuffer(TemporaryBuffer buffer) {
        this.entity = new TemporaryBufferEntity(buffer);
    }

    public HttpClientConnection(String urlStr) {
        this(urlStr, null);
    }

    public HttpClientConnection(String urlStr, Proxy proxy) {
        this(urlStr, proxy, null);
    }

    public HttpClientConnection(String urlStr, Proxy proxy, HttpClient cl) {
        this.client = cl;
        this.urlStr = urlStr;
        this.proxy = proxy;
    }

    public int getResponseCode() throws IOException {
        this.execute();
        return this.resp.getStatusLine().getStatusCode();
    }

    public URL getURL() {
        try {
            return new URL(this.urlStr);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getResponseMessage() throws IOException {
        this.execute();
        return this.resp.getStatusLine().getReasonPhrase();
    }

    private void execute() throws IOException, ClientProtocolException {
        if (this.resp == null) {
            if (this.entity != null) {
                if (this.req instanceof HttpEntityEnclosingRequest) {
                    HttpEntityEnclosingRequest eReq = (HttpEntityEnclosingRequest)this.req;
                    eReq.setEntity((HttpEntity)this.entity);
                }
                this.resp = this.getClient().execute(this.req);
                this.entity.getBuffer().close();
                this.entity = null;
            } else {
                this.resp = this.getClient().execute(this.req);
            }
        }
    }

    public Map<String, List<String>> getHeaderFields() {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        for (Header hdr : this.resp.getAllHeaders()) {
            LinkedList<String> list = new LinkedList<String>();
            for (HeaderElement hdrElem : hdr.getElements()) {
                list.add(hdrElem.toString());
            }
            ret.put(hdr.getName(), list);
        }
        return ret;
    }

    public void setRequestProperty(String name, String value) {
        this.req.addHeader(name, value);
    }

    public void setRequestMethod(String method) throws ProtocolException {
        this.method = method;
        if ("GET".equalsIgnoreCase(method)) {
            this.req = new HttpGet(this.urlStr);
        } else if ("PUT".equalsIgnoreCase(method)) {
            this.req = new HttpPut(this.urlStr);
        } else if ("POST".equalsIgnoreCase(method)) {
            this.req = new HttpPost(this.urlStr);
        } else {
            this.method = null;
            throw new UnsupportedOperationException();
        }
    }

    public void setUseCaches(boolean usecaches) {
    }

    public void setConnectTimeout(int timeout) {
        this.timeout = new Integer(timeout);
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = new Integer(readTimeout);
    }

    public String getContentType() {
        Header contentType;
        HttpEntity responseEntity = this.resp.getEntity();
        if (responseEntity != null && (contentType = responseEntity.getContentType()) != null) {
            return contentType.getValue();
        }
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return this.resp.getEntity().getContent();
    }

    public String getHeaderField(String name) {
        Header header = this.resp.getFirstHeader(name);
        return header == null ? null : header.getValue();
    }

    public int getContentLength() {
        return Integer.parseInt(this.resp.getFirstHeader("content-length").getValue());
    }

    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.followRedirects = new Boolean(followRedirects);
    }

    public void setDoOutput(boolean dooutput) {
    }

    public void setFixedLengthStreamingMode(int contentLength) {
        if (this.entity != null) {
            throw new IllegalArgumentException();
        }
        this.entity = new TemporaryBufferEntity((TemporaryBuffer)new TemporaryBuffer.LocalFile(null));
        this.entity.setContentLength(contentLength);
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.entity == null) {
            this.entity = new TemporaryBufferEntity((TemporaryBuffer)new TemporaryBuffer.LocalFile(null));
        }
        return this.entity.getBuffer();
    }

    public void setChunkedStreamingMode(int chunklen) {
        if (this.entity == null) {
            this.entity = new TemporaryBufferEntity((TemporaryBuffer)new TemporaryBuffer.LocalFile(null));
        }
        this.entity.setChunked(true);
    }

    public String getRequestMethod() {
        return this.method;
    }

    public boolean usingProxy() {
        return this.isUsingProxy;
    }

    public void connect() throws IOException {
        this.execute();
    }

    public void setHostnameVerifier(final HostnameVerifier hostnameverifier) {
        this.hostnameverifier = new X509HostnameVerifier(){

            public boolean verify(String hostname, SSLSession session) {
                return hostnameverifier.verify(hostname, session);
            }

            public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                throw new UnsupportedOperationException();
            }

            public void verify(String host, X509Certificate cert) throws SSLException {
                throw new UnsupportedOperationException();
            }

            public void verify(String host, SSLSocket ssl) throws IOException {
                hostnameverifier.verify(host, ssl.getSession());
            }
        };
    }

    public void configure(KeyManager[] km, TrustManager[] tm, SecureRandom random) throws KeyManagementException {
        this.getSSLContext().init(km, tm, random);
    }
}

