/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.gen;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jpt.common.core.gen.JptGenerator;
import org.eclipse.jpt.common.core.gen.LaunchConfigListener;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.ui.internal.swt.widgets.DisplayTools;
import org.eclipse.jpt.common.utility.internal.reference.SynchronizedBoolean;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public abstract class AbstractJptGenerateJob
extends WorkspaceJob {
    private final IJavaProject javaProject;
    final SynchronizedBoolean generationCompleted;
    boolean generationSuccessful;

    public AbstractJptGenerateJob(String name, IJavaProject javaProject) {
        super(name);
        this.javaProject = javaProject;
        this.generationCompleted = new SynchronizedBoolean(false);
        this.generationSuccessful = false;
        IResourceRuleFactory ruleFactory = this.javaProject.getProject().getWorkspace().getRuleFactory();
        this.setRule(ruleFactory.modifyRule((IResource)this.javaProject.getProject()));
    }

    protected abstract JptGenerator buildGenerator();

    protected abstract void postGenerate();

    protected abstract String getJobName();

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getJobName(), (int)1);
        try {
            this.generate((IProgressMonitor)sm.newChild(1));
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (RuntimeException re) {
            this.logException(re);
        }
        return Status.OK_STATUS;
    }

    protected void jptPluginLogException(Exception exception) {
    }

    protected void refreshProject() {
        try {
            this.getJavaProject().getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            this.logException((Exception)((Object)e));
        }
    }

    protected void logException(Exception exception) {
        String msg = exception.getMessage();
        String message = msg == null ? exception.toString() : msg;
        this.displayError(message);
        this.jptPluginLogException(exception);
    }

    protected IJavaProject getJavaProject() {
        return this.javaProject;
    }

    protected void openEditor(final IFile file) {
        if (file != null) {
            DisplayTools.asyncExec(new Runnable(){

                public void run() {
                    try {
                        IWorkbenchPage page = WorkbenchTools.getActivePage();
                        if (page != null) {
                            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                        }
                    }
                    catch (PartInitException e) {
                        AbstractJptGenerateJob.this.logException((Exception)((Object)e));
                    }
                }
            });
        }
    }

    private void generate(IProgressMonitor monitor) {
        block7: {
            JptGenerator generator = this.buildGenerator();
            LaunchConfigListener launchListener = this.buildLaunchListener();
            generator.addLaunchConfigListener(launchListener);
            generator.generate(monitor);
            try {
                try {
                    this.generationCompleted.waitUntilTrue();
                }
                catch (InterruptedException e) {
                    this.logException(e);
                    generator.removeLaunchConfigListener(launchListener);
                    this.generationCompleted.setFalse();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                generator.removeLaunchConfigListener(launchListener);
                this.generationCompleted.setFalse();
                throw throwable;
            }
            generator.removeLaunchConfigListener(launchListener);
            this.generationCompleted.setFalse();
        }
        if (this.generationSuccessful) {
            this.postGenerate();
        } else {
            this.displayError(JptCommonUiMessages.ABSTRACT_JPT_GENERATE_JOB__GENERATION_FAILED);
        }
    }

    private LaunchConfigListener buildLaunchListener() {
        return new LaunchConfigListener(){

            public void launchCompleted(boolean genSuccessful) {
                AbstractJptGenerateJob.this.generationSuccessful = genSuccessful;
                AbstractJptGenerateJob.this.generationCompleted.setTrue();
            }
        };
    }

    private void displayError(final String message) {
        DisplayTools.syncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)AbstractJptGenerateJob.this.getShell(), (String)JptCommonUiMessages.ABSTRACT_JPT_GENERATE_JOB__ERROR, (String)message);
            }
        });
    }

    Shell getShell() {
        Shell[] shells;
        Shell shell;
        Display display = Display.getCurrent();
        Shell shell2 = shell = display == null ? null : display.getActiveShell();
        if (shell == null && display != null && (shells = display.getShells()).length > 0) {
            shell = shells[0];
        }
        return shell;
    }
}

