/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jpt.common.utility.collection.Queue;
import org.eclipse.jpt.common.utility.collection.Stack;
import org.eclipse.jpt.common.utility.internal.collection.ArrayQueue;
import org.eclipse.jpt.common.utility.internal.collection.ArrayStack;
import org.eclipse.jpt.common.utility.internal.collection.EmptyQueue;
import org.eclipse.jpt.common.utility.internal.collection.LinkedQueue;
import org.eclipse.jpt.common.utility.internal.collection.PriorityQueue;
import org.eclipse.jpt.common.utility.internal.collection.StackQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueueTools {
    public static <Q extends Queue<? super E>, E> Q enqueueAll(Q queue, Iterable<? extends E> iterable) {
        return QueueTools.enqueueAll(queue, iterable.iterator());
    }

    public static <Q extends Queue<? super E>, E> Q enqueueAll(Q queue, Iterator<? extends E> iterator) {
        while (iterator.hasNext()) {
            queue.enqueue(iterator.next());
        }
        return queue;
    }

    public static <Q extends Queue<? super E>, E> Q enqueueAll(Q queue, E ... array) {
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E element = EArray[n2];
            queue.enqueue(element);
            ++n2;
        }
        return queue;
    }

    public static <Q extends Queue<? super E>, E> Q enqueueAll(Q queue, Stack<? extends E> stack) {
        while (!stack.isEmpty()) {
            queue.enqueue(stack.pop());
        }
        return queue;
    }

    public static <Q extends Queue<? super E>, E> Q enqueueAll(Q queue1, Queue<? extends E> queue2) {
        while (!queue2.isEmpty()) {
            queue1.enqueue(queue2.dequeue());
        }
        return queue1;
    }

    public static <E> ArrayList<E> drain(Queue<? extends E> queue) {
        return QueueTools.drainTo(queue, new ArrayList());
    }

    public static <C extends Collection<? super E>, E> C drainTo(Queue<? extends E> queue, C collection) {
        while (!queue.isEmpty()) {
            collection.add(queue.dequeue());
        }
        return collection;
    }

    public static <S extends Stack<? super E>, E> S drainTo(Queue<? extends E> queue, S stack) {
        while (!queue.isEmpty()) {
            stack.push(queue.dequeue());
        }
        return stack;
    }

    public static <Q extends Queue<? super E>, E> Q drainTo(Queue<? extends E> queue1, Q queue2) {
        while (!queue1.isEmpty()) {
            queue2.enqueue(queue1.dequeue());
        }
        return queue2;
    }

    public static <E> ArrayQueue<E> queue(Iterable<? extends E> iterable) {
        return QueueTools.arrayQueue(iterable);
    }

    public static <E> ArrayQueue<E> queue(Iterable<? extends E> iterable, int iterableSize) {
        return QueueTools.arrayQueue(iterable, iterableSize);
    }

    public static <E> ArrayQueue<E> queue(Iterator<? extends E> iterator) {
        return QueueTools.arrayQueue(iterator);
    }

    public static <E> ArrayQueue<E> queue(Iterator<? extends E> iterator, int iteratorSize) {
        return QueueTools.arrayQueue(iterator, iteratorSize);
    }

    public static <E> ArrayQueue<E> queue(E ... array) {
        return QueueTools.arrayQueue(array);
    }

    public static <E> ArrayQueue<E> arrayQueue(Iterable<? extends E> iterable) {
        return QueueTools.arrayQueue(iterable.iterator());
    }

    public static <E> ArrayQueue<E> arrayQueue(Iterable<? extends E> iterable, int iterableSize) {
        return QueueTools.arrayQueue(iterable.iterator(), iterableSize);
    }

    public static <E> ArrayQueue<E> arrayQueue(Iterator<? extends E> iterator) {
        return QueueTools.enqueueAll(new ArrayQueue(), iterator);
    }

    public static <E> ArrayQueue<E> arrayQueue(Iterator<? extends E> iterator, int iteratorSize) {
        return QueueTools.enqueueAll(new ArrayQueue(iteratorSize), iterator);
    }

    public static <E> ArrayQueue<E> arrayQueue(E ... array) {
        return QueueTools.enqueueAll(new ArrayQueue(array.length), array);
    }

    public static <E> LinkedQueue<E> linkedQueue(Iterable<? extends E> iterable) {
        return QueueTools.linkedQueue(iterable.iterator());
    }

    public static <E> LinkedQueue<E> linkedQueue(Iterator<? extends E> iterator) {
        return QueueTools.enqueueAll(new LinkedQueue(), iterator);
    }

    public static <E> LinkedQueue<E> linkedQueue(E ... array) {
        return QueueTools.enqueueAll(new LinkedQueue(), array);
    }

    public static <E> StackQueue<E> stackQueue() {
        return QueueTools.queue(new ArrayStack());
    }

    public static <E> StackQueue<E> queue(Stack<E> stack) {
        return new StackQueue<E>(stack);
    }

    public static <E> PriorityQueue<E> priorityQueue() {
        return QueueTools.queue(null);
    }

    public static <E> PriorityQueue<E> queue(Comparator<? super E> comparator) {
        return QueueTools.queue(new TreeSet<E>(comparator));
    }

    public static <E> PriorityQueue<E> queue(SortedSet<E> elements) {
        return new PriorityQueue<E>(elements);
    }

    public static <E> Queue<E> emptyQueue() {
        return EmptyQueue.instance();
    }

    private QueueTools() {
        throw new UnsupportedOperationException();
    }
}

