/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementListIterable;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.VirtualJoinColumn;
import org.eclipse.jpt.jpa.core.context.VirtualJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinColumnRelationship;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaJoinColumnRelationshipStrategy<P extends JavaJoinColumnRelationship>
extends AbstractJavaContextModel<P>
implements JavaSpecifiedJoinColumnRelationshipStrategy {
    protected final AbstractJpaContextModel.ContextListContainer<JavaSpecifiedJoinColumn, JoinColumnAnnotation> specifiedJoinColumnContainer;
    protected final JoinColumn.ParentAdapter joinColumnParentAdapter = this.buildJoinColumnParentAdapter();
    protected JavaSpecifiedJoinColumn defaultJoinColumn;

    protected AbstractJavaJoinColumnRelationshipStrategy(P parent) {
        super(parent);
        this.specifiedJoinColumnContainer = this.buildSpecifiedJoinColumnContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncSpecifiedJoinColumns();
    }

    @Override
    public void update() {
        super.update();
        this.updateModels((Iterable<? extends JpaContextModel>)this.getSpecifiedJoinColumns());
        this.updateDefaultJoinColumn();
    }

    @Override
    public ListIterable<JavaSpecifiedJoinColumn> getJoinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumns() : this.getDefaultJoinColumns();
    }

    @Override
    public int getJoinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumnsSize() : this.getDefaultJoinColumnsSize();
    }

    @Override
    public ListIterable<JavaSpecifiedJoinColumn> getSpecifiedJoinColumns() {
        return this.specifiedJoinColumnContainer;
    }

    @Override
    public int getSpecifiedJoinColumnsSize() {
        return this.specifiedJoinColumnContainer.size();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return this.getSpecifiedJoinColumnsSize() != 0;
    }

    @Override
    public JavaSpecifiedJoinColumn getSpecifiedJoinColumn(int index) {
        return (JavaSpecifiedJoinColumn)this.specifiedJoinColumnContainer.get(index);
    }

    @Override
    public JavaSpecifiedJoinColumn addSpecifiedJoinColumn() {
        return this.addSpecifiedJoinColumn(this.getSpecifiedJoinColumnsSize());
    }

    @Override
    public JavaSpecifiedJoinColumn addSpecifiedJoinColumn(int index) {
        JoinColumnAnnotation annotation = this.addJoinColumnAnnotation(index);
        return (JavaSpecifiedJoinColumn)this.specifiedJoinColumnContainer.addContextElement(index, annotation);
    }

    @Override
    public void removeSpecifiedJoinColumn(SpecifiedJoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumnContainer.indexOf((JavaSpecifiedJoinColumn)joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        this.removeJoinColumnAnnotation(index);
        this.specifiedJoinColumnContainer.remove(index);
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        this.moveJoinColumnAnnotation(targetIndex, sourceIndex);
        this.specifiedJoinColumnContainer.move(targetIndex, sourceIndex);
    }

    @Override
    public void convertDefaultJoinColumnsToSpecified() {
        if (this.defaultJoinColumn == null) {
            throw new IllegalStateException("default join column is null");
        }
        String columnName = this.defaultJoinColumn.getDefaultName();
        String referencedColumnName = this.defaultJoinColumn.getDefaultReferencedColumnName();
        JavaSpecifiedJoinColumn joinColumn = this.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName(columnName);
        joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
    }

    @Override
    public void clearSpecifiedJoinColumns() {
        int index = this.getSpecifiedJoinColumnsSize();
        while (--index >= 0) {
            this.removeJoinColumnAnnotation(index);
        }
        this.specifiedJoinColumnContainer.clear();
    }

    protected void syncSpecifiedJoinColumns() {
        this.specifiedJoinColumnContainer.synchronizeWithResourceModel();
    }

    protected AbstractJpaContextModel.ContextListContainer<JavaSpecifiedJoinColumn, JoinColumnAnnotation> buildSpecifiedJoinColumnContainer() {
        return this.buildSpecifiedContextListContainer("specifiedJoinColumns", new SpecifiedJoinColumnContainerAdapter());
    }

    protected abstract JoinColumn.ParentAdapter buildJoinColumnParentAdapter();

    @Override
    public JavaSpecifiedJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(JavaSpecifiedJoinColumn joinColumn) {
        JavaSpecifiedJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = joinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, joinColumn);
    }

    protected ListIterable<JavaSpecifiedJoinColumn> getDefaultJoinColumns() {
        return this.defaultJoinColumn != null ? new SingleElementListIterable((Object)this.defaultJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultJoinColumn() {
        if (this.buildsDefaultJoinColumn()) {
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(this.buildNullJoinColumnAnnotation()));
            } else {
                this.defaultJoinColumn.update();
            }
        } else {
            this.setDefaultJoinColumn(null);
        }
    }

    protected boolean buildsDefaultJoinColumn() {
        return !this.hasSpecifiedJoinColumns() && this.getRelationship().mayHaveDefaultJoinColumn();
    }

    protected abstract ListIterable<JoinColumnAnnotation> getJoinColumnAnnotations();

    protected abstract JoinColumnAnnotation addJoinColumnAnnotation(int var1);

    protected abstract void removeJoinColumnAnnotation(int var1);

    protected abstract void moveJoinColumnAnnotation(int var1, int var2);

    protected abstract JoinColumnAnnotation buildNullJoinColumnAnnotation();

    @Override
    public JavaJoinColumnRelationship getRelationship() {
        return (JavaJoinColumnRelationship)this.parent;
    }

    protected JavaSpecifiedJoinColumn buildJoinColumn(JoinColumnAnnotation joinColumnAnnotation) {
        return this.getJpaFactory().buildJavaJoinColumn(this.joinColumnParentAdapter, joinColumnAnnotation);
    }

    @Override
    public void initializeFrom(VirtualJoinColumnRelationshipStrategy virtualStrategy) {
        for (VirtualJoinColumn joinColumn : virtualStrategy.getJoinColumns()) {
            this.addSpecifiedJoinColumn().initializeFrom(joinColumn);
        }
    }

    public RelationshipMapping getRelationshipMapping() {
        return this.getRelationship().getMapping();
    }

    @Override
    public String getTableName() {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping == null ? null : typeMapping.getPrimaryTableName();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping == null ? null : typeMapping.resolveDbTable(tableName);
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping != null && typeMapping.tableNameIsInvalid(tableName);
    }

    public Table getReferencedColumnDbTable() {
        TypeMapping relationshipTarget = this.getRelationshipTarget();
        return relationshipTarget == null ? null : relationshipTarget.getPrimaryDbTable();
    }

    protected Iterable<String> getCandidateTableNames() {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping != null ? typeMapping.getAllAssociatedTableNames() : EmptyIterable.instance();
    }

    @Override
    public void addStrategy() {
        if (this.getSpecifiedJoinColumnsSize() == 0) {
            this.addSpecifiedJoinColumn();
        }
    }

    @Override
    public void removeStrategy() {
        int i = this.getSpecifiedJoinColumnsSize();
        while (i-- > 0) {
            this.removeSpecifiedJoinColumn(i);
        }
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        for (JavaSpecifiedJoinColumn joinColumn : this.getJoinColumns()) {
            result = joinColumn.getCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        for (JavaSpecifiedJoinColumn joinColumn : this.getJoinColumns()) {
            joinColumn.validate(messages, reporter);
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getRelationship().getValidationTextRange();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SpecifiedJoinColumnContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<JavaSpecifiedJoinColumn, JoinColumnAnnotation> {
        public SpecifiedJoinColumnContainerAdapter() {
            super(AbstractJavaJoinColumnRelationshipStrategy.this);
        }

        @Override
        public JavaSpecifiedJoinColumn buildContextElement(JoinColumnAnnotation resourceElement) {
            return AbstractJavaJoinColumnRelationshipStrategy.this.buildJoinColumn(resourceElement);
        }

        @Override
        public ListIterable<JoinColumnAnnotation> getResourceElements() {
            return AbstractJavaJoinColumnRelationshipStrategy.this.getJoinColumnAnnotations();
        }

        @Override
        public JoinColumnAnnotation extractResourceElement(JavaSpecifiedJoinColumn contextElement) {
            return (JoinColumnAnnotation)contextElement.getColumnAnnotation();
        }
    }
}

